/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.paymonitor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.risk.RiskRpcResp;
import kd.tmc.fcs.common.enums.ScreenItemEnum;
import kd.tmc.fcs.common.helper.RiskServiceHelper;
import kd.tmc.fcs.mservice.paymonitor.GaussianService;
import kd.tmc.fcs.mservice.paymonitor.ProPhetService;
import kd.tmc.fcs.mservice.paymonitor.RelationShipService;
import kd.tmc.fcs.mservice.paymonitor.TradeInterChangeService;
import kd.tmc.fcs.mservice.similarity.BusinessDiagnosisService;

public class RiskRpcService {
    private static final Log logger = LogFactory.getLog(RiskRpcService.class);
    private final Map<String, BiFunction<List, DynamicObject, List<RiskItemResult>>> ITEM_PROXY_MAP = new HashMap<String, BiFunction<List, DynamicObject, List<RiskItemResult>>>(16);

    public RiskRpcService() {
        BusinessDiagnosisService diagnosisService = new BusinessDiagnosisService();
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.TRADE_ONESELF.getValue(), diagnosisService::diagnosis);
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.GROUP_BUSINESS.getValue(), diagnosisService::diagnosis);
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.TRADE_AMOUNT.getValue(), new GaussianService()::diagnosis);
        ProPhetService proPhetService = new ProPhetService();
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.TRADE_FREQUENCY.getValue(), proPhetService::diagnosisDate);
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.TRADE_TIME.getValue(), proPhetService::diagnosisTimeZone);
        RelationShipService relationShipService = new RelationShipService();
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.RECPAY_RELATION.getValue(), relationShipService::diagnosisSelf);
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.UNIT_RELATION.getValue(), relationShipService::diagnosisRelation);
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.BUSINESS_RELATION.getValue(), relationShipService::diagnosisRelation);
        TradeInterChangeService tradeInterChangeService = new TradeInterChangeService();
        this.ITEM_PROXY_MAP.put(ScreenItemEnum.TRADE_INTERCHANGE.getValue(), tradeInterChangeService::diagnosisChange);
    }

    public RiskRpcResp invokeRpc(List<?> billList, DynamicObject itemConfig) {
        RiskRpcResp riskRpcResp = new RiskRpcResp();
        try {
            String item = itemConfig.getString("screenitem");
            List<RiskItemResult> itemResults = this.ITEM_PROXY_MAP.get(item).apply(billList, itemConfig);
            riskRpcResp.setCode("success");
            riskRpcResp.setResultList(itemResults);
        }
        catch (Exception e) {
            logger.error("invoke rpc error:", (Throwable)e);
            String message = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            message = message.length() > 2000 ? message.substring(0, 1995) + "..." : message;
            riskRpcResp.setCode("error");
            riskRpcResp.setMessage(message);
            riskRpcResp.setResultList(Collections.emptyList());
        }
        return riskRpcResp;
    }

    public void asyncExecTask(String scheduleCycle, String scheduleDateRange, Long proposalId) {
        RiskServiceHelper.asyncExecProposal((String)scheduleCycle, (String)scheduleDateRange, (Long)proposalId);
    }
}

