/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.paymonitor;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.graph.Edge;
import kd.tmc.fbp.common.graph.Graph;
import kd.tmc.fbp.common.graph.Path;
import kd.tmc.fbp.common.graph.Vertex;
import kd.tmc.fbp.common.helper.TmcCacheHelper;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.TradeInterChangeConfig;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.RiskChangeServiceHelper;
import kd.tmc.fcs.common.model.RiskAmountBean;
import kd.tmc.fcs.common.model.RiskAmountCacheBean;
import org.apache.commons.lang3.tuple.Pair;

public class TradeInterChangeService {
    private static final DistributeSessionlessCache cache = TmcCacheHelper.getSessionlessCacheInstance();
    private static final Log logger = LogFactory.getLog(TradeInterChangeService.class);
    private AtomicBoolean isQuerying = new AtomicBoolean(false);

    public List<RiskItemResult> diagnosisChange(List<DynamicObject> billList, DynamicObject riskItemConfig) {
        ArrayList<RiskItemResult> resultList = new ArrayList<RiskItemResult>(10);
        List configList = TradeInterChangeConfig.loadFromDynamicObject((DynamicObject)riskItemConfig);
        for (TradeInterChangeConfig config : configList) {
            HashSet<RiskAmountBean> leftAmountSet = new HashSet<RiskAmountBean>(10);
            Map<Long, DynamicObject> billMaps = billList.stream().collect(Collectors.toMap(o -> o.getLong("id"), e -> e));
            TradeInterChangeService.genAmountBeansList(leftAmountSet, billList, config, "pay");
            Set<Object> amountSet = billList.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get(config.getPayAmount())) && new BigDecimal(String.valueOf(o.get(config.getPayAmount()))).compareTo(BigDecimal.ZERO) != 0).map(s -> s.get(config.getPayAmount())).collect(Collectors.toSet());
            boolean sameBill = config.isSameBill();
            if (sameBill) {
                amountSet.addAll(billList.stream().filter(o -> EmptyUtil.isNoEmpty((Object)o.get(config.getRecAmount())) && new BigDecimal(String.valueOf(o.get(config.getRecAmount()))).compareTo(BigDecimal.ZERO) != 0).map(s -> s.get(config.getRecAmount())).collect(Collectors.toSet()));
            }
            Map<String, List<RiskAmountCacheBean>> rightCachehMap = this.getRightGraphMap(amountSet, config);
            Map<String, Graph> rightGraphhMap = this.drawGraphInfoByMap(rightCachehMap);
            ArrayList<List<Path>> resultPath = new ArrayList<List<Path>>(16);
            long startTime = System.currentTimeMillis();
            if (EmptyUtil.isNoEmpty(leftAmountSet) && !rightCachehMap.isEmpty()) {
                Map<String, List<RiskAmountBean>> amountGroup = leftAmountSet.stream().filter(s -> EmptyUtil.isNoEmpty((String)s.getAmount())).collect(Collectors.groupingBy(RiskAmountBean::getAmount));
                for (Map.Entry<String, List<RiskAmountBean>> entry : amountGroup.entrySet()) {
                    String entryKey = entry.getKey();
                    Graph graph = rightGraphhMap.getOrDefault(entryKey, null);
                    if (graph == null) continue;
                    TradeInterChangeService.drawGraphInfo(entry.getValue(), graph);
                    Pair cycles = graph.findCycles();
                    resultPath.addAll((Collection)cycles.getRight());
                }
            }
            logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u5185\u5b58\u8ba1\u7b97\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
            TradeInterChangeService.dealResultInfo(resultList, resultPath, billMaps, config);
        }
        return resultList;
    }

    private Map<String, List<RiskAmountCacheBean>> getRightGraphMap(Set<Object> amountSet, TradeInterChangeConfig config) {
        String paramValue = RiskChangeServiceHelper.loadRiskParamValue((String)"UseCacheData");
        if ("true".equals(paramValue)) {
            return this.getRightGraphMapUseCache(config);
        }
        return this.getRightGraphMapUseAmountFilter(amountSet, config);
    }

    private Map<String, List<RiskAmountCacheBean>> getRightGraphMapUseCache(TradeInterChangeConfig config) {
        String currentDate;
        Map<Object, Object> rightCacheMap = new HashMap(16);
        String currentTime = DateUtils.formatString((Date)DateUtils.getCurrentTime(), (String)"yyyy-MM-dd HH:mm:ss");
        byte[] cacheByte = cache.getByteValue("tmc.fcs.TradeInterChangeService_" + config.getCheckNumber());
        String cacheTimeStr = (String)cache.get("tmc.fcs.TradeInterChangeService.Time_" + config.getCheckNumber());
        if (EmptyUtil.isNoEmpty((String)cacheTimeStr) && !(currentDate = DateUtils.formatString((Date)DateUtils.getCurrentDate(), (String)"yyyy-MM-dd")).equals(cacheTimeStr.substring(0, 10))) {
            cache.remove("tmc.fcs.TradeInterChangeService_" + config.getCheckNumber());
            cache.remove("tmc.fcs.TradeInterChangeService.Time_" + config.getCheckNumber());
        }
        if (EmptyUtil.isNoEmpty((Object)cacheByte)) {
            logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u901a\u8fc7\u7f13\u5b58\u53d6\u6570\u636e");
            try {
                long startTime = System.currentTimeMillis();
                rightCacheMap = this.unzipGraphMap(cacheByte);
                logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u89e3\u538b\u7f13\u5b58\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
            }
            catch (Exception e) {
                logger.error("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u89e3\u538b\u6570\u636e\u5f02\u5e38:", (Throwable)e);
            }
            if (!rightCacheMap.isEmpty()) {
                Date time = DateUtils.stringToDate((String)cacheTimeStr, (String)"yyyy-MM-dd HH:mm:ss");
                QFilter qFilter = new QFilter("createtime", ">=", (Object)time);
                qFilter.and("createtime", "<=", (Object)DateUtils.stringToDate((String)currentTime, (String)"yyyy-MM-dd HH:mm:ss"));
                Set<RiskAmountBean> newAmountSet = TradeInterChangeService.queryReverseInfo(config, qFilter);
                if (EmptyUtil.isNoEmpty(newAmountSet)) {
                    Map<String, List<RiskAmountBean>> amountGroup = newAmountSet.stream().filter(s -> EmptyUtil.isNoEmpty((String)s.getAmount())).collect(Collectors.groupingBy(RiskAmountBean::getAmount));
                    for (Map.Entry<String, List<RiskAmountBean>> entry : amountGroup.entrySet()) {
                        this.putCacheMap(rightCacheMap, entry);
                    }
                    TradeInterChangeService.cacheRiskAmountInfo(rightCacheMap, config, currentTime);
                }
            }
        } else if (this.isQuerying.compareAndSet(false, true)) {
            try {
                Set<RiskAmountBean> rightAmountSet = TradeInterChangeService.queryReverseInfo(config, null);
                if (EmptyUtil.isNoEmpty(rightAmountSet)) {
                    Map<String, List<RiskAmountBean>> amountGroup = rightAmountSet.stream().filter(s -> EmptyUtil.isNoEmpty((String)s.getAmount())).collect(Collectors.groupingBy(RiskAmountBean::getAmount));
                    for (Map.Entry<String, List<RiskAmountBean>> entry : amountGroup.entrySet()) {
                        this.putCacheMap(rightCacheMap, entry);
                    }
                    TradeInterChangeService.cacheRiskAmountInfo(rightCacheMap, config, currentTime);
                }
                this.isQuerying.set(false);
            }
            catch (Exception e) {
                this.isQuerying.set(false);
                logger.error("\u907f\u514d\u51fa\u73b0\u5f02\u5e38\u7ebf\u7a0b\u6b7b\u9501...");
            }
        } else {
            while (this.isQuerying.get()) {
                logger.info("\u67e5\u8be2\u7f13\u5b58\u7ebf\u7a0b\u6b63\u5728\u6267\u884c...\u5176\u4ed6\u7ebf\u7a0b\u7b49\u5f85\u6267\u884c...");
            }
            return this.getRightGraphMapUseCache(config);
        }
        return rightCacheMap;
    }

    private Map<String, List<RiskAmountCacheBean>> getRightGraphMapUseAmountFilter(Set<Object> amountSet, TradeInterChangeConfig config) {
        HashMap<String, List<RiskAmountCacheBean>> rightCachehMap = new HashMap<String, List<RiskAmountCacheBean>>(16);
        String reverseProp = "id,billno," + String.join((CharSequence)",", config.getReverseField());
        String objectScope = config.getObjectScope();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        ConditionFactory factory = new ConditionFactory();
        if (EmptyUtil.isNoEmpty((String)objectScope)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)config.getObjectScope(), CRCondition.class);
            factory.init(conditionObj, config.getCheckNumber());
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)config.getCheckNumber());
            FilterBuilder filterBuilder = new FilterBuilder(dataType, conditionObj.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            filterList.add(filterBuilder.getQFilter());
        }
        HashSet<Long> recIds = new HashSet<Long>(16);
        long startTime = System.currentTimeMillis();
        TradeInterChangeService.setQueryByAmountField(recIds, filterList, config.getRecAmount(), config.getCheckNumber(), new ArrayList<Object>(amountSet));
        logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u9006\u5411\u91d1\u989d\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
        if (config.isSameBill()) {
            startTime = System.currentTimeMillis();
            TradeInterChangeService.setQueryByAmountField(recIds, filterList, config.getPayAmount(), config.getCheckNumber(), new ArrayList<Object>(amountSet));
            logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u6b63\u5411\u91d1\u989d\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
        }
        QFilter idFilter = new QFilter("id", "in", recIds);
        startTime = System.currentTimeMillis();
        DynamicObjectCollection reverDatas = QueryServiceHelper.query((String)config.getCheckNumber(), (String)reverseProp, (QFilter[])idFilter.toArray());
        logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bbID\u8fc7\u6ee4\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
        List<Object> reverDataList = new ArrayList<DynamicObject>((Collection<DynamicObject>)reverDatas);
        if (!factory.isExpressionExecuter()) {
            Set reverIds = reverDataList.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
            Set reverMatchIds = factory.runCondition(reverIds);
            reverDataList = reverDatas.stream().filter(s -> reverMatchIds.contains(s.getLong("id"))).collect(Collectors.toList());
        }
        HashSet<RiskAmountBean> rightAmountSet = new HashSet<RiskAmountBean>(16);
        TradeInterChangeService.genAmountBeansList(rightAmountSet, reverDataList, config, "rec");
        if (EmptyUtil.isNoEmpty(rightAmountSet)) {
            Map<String, List<RiskAmountBean>> amountGroup = rightAmountSet.stream().filter(s -> EmptyUtil.isNoEmpty((String)s.getAmount()) && EmptyUtil.isNoEmpty((String)s.getPayAccount()) && EmptyUtil.isNoEmpty((String)s.getRecAccount())).collect(Collectors.groupingBy(RiskAmountBean::getAmount));
            for (Map.Entry<String, List<RiskAmountBean>> entry : amountGroup.entrySet()) {
                this.putCacheMap(rightCachehMap, entry);
            }
        }
        return rightCachehMap;
    }

    private void putCacheMap(Map<String, List<RiskAmountCacheBean>> cacheMap, Map.Entry<String, List<RiskAmountBean>> entry) {
        String cacheKey;
        String amount = entry.getKey();
        HashMap<String, List> tempMap = new HashMap<String, List>(16);
        if (cacheMap.containsKey(amount)) {
            List<RiskAmountCacheBean> cacheBeans = cacheMap.get(amount);
            for (RiskAmountCacheBean riskAmountCacheBean : cacheBeans) {
                cacheKey = riskAmountCacheBean.getPayAccount() + "#" + riskAmountCacheBean.getRecAccount();
                tempMap.computeIfAbsent(cacheKey, k -> new ArrayList()).addAll(riskAmountCacheBean.getIds());
            }
            cacheMap.remove(amount);
        }
        ArrayList<RiskAmountCacheBean> cacheBeanList = new ArrayList<RiskAmountCacheBean>(tempMap.size());
        for (RiskAmountBean riskAmountBean : entry.getValue()) {
            cacheKey = riskAmountBean.getPayAccount() + "#" + riskAmountBean.getRecAccount();
            tempMap.computeIfAbsent(cacheKey, k -> new ArrayList()).add(riskAmountBean.getId());
            RiskAmountCacheBean cacheBean = new RiskAmountCacheBean();
            cacheBean.setPayAccount(riskAmountBean.getPayAccount());
            cacheBean.setRecAccount(riskAmountBean.getRecAccount());
            cacheBean.addAllIds((List)tempMap.get(cacheKey));
            cacheBeanList.add(cacheBean);
        }
        cacheMap.put(entry.getKey(), cacheBeanList);
    }

    private Map<String, Graph> drawGraphInfoByMap(Map<String, List<RiskAmountCacheBean>> rightCachehMap) {
        HashMap<String, Graph> rightGraphhMap = new HashMap<String, Graph>(16);
        for (Map.Entry<String, List<RiskAmountCacheBean>> entry : rightCachehMap.entrySet()) {
            Graph graph = new Graph();
            List<RiskAmountCacheBean> riskAmountCacheBeans = entry.getValue();
            for (RiskAmountCacheBean riskAmountBean : riskAmountCacheBeans) {
                Vertex vertexPay = new Vertex(riskAmountBean.getPayAccount());
                graph.addVertex(vertexPay);
                Vertex vertexRec = new Vertex(riskAmountBean.getRecAccount());
                graph.addVertex(vertexRec);
                graph.addEdge(vertexPay, vertexRec, riskAmountBean.getIds());
            }
            rightGraphhMap.put(entry.getKey(), graph);
        }
        return rightGraphhMap;
    }

    private static void drawGraphInfo(List<RiskAmountBean> riskAmountBeanList, Graph graph) {
        Set payAccountSet = riskAmountBeanList.stream().map(RiskAmountBean::getPayAccount).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        Set recAccountSet = riskAmountBeanList.stream().map(RiskAmountBean::getRecAccount).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        payAccountSet.addAll(recAccountSet);
        for (String account : payAccountSet) {
            Vertex vertex = new Vertex(account);
            graph.addVertex(vertex);
        }
        for (RiskAmountBean riskAmountBean : riskAmountBeanList) {
            Vertex recAccountVertex;
            String payAccount = riskAmountBean.getPayAccount();
            String recAccount = riskAmountBean.getRecAccount();
            if (!EmptyUtil.isNoEmpty((String)payAccount) || !EmptyUtil.isNoEmpty((String)recAccount)) continue;
            Long billId = riskAmountBean.getId();
            Vertex payAccountVertex = graph.findVertexByName(payAccount);
            Edge edge = payAccountVertex.findEdge(recAccountVertex = graph.findVertexByName(recAccount));
            if (edge == null) {
                HashSet<Long> set = new HashSet<Long>(2);
                set.add(billId);
                graph.addEdge(payAccountVertex, recAccountVertex, set);
                continue;
            }
            edge.getIds().add(billId);
        }
    }

    private static void dealResultInfo(List<RiskItemResult> resultList, List<List<Path>> resultPath, Map<Long, DynamicObject> billMaps, TradeInterChangeConfig config) {
        if (!resultPath.isEmpty()) {
            HashSet errorSet = new HashSet(10);
            Set<Long> billIds = resultPath.stream().flatMap(Collection::stream).flatMap(path -> path.getIds().stream()).collect(Collectors.toSet());
            billIds.forEach(id -> {
                if (billMaps.containsKey(id)) {
                    errorSet.add(id);
                }
            });
            for (Long errorId : errorSet) {
                RiskItemResult riskItemResult = new RiskItemResult();
                riskItemResult.setDataType(config.getBillNumber());
                riskItemResult.setBillId(errorId);
                riskItemResult.setBillNo(billMaps.get(errorId).getString("billno"));
                riskItemResult.setErrorDescDetail(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u8be5\u7b14\u4ea4\u6613\u5bf9\u65b9\u5355\u4f4d\u4e0e\u8fc7\u5f80\u5df2\u53d1\u751f\u4ea4\u6613\u7684\u5bf9\u65b9\u5355\u4f4d\u95f4\u5b58\u5728\u5212\u6765\u5212\u53bb\u7684\u884c\u4e3a\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"TradeInterChangeService_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                resultList.add(riskItemResult);
            }
        }
    }

    private static void cacheRiskAmountInfo(Map<String, List<RiskAmountCacheBean>> cacheMap, TradeInterChangeConfig config, String currentTime) {
        long startTime = System.currentTimeMillis();
        try {
            byte[] bytes = TradeInterChangeService.zipGraphMap(cacheMap);
            if (bytes != null) {
                logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u7f13\u5b58\u5b57\u8282\u957f\u5ea6\uff1a{}", (Object)bytes.length);
                cache.put("tmc.fcs.TradeInterChangeService_" + config.getCheckNumber(), bytes, 86400);
                cache.put("tmc.fcs.TradeInterChangeService.Time_" + config.getCheckNumber(), (Object)currentTime, 86400);
            }
        }
        catch (Exception e) {
            logger.error("\u7b5b\u67e5\u5212\u6765\u5212\u538b\u7f29\u6570\u636e\u5f02\u5e38(ms):", (Throwable)e);
        }
        logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u7f13\u5b58\u8017\u65f6(ms):{}", (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] zipGraphMap(Map<String, List<RiskAmountCacheBean>> cacheMap) {
        byte[] bytes = SerializationUtils.toByte(cacheMap);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write(bytes);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("zipGraphMap error:", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<RiskAmountCacheBean>> unzipGraphMap(byte[] bytes) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                 GZIPInputStream gin = new GZIPInputStream(in);){
                int n;
                byte[] buffer = new byte[256];
                while ((n = gin.read(buffer)) >= 0) {
                    out.write(buffer, 0, n);
                }
            }
            bytes = out.toByteArray();
            Map map = (Map)SerializationUtils.fromByte((byte[])bytes);
            return map;
        }
        catch (Exception e) {
            logger.error("unzipGraphMap error:", (Throwable)e);
            return new HashMap<String, List<RiskAmountCacheBean>>(16);
        }
    }

    private static Set<RiskAmountBean> queryReverseInfo(TradeInterChangeConfig config, QFilter qFilter) {
        HashSet<RiskAmountBean> returnSet = new HashSet<RiskAmountBean>(10);
        String reverseProp = "id,billno," + String.join((CharSequence)",", config.getReverseField());
        String objectScope = config.getObjectScope();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
        if (qFilter != null) {
            filterList.add(qFilter);
        }
        ConditionFactory factory = new ConditionFactory();
        if (EmptyUtil.isNoEmpty((String)objectScope)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)config.getObjectScope(), CRCondition.class);
            factory.init(conditionObj, config.getCheckNumber());
            MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)config.getCheckNumber());
            FilterBuilder filterBuilder = new FilterBuilder(dataType, conditionObj.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            filterList.add(filterBuilder.getQFilter());
        }
        long startTime = System.currentTimeMillis();
        DynamicObjectCollection reverDatas = QueryServiceHelper.query((String)config.getCheckNumber(), (String)reverseProp, (QFilter[])filterList.toArray(new QFilter[0]));
        logger.info("\u7b5b\u67e5\u5212\u6765\u5212\u53bb\u7f13\u5b58\u6570\u636e\u8017\u65f6(ms):{},\u662f\u5426\u65b0\u589e\u6570\u636e{}", (Object)(System.currentTimeMillis() - startTime), (Object)(qFilter != null ? 1 : 0));
        List<Object> reverDataList = new ArrayList<DynamicObject>((Collection<DynamicObject>)reverDatas);
        if (!factory.isExpressionExecuter()) {
            Set reverIds = reverDataList.stream().map(s -> s.getLong("id")).collect(Collectors.toSet());
            Set reverMatchIds = factory.runCondition(reverIds);
            reverDataList = reverDatas.stream().filter(s -> reverMatchIds.contains(s.getLong("id"))).collect(Collectors.toList());
        }
        TradeInterChangeService.genAmountBeansList(returnSet, reverDataList, config, "rec");
        return returnSet;
    }

    private static void setQueryByAmountField(Set<Long> recIds, List<QFilter> filterList, String amountField, String checkNumber, List<Object> amountSet) {
        int batchBill = 50;
        String paramValue = RiskChangeServiceHelper.loadRiskParamValue((String)"TradeInterChangeBatch");
        if (EmptyUtil.isNoEmpty((String)paramValue)) {
            batchBill = Integer.parseInt(paramValue);
        }
        List partition = Lists.partition(amountSet, (int)batchBill);
        for (List parts : partition) {
            QFilter recAmtFilter = new QFilter(amountField, "in", (Object)parts);
            filterList.add(recAmtFilter);
            DynamicObjectCollection recAmtDatas = QueryServiceHelper.query((String)checkNumber, (String)"id", (QFilter[])filterList.toArray(new QFilter[0]));
            recIds.addAll(recAmtDatas.stream().map(s -> s.getLong("id")).collect(Collectors.toSet()));
            filterList.remove(recAmtFilter);
        }
    }

    private static void genAmountBeansList(Set<RiskAmountBean> amountBeansSet, List<DynamicObject> datas, TradeInterChangeConfig config, String direction) {
        for (DynamicObject data : datas) {
            RiskAmountBean bean = new RiskAmountBean();
            bean.setId(Long.valueOf(data.getLong("id")));
            bean.setBillNo(data.getString("billno"));
            if (!config.isSameBill()) {
                if ("pay".equals(direction)) {
                    TradeInterChangeService.setPayInfo(bean, data, config);
                } else {
                    TradeInterChangeService.setRecInfo(bean, data, config);
                }
            } else {
                String recAmount;
                String payAmount = String.valueOf(data.get(config.getPayAmount()));
                if (EmptyUtil.isNoEmpty((String)payAmount) && new BigDecimal(payAmount).compareTo(BigDecimal.ZERO) > 0) {
                    TradeInterChangeService.setPayInfo(bean, data, config);
                }
                if (EmptyUtil.isNoEmpty((String)(recAmount = String.valueOf(data.get(config.getRecAmount())))) && new BigDecimal(recAmount).compareTo(BigDecimal.ZERO) > 0) {
                    TradeInterChangeService.setRecInfo(bean, data, config);
                }
            }
            amountBeansSet.add(bean);
        }
    }

    private static void setPayInfo(RiskAmountBean bean, DynamicObject data, TradeInterChangeConfig config) {
        bean.setPayAccount(EmptyUtil.isEmpty((Object)data.get(config.getForwardPayAccount())) ? null : String.valueOf(data.get(config.getForwardPayAccount())));
        bean.setAmount(EmptyUtil.isEmpty((Object)data.get(config.getPayAmount())) ? null : String.valueOf(data.get(config.getPayAmount())));
        bean.setRecAccount(EmptyUtil.isEmpty((Object)data.get(config.getForwardRecAccount())) ? null : String.valueOf(data.get(config.getForwardRecAccount())));
        bean.setEntity(config.getForwardEntity());
    }

    private static void setRecInfo(RiskAmountBean bean, DynamicObject data, TradeInterChangeConfig config) {
        bean.setPayAccount(EmptyUtil.isEmpty((Object)data.get(config.getReversePayAccount())) ? null : String.valueOf(data.get(config.getReversePayAccount())));
        bean.setAmount(EmptyUtil.isEmpty((Object)data.get(config.getRecAmount())) ? null : String.valueOf(data.get(config.getRecAmount())));
        bean.setRecAccount(EmptyUtil.isEmpty((Object)data.get(config.getReverseRecAccount())) ? null : String.valueOf(data.get(config.getReverseRecAccount())));
        bean.setEntity(config.getReverseEntity());
    }
}

