/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat.ctrl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.TargetEntityRuleInfo;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.mservice.repeat.ctrl.IMatchRule;

public abstract class AbstractMatchRule
implements IMatchRule {
    private static final Log logger = LogFactory.getLog(AbstractMatchRule.class);
    protected List<DynamicObject> realDealRecords = new ArrayList<DynamicObject>();
    protected Map<String, BigDecimal> srcResult = new HashMap<String, BigDecimal>();
    protected Map<String, BigDecimal> targetResult = new HashMap<String, BigDecimal>();
    protected Map<String, TargetEntityRuleInfo> entity_targetRuleInfo = new HashMap<String, TargetEntityRuleInfo>();
    protected DynamicObject rule;
    protected String targetBillEntity;
    protected DynamicObject targetBill;
    protected DynamicObject config;
    String srcHeadOrEntry;
    String targetHeadOrEntry;

    public void init(DynamicObject targetBill, DynamicObject config, DynamicObject rule) {
        DynamicObject entity = config.getDynamicObject("ctrlentity");
        this.targetBillEntity = entity.getString("number");
        this.targetBill = targetBill;
        this.config = config;
        this.rule = rule;
    }

    protected void dealSrcBillEntityWithHead() {
        this.srcHeadOrEntry = "head";
        if (this.realDealRecords.size() > 0) {
            Map<Long, List<DynamicObject>> srcBillMap = this.realDealRecords.stream().collect(Collectors.groupingBy(s -> Long.parseLong(s.getString("srcbillpkid"))));
            String srcField = this.rule.getString("srcamtfield");
            boolean isMulAmt = this.rule.getBoolean("issrcmulamt");
            String srcEntity = srcBillMap.get(srcBillMap.keySet().toArray()[0]).get(0).getString("srcentity");
            if (!isMulAmt) {
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySrcBill", (String)srcEntity, (String)("id," + srcField), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillMap.keySet())}, (String)"");){
                    for (Row row : ds) {
                        this.srcResult.put(row.getString("id"), row.getBigDecimal(srcField));
                    }
                }
            }
            String mulAmtRule = this.rule.getString("srcmulamt_tag");
            List calAmtRule = (List)SerializationUtils.fromJsonString((String)mulAmtRule, List.class);
            int size = calAmtRule.size();
            String[] fields = new String[size];
            String[] calRules = new String[size];
            StringBuilder sb = new StringBuilder();
            sb.append("id");
            for (int i = 0; i < size; ++i) {
                sb.append(',').append((String)((Map)calAmtRule.get(i)).get("F"));
                fields[i] = (String)((Map)calAmtRule.get(i)).get("F");
                calRules[i] = EmptyUtil.isEmpty((String)((String)((Map)calAmtRule.get(i)).get("CR"))) ? "+" : (String)((Map)calAmtRule.get(i)).get("CR");
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySrcBill", (String)srcEntity, (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillMap.keySet())}, (String)"");){
                for (Row row : ds) {
                    BigDecimal amt = row.getBigDecimal(fields[0]);
                    for (int i = 0; i < size - 1; ++i) {
                        amt = "+".equals(calRules[i]) ? amt.add(row.getBigDecimal(fields[i + 1])) : amt.subtract(row.getBigDecimal(fields[i + 1]));
                    }
                    this.srcResult.put(row.getString("id"), amt);
                }
            }
            logger.info("\u8d85\u989d\u6e90\u5355\u6570\u636e\uff1a" + this.srcResult);
        }
    }

    protected void dealSrcBillEntityWithEntry() {
        if (this.realDealRecords.size() > 0) {
            Map<Long, List<DynamicObject>> srcBillMap = this.realDealRecords.stream().collect(Collectors.groupingBy(s -> Long.parseLong(s.getString("srcbillpkid"))));
            String srcEntity = srcBillMap.get(srcBillMap.keySet().toArray()[0]).get(0).getString("srcentity");
            boolean isMulAmt = this.rule.getBoolean("issrcmulamt");
            if (!isMulAmt) {
                String srcEntryEntity;
                String srcField = this.rule.getString("srcamtfield");
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)srcEntity);
                this.srcHeadOrEntry = srcEntryEntity = ((IDataEntityProperty)entityType.getAllFields().get(srcField)).getParent().getName();
                String selectField = srcEntryEntity + ".id," + srcEntryEntity + "." + srcField;
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySrcBill", (String)srcEntity, (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillMap.keySet())}, (String)"");){
                    for (Row row : ds) {
                        this.srcResult.put(row.getString(srcEntryEntity + ".id"), row.getBigDecimal(srcEntryEntity + "." + srcField));
                    }
                }
            }
            String mulAmtRule = this.rule.getString("srcmulamt_tag");
            List calAmtRule = (List)SerializationUtils.fromJsonString((String)mulAmtRule, List.class);
            int size = calAmtRule.size();
            String[] fields = new String[size];
            String[] calRules = new String[size];
            String srcEntryEntity = "";
            StringBuilder sb = new StringBuilder();
            sb.append("id");
            for (int i = 0; i < size; ++i) {
                String field = (String)((Map)calAmtRule.get(i)).get("F");
                if (field.indexOf(46) > 0) {
                    srcEntryEntity = field.substring(0, field.indexOf(46));
                }
                sb.append(',').append(field);
                fields[i] = field;
                calRules[i] = EmptyUtil.isEmpty((String)((String)((Map)calAmtRule.get(i)).get("CR"))) ? "+" : (String)((Map)calAmtRule.get(i)).get("CR");
            }
            this.srcHeadOrEntry = srcEntryEntity;
            sb.append(',').append(srcEntryEntity).append(".id");
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"querySrcBill", (String)srcEntity, (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillMap.keySet())}, (String)"");){
                for (Row row : ds) {
                    BigDecimal amt = row.getBigDecimal(fields[0]);
                    for (int i = 0; i < size - 1; ++i) {
                        amt = "+".equals(calRules[i]) ? amt.add(row.getBigDecimal(fields[i + 1])) : amt.subtract(row.getBigDecimal(fields[i + 1]));
                    }
                    this.srcResult.put(row.getString(srcEntryEntity + ".id"), amt);
                }
            }
            logger.info("\u8d85\u989d\u6e90\u5355\u6570\u636e\uff1a" + this.srcResult);
        }
    }

    protected void dealTargetBillEntityWithHead() {
        this.targetHeadOrEntry = "head";
        Map<String, List<DynamicObject>> targetBillMap = this.realDealRecords.stream().collect(Collectors.groupingBy(s -> s.getString("destentity")));
        for (Map.Entry<String, List<DynamicObject>> one : targetBillMap.entrySet()) {
            String targetEntity = one.getKey();
            List<DynamicObject> recordList = one.getValue();
            TargetEntityRuleInfo ruleInfo = this.entity_targetRuleInfo.get(targetEntity);
            boolean isMulAmt = ruleInfo.getIsMulAmt();
            if (!isMulAmt) {
                String amtField = ruleInfo.getAmtField();
                Set ids = recordList.stream().map(o -> o.getLong("destbillpkid")).collect(Collectors.toSet());
                if (ids.contains(this.targetBill.getLong("id"))) {
                    ids.remove(this.targetBill.getLong("id"));
                    this.targetResult.put(this.targetBill.getString("id"), this.targetBill.getBigDecimal(amtField));
                }
                if (ids.size() <= 0) continue;
                DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTargetBill", (String)targetEntity, (String)("id," + amtField), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"");
                Throwable throwable = null;
                try {
                    for (Row row : ds) {
                        this.targetResult.put(row.getString("id"), row.getBigDecimal(amtField));
                    }
                    continue;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable it) {
                            throwable.addSuppressed(it);
                        }
                        continue;
                    }
                    ds.close();
                    continue;
                }
            }
            String mulAmtRule = ruleInfo.getMulAmt();
            List calAmtRule = (List)SerializationUtils.fromJsonString((String)mulAmtRule, List.class);
            int size = calAmtRule.size();
            String[] fields = new String[size];
            String[] calRules = new String[size];
            StringBuilder sb = new StringBuilder();
            sb.append("id");
            for (int i = 0; i < size; ++i) {
                sb.append(',').append((String)((Map)calAmtRule.get(i)).get("F"));
                fields[i] = (String)((Map)calAmtRule.get(i)).get("F");
                calRules[i] = EmptyUtil.isEmpty((String)((String)((Map)calAmtRule.get(i)).get("CR"))) ? "+" : (String)((Map)calAmtRule.get(i)).get("CR");
            }
            Set ids = recordList.stream().map(o -> o.getLong("destbillpkid")).collect(Collectors.toSet());
            if (ids.contains(this.targetBill.getLong("id"))) {
                ids.remove(this.targetBill.getLong("id"));
                BigDecimal amt = this.targetBill.getBigDecimal(fields[0]);
                for (int i = 0; i < size - 1; ++i) {
                    amt = "+".equals(calRules[i]) ? amt.add(this.targetBill.getBigDecimal(fields[i + 1])) : amt.subtract(this.targetBill.getBigDecimal(fields[i + 1]));
                }
                this.targetResult.put(this.targetBill.getString("id"), amt);
            }
            if (ids.size() <= 0) continue;
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTargetBill", (String)targetEntity, (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"");
            Throwable throwable = null;
            try {
                for (Row row : ds) {
                    BigDecimal amt = row.getBigDecimal(fields[0]);
                    for (int i = 0; i < size - 1; ++i) {
                        amt = "+".equals(calRules[i]) ? amt.add(row.getBigDecimal(fields[i + 1])) : amt.subtract(row.getBigDecimal(fields[i + 1]));
                    }
                    this.targetResult.put(row.getString("id"), amt);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        logger.info("\u8d85\u989d\u76ee\u6807\u5355\u6570\u636e\uff1a" + this.targetResult);
    }

    protected void dealTargetBillEntityWithEntry() {
        Map<String, List<DynamicObject>> targetBillMap = this.realDealRecords.stream().collect(Collectors.groupingBy(s -> s.getString("destentity")));
        for (Map.Entry<String, List<DynamicObject>> one : targetBillMap.entrySet()) {
            Set ids;
            String targetEntity = one.getKey();
            List<DynamicObject> recordList = one.getValue();
            TargetEntityRuleInfo ruleInfo = this.entity_targetRuleInfo.get(targetEntity);
            boolean isMulAmt = ruleInfo.getIsMulAmt();
            if (!isMulAmt) {
                Object oneEntry2;
                Set ids2;
                String amtField = ruleInfo.getAmtField();
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
                String targetEntryEntity = ((IDataEntityProperty)entityType.getAllFields().get(amtField)).getParent().getName();
                if (targetEntity.equals(this.targetBillEntity)) {
                    this.targetHeadOrEntry = targetEntryEntity;
                }
                if ((ids2 = recordList.stream().map(o -> o.getLong("destbillpkid")).collect(Collectors.toSet())).contains(this.targetBill.getLong("id"))) {
                    ids2.remove(this.targetBill.getLong("id"));
                    DynamicObjectCollection targetBillEntry = this.targetBill.getDynamicObjectCollection(targetEntryEntity);
                    for (Object oneEntry2 : targetBillEntry) {
                        this.targetResult.put(oneEntry2.getString("id"), oneEntry2.getBigDecimal(amtField));
                    }
                }
                if (ids2.size() <= 0) continue;
                if (targetEntity.equals("cas_agentpaybill")) {
                    ConditionFactory factory = new ConditionFactory();
                    factory.init(ruleInfo.getCondition(), targetEntity);
                    Map temp = factory.runCondition(ids2, targetEntryEntity + "." + amtField, targetEntryEntity + ".id");
                    temp.entrySet().stream().forEach(o -> this.targetResult.put((String)o.getKey(), (BigDecimal)o.getValue()));
                    continue;
                }
                String selectField = targetEntryEntity + ".id," + targetEntryEntity + "." + amtField;
                DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTargetBill", (String)targetEntity, (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "in", ids2)}, (String)"");
                oneEntry2 = null;
                try {
                    for (Row row : ds) {
                        this.targetResult.put(row.getString(targetEntryEntity + ".id"), row.getBigDecimal(targetEntryEntity + "." + amtField));
                    }
                    continue;
                }
                catch (Throwable it) {
                    oneEntry2 = it;
                    throw it;
                }
                finally {
                    if (ds == null) continue;
                    if (oneEntry2 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable it) {
                            ((Throwable)oneEntry2).addSuppressed(it);
                        }
                        continue;
                    }
                    ds.close();
                    continue;
                }
            }
            String mulAmtRule = ruleInfo.getMulAmt();
            List calAmtRule = (List)SerializationUtils.fromJsonString((String)mulAmtRule, List.class);
            int size = calAmtRule.size();
            String[] fields = new String[size];
            String[] calRules = new String[size];
            Boolean[] isHeads = new Boolean[size];
            String targetEntryEntity = "";
            StringBuilder sb = new StringBuilder();
            sb.append("id");
            for (int i = 0; i < size; ++i) {
                String field = (String)((Map)calAmtRule.get(i)).get("F");
                if (field.indexOf(46) > 0) {
                    targetEntryEntity = field.substring(0, field.indexOf(46));
                    isHeads[i] = Boolean.FALSE;
                } else {
                    isHeads[i] = Boolean.TRUE;
                }
                sb.append(',').append(field);
                fields[i] = field;
                calRules[i] = EmptyUtil.isEmpty((String)((String)((Map)calAmtRule.get(i)).get("CR"))) ? "+" : (String)((Map)calAmtRule.get(i)).get("CR");
            }
            sb.append(',').append(targetEntryEntity).append(".id");
            if (targetEntity.equals(this.targetBillEntity)) {
                this.targetHeadOrEntry = targetEntryEntity;
            }
            if ((ids = recordList.stream().map(o -> o.getLong("destbillpkid")).collect(Collectors.toSet())).contains(this.targetBill.getLong("id"))) {
                ids.remove(this.targetBill.getLong("id"));
                DynamicObjectCollection targetBillEntry = this.targetBill.getDynamicObjectCollection(targetEntryEntity);
                for (DynamicObject oneEntry : targetBillEntry) {
                    BigDecimal amt = isHeads[0] != false ? this.targetBill.getBigDecimal(fields[0]) : oneEntry.getBigDecimal(fields[0].substring(fields[0].indexOf(46) + 1));
                    for (int i = 0; i < size - 1; ++i) {
                        BigDecimal temp = isHeads[i + 1] != false ? this.targetBill.getBigDecimal(fields[i + 1]) : oneEntry.getBigDecimal(fields[i + 1].substring(fields[i + 1].indexOf(46) + 1));
                        amt = "+".equals(calRules[i]) ? amt.add(temp) : amt.subtract(temp);
                    }
                    this.targetResult.put(oneEntry.getString("id"), amt);
                }
            }
            if (ids.size() <= 0) continue;
            DataSet ds = QueryServiceHelper.queryDataSet((String)"queryTargetBill", (String)targetEntity, (String)sb.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, (String)"");
            Object object = null;
            try {
                for (Row row : ds) {
                    BigDecimal amt = row.getBigDecimal(fields[0]);
                    for (int i = 0; i < size - 1; ++i) {
                        amt = "+".equals(calRules[i]) ? amt.add(row.getBigDecimal(fields[i + 1])) : amt.subtract(row.getBigDecimal(fields[i + 1]));
                    }
                    this.targetResult.put(row.getString(targetEntryEntity + ".id"), amt);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds == null) continue;
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    continue;
                }
                ds.close();
            }
        }
        logger.info("\u8d85\u989d\u76ee\u6807\u5355\u6570\u636e\uff1a" + this.targetResult);
    }

    protected boolean filterRecord(DynamicObject[] allRecords) {
        logger.info("\u7b5b\u9009\u524d\u652f\u4ed8\u94fe\u8def\uff1a" + Arrays.toString(allRecords));
        List<Object> runRecords = Arrays.asList(allRecords);
        String conditionJson = this.rule.getString("srccondition_tag");
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String srcEntity = runRecords.get(0).getString("srcentity");
            HashSet srcBillIds = new HashSet();
            runRecords.forEach(o -> srcBillIds.add(Long.parseLong(o.getString("srcbillpkid"))));
            ConditionFactory factory = new ConditionFactory();
            factory.init(conditionObj, srcEntity);
            Set fitSrcBillIds = factory.runCondition(srcBillIds);
            runRecords = runRecords.stream().filter(o -> fitSrcBillIds.contains(Long.parseLong(o.getString("srcbillpkid")))).collect(Collectors.toList());
            logger.info("\u7b5b\u9009\u6e90\u5355\u540e\u5b9e\u9645\u4f7f\u7528\u7684\u652f\u4ed8\u94fe\u8def\uff1a" + runRecords);
        }
        this.dealRuleInfo();
        Map<String, List<DynamicObject>> targetBillMap = runRecords.stream().collect(Collectors.groupingBy(s -> s.getString("destentity")));
        ConditionFactory factory = new ConditionFactory();
        HashSet<Long> targetBillIds = new HashSet<Long>();
        for (Map.Entry<String, List<DynamicObject>> one : targetBillMap.entrySet()) {
            CRCondition condition;
            String targetEntity = one.getKey();
            List<DynamicObject> recordList = one.getValue();
            if (!this.entity_targetRuleInfo.containsKey(targetEntity)) continue;
            Set ids = recordList.stream().map(o -> o.getLong("destbillpkid")).collect(Collectors.toSet());
            if (ids.contains(this.targetBill.getLong("id"))) {
                ids.remove(this.targetBill.getLong("id"));
                targetBillIds.add(this.targetBill.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((Object)(condition = this.entity_targetRuleInfo.get(targetEntity).getCondition()))) {
                factory.init(condition, targetEntity);
                ids = factory.runCondition(ids);
            }
            targetBillIds.addAll(ids);
        }
        this.realDealRecords = runRecords.stream().filter(o -> targetBillIds.contains(o.getLong("destbillpkid"))).collect(Collectors.toList());
        logger.info("\u7b5b\u9009\u540e\u5b9e\u9645\u4f7f\u7528\u7684\u652f\u4ed8\u94fe\u8def\uff1a" + this.realDealRecords);
        return this.realDealRecords.size() > 0;
    }

    private void dealRuleInfo() {
        TargetEntityRuleInfo targetEntityRuleInfo = new TargetEntityRuleInfo();
        targetEntityRuleInfo.setEntity(this.targetBillEntity);
        targetEntityRuleInfo.setAmtField(this.rule.getString("targetamtfield"));
        targetEntityRuleInfo.setAbs(Boolean.valueOf(this.rule.getBoolean("istargetabs")));
        targetEntityRuleInfo.setIsMulAmt(Boolean.valueOf(this.rule.getBoolean("istargetmulamt")));
        targetEntityRuleInfo.setMulAmt(this.rule.getString("targetmulamt_tag"));
        String conditionJson = this.rule.getString("targetcondition_tag");
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            targetEntityRuleInfo.setCondition(conditionObj);
        }
        this.entity_targetRuleInfo.put(this.targetBillEntity, targetEntityRuleInfo);
        DynamicObjectCollection subRuleCol = this.rule.getDynamicObjectCollection("subentryentity");
        for (DynamicObject subRule : subRuleCol) {
            String otherEntity = subRule.getDynamicObject("othertargetentity").getString("number");
            TargetEntityRuleInfo otherRuleInfo = new TargetEntityRuleInfo();
            otherRuleInfo.setEntity(otherEntity);
            otherRuleInfo.setAmtField(subRule.getString("othertargetamtfield"));
            otherRuleInfo.setAbs(Boolean.valueOf(subRule.getBoolean("isotherabs")));
            otherRuleInfo.setIsMulAmt(Boolean.valueOf(subRule.getBoolean("isothermulamt")));
            otherRuleInfo.setMulAmt(subRule.getString("othermulamt_tag"));
            String json = subRule.getString("othercondition_tag");
            if (StringUtils.isNotBlank((CharSequence)json)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
                otherRuleInfo.setCondition(conditionObj);
            }
            this.entity_targetRuleInfo.put(otherEntity, otherRuleInfo);
        }
    }

    protected void checkBotpMatchRule() {
        boolean isOk = true;
        for (DynamicObject record : this.realDealRecords) {
            String destEntryProp;
            String destIdProp;
            String srcEntryProp;
            if (!this.targetBillEntity.equals(record.getString("destentity")) || !this.config.getDynamicObject("srcentity").getString("number").equals(record.getString("srcentity"))) continue;
            String srcIdProp = record.getString("srcidprop");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.srcHeadOrEntry, this.targetHeadOrEntry, srcIdProp, srcEntryProp = record.getString("srcentryprop"), destIdProp = record.getString("destidprop"), destEntryProp = record.getString("destentryprop")})) continue;
            if (!("head".equals(this.srcHeadOrEntry) || !"head".equals(srcIdProp) && this.srcHeadOrEntry.equals(srcEntryProp))) {
                isOk = false;
                logger.info("\u9632\u91cd\u89c4\u5219\u4e0ebotp\u4e0d\u4e00\u81f41\uff1a" + this.srcHeadOrEntry + "-" + srcIdProp + "-" + srcEntryProp);
            }
            if (!("head".equals(this.targetHeadOrEntry) || !"head".equals(destIdProp) && this.targetHeadOrEntry.equals(destEntryProp))) {
                isOk = false;
                logger.info("\u9632\u91cd\u89c4\u5219\u4e0ebotp\u4e0d\u4e00\u81f42\uff1a" + this.targetHeadOrEntry + "-" + destIdProp + "-" + destEntryProp);
            }
            if (isOk) continue;
            String tip = this.config.getString("number");
            throw new KDBizException(ResManager.loadKDString((String)"\u3010%s\u3011\u652f\u4ed8\u9632\u91cd\u89c4\u5219\u4e0eBOTP\u7ef4\u62a4\u7684\u5173\u8054\u5b9e\u4f53\u4e0b\u63a8\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u652f\u4ed8\u9632\u91cd\u89c4\u5219\u3002", (String)"AbstractMatchRule_0", (String)"tmc-fcs-mservice", (Object[])new Object[]{tip}));
        }
    }
}

