/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat.ctrl;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.mservice.repeat.ctrl.AbstractMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.EntrySingleToEntrySingleMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.EntrySingleToEntrySumMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.EntrySingleToHeadMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.EntrySumToEntrySumMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.EntrySumToHeadMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.HeadToEntrySingleMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.HeadToEntrySumMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.HeadToHeadMatchRule;
import kd.tmc.fcs.mservice.repeat.ctrl.IMatchRule;

public class CtrlDataBuilder {
    DynamicObject config;
    DynamicObject targetBill;

    public CtrlDataBuilder(DynamicObject targetBill, DynamicObject config) {
        this.targetBill = targetBill;
        this.config = config;
    }

    public Boolean isMatchCtrlRule() {
        String selectProps = "id,srcentity,srcentryprop,srcbillpkid,srcbillid,srcidprop,destentity,destentryprop,destbillpkid,destbillid,destidprop,isrepeatresult,isexcessresult";
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fcs_payaccess_record", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("destbillpkid", "=", this.targetBill.getPkValue())});
        List ids = query.stream().map(o -> o.getString("srcbillpkid")).collect(Collectors.toList());
        DynamicObject[] allRecords = BusinessDataServiceHelper.load((String)"fcs_payaccess_record", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("srcbillpkid", "in", ids)});
        DynamicObject entity = this.config.getDynamicObject("ctrlentity");
        String entityNumber = entity.getString("number");
        DynamicObjectCollection configRules = this.config.getDynamicObjectCollection("entryentity");
        Boolean isMatch = Boolean.TRUE;
        for (DynamicObject oneRule : configRules) {
            String conditionJson = oneRule.getString("targetcondition_tag");
            if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
                CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
                ConditionFactory factory = new ConditionFactory();
                factory.init(conditionObj, entityNumber);
                if (!factory.isMatchCondition(this.targetBill).booleanValue()) continue;
            }
            String srcMatchRule = oneRule.getString("srcrule");
            String targetMatchRule = oneRule.getString("targetrule");
            String matchRule = srcMatchRule + "-" + targetMatchRule;
            IMatchRule iMatchRule = this.getMatchRuleFactory(matchRule, oneRule);
            if (iMatchRule != null) {
                isMatch = iMatchRule.isMatch(allRecords);
            }
            if (isMatch.booleanValue()) continue;
            break;
        }
        return isMatch;
    }

    public IMatchRule getMatchRuleFactory(String matchRule, DynamicObject oneRule) {
        AbstractMatchRule iMatchRule = null;
        switch (matchRule) {
            case "Head-Head": {
                iMatchRule = new HeadToHeadMatchRule();
                break;
            }
            case "Head-EntrySingle": {
                iMatchRule = new HeadToEntrySingleMatchRule();
                break;
            }
            case "Head-EntrySum": {
                iMatchRule = new HeadToEntrySumMatchRule();
                break;
            }
            case "EntrySingle-EntrySingle": {
                iMatchRule = new EntrySingleToEntrySingleMatchRule();
                break;
            }
            case "EntrySingle-EntrySum": {
                iMatchRule = new EntrySingleToEntrySumMatchRule();
                break;
            }
            case "EntrySingle-Head": {
                iMatchRule = new EntrySingleToHeadMatchRule();
                break;
            }
            case "EntrySum-Head": {
                iMatchRule = new EntrySumToHeadMatchRule();
                break;
            }
            case "EntrySum-EntrySum": {
                iMatchRule = new EntrySumToEntrySumMatchRule();
            }
        }
        if (iMatchRule != null) {
            ((AbstractMatchRule)iMatchRule).init(this.targetBill, this.config, oneRule);
        }
        return iMatchRule;
    }
}

