/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat.ctrl;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.TargetEntityRuleInfo;
import kd.tmc.fcs.mservice.repeat.ctrl.AbstractMatchRule;

public class EntrySingleToEntrySumMatchRule
extends AbstractMatchRule {
    private static final Log logger = LogFactory.getLog(EntrySingleToEntrySumMatchRule.class);

    @Override
    public Boolean isMatch(DynamicObject[] allRecords) {
        boolean checkRecord = this.filterRecord(allRecords);
        if (!checkRecord) {
            return Boolean.TRUE;
        }
        this.dealSrcBillEntityWithEntry();
        this.dealTargetBillEntityWithEntry();
        this.checkBotpMatchRule();
        Boolean isMatch = Boolean.TRUE;
        boolean isSrcAbs = this.rule.getBoolean("issrcabs");
        Map<String, List<DynamicObject>> mapSidRecords = this.realDealRecords.stream().collect(Collectors.groupingBy(s -> s.getString("srcbillid")));
        for (Map.Entry<String, List<DynamicObject>> entry : mapSidRecords.entrySet()) {
            BigDecimal sum = BigDecimal.ZERO;
            Map<String, List<DynamicObject>> targetRecords = entry.getValue().stream().collect(Collectors.groupingBy(s -> s.getString("destentity")));
            for (Map.Entry<String, List<DynamicObject>> targetRecord : targetRecords.entrySet()) {
                BigDecimal targetSum = BigDecimal.ZERO;
                String targetEntity = targetRecord.getKey();
                boolean isTargetAbs = ((TargetEntityRuleInfo)this.entity_targetRuleInfo.get(targetEntity)).getAbs();
                for (DynamicObject tempO : targetRecord.getValue()) {
                    BigDecimal targetAmt = (BigDecimal)this.targetResult.get(tempO.getString("destbillid"));
                    if (EmptyUtil.isNoEmpty((BigDecimal)targetAmt)) {
                        targetSum = targetSum.add(targetAmt);
                        continue;
                    }
                    logger.info("\u8d85\u989d\u63a7\u5236\u4e2d\u91c7\u96c6\u3010\u76ee\u6807\u5355\u3011\u91d1\u989d\u5f02\u5e38\u7684destbillid\uff1a" + tempO.getString("destbillid"));
                }
                targetSum = isTargetAbs ? targetSum.abs() : targetSum;
                sum = sum.add(targetSum);
            }
            String sid = entry.getKey();
            BigDecimal srcAmt = (BigDecimal)this.srcResult.get(sid);
            if (srcAmt != null) {
                srcAmt = isSrcAbs ? srcAmt.abs() : srcAmt;
                logger.info("srcAmt:" + srcAmt + ";targetAmt:" + sum);
                if (srcAmt.compareTo(sum) >= 0) {
                    isMatch = Boolean.TRUE;
                    continue;
                }
                isMatch = Boolean.FALSE;
                logger.info("\u8d85\u989d\u5bf9\u5e94\u7684\u89c4\u5219\uff1a" + this.rule.getString("id"));
                break;
            }
            logger.info("\u8d85\u989d\u63a7\u5236\u4e2d\u91c7\u96c6\u3010\u6e90\u5355\u3011\u91d1\u989d\u5f02\u5e38\u7684srcbillid\uff1a" + sid);
        }
        return isMatch;
    }
}

