/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat.ctrl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.TargetEntityRuleInfo;
import kd.tmc.fcs.mservice.repeat.ctrl.AbstractMatchRule;

public class EntrySumToEntrySumMatchRule
extends AbstractMatchRule {
    private static final Log logger = LogFactory.getLog(EntrySumToEntrySumMatchRule.class);

    @Override
    public Boolean isMatch(DynamicObject[] allRecords) {
        boolean checkRecord = this.filterRecord(allRecords);
        if (!checkRecord) {
            return Boolean.TRUE;
        }
        this.dealSrcBillEntityWithEntry();
        this.dealTargetBillEntityWithEntry();
        this.checkBotpMatchRule();
        boolean isSrcAbs = this.rule.getBoolean("issrcabs");
        int size = this.realDealRecords.size();
        HashMap<String, HashSet<String>> relationFromSrc = new HashMap<String, HashSet<String>>(size);
        HashMap<String, HashSet<String>> relationFromDest = new HashMap<String, HashSet<String>>(size);
        HashMap<String, String> targetId_entity = new HashMap<String, String>(size);
        for (DynamicObject dynamicObject : this.realDealRecords) {
            String srcId = dynamicObject.getString("srcbillid");
            String destId = dynamicObject.getString("destbillid");
            targetId_entity.put(destId, dynamicObject.getString("destentity"));
            HashSet<String> temp_src = (HashSet<String>)relationFromSrc.get(srcId);
            if (EmptyUtil.isEmpty((Collection)temp_src)) {
                temp_src = new HashSet<String>();
                relationFromSrc.put(srcId, temp_src);
            }
            temp_src.add(destId);
            HashSet<String> temp_dest = (Set)relationFromDest.get(destId);
            if (EmptyUtil.isEmpty((Collection)temp_dest)) {
                temp_dest = new HashSet<String>();
                relationFromDest.put(destId, temp_dest);
            }
            temp_dest.add(srcId);
        }
        for (Map.Entry entry : relationFromDest.entrySet()) {
            Set srcIdSet = (Set)entry.getValue();
            HashSet destIdSet = new HashSet();
            BigDecimal sumSrc = BigDecimal.ZERO;
            for (String srcId : srcIdSet) {
                if (EmptyUtil.isNoEmpty((BigDecimal)((BigDecimal)this.srcResult.get(srcId)))) {
                    sumSrc = sumSrc.add((BigDecimal)this.srcResult.get(srcId));
                } else {
                    logger.info("\u8d85\u989d\u63a7\u5236\u4e2d\u91c7\u96c6\u3010\u6e90\u5355\u3011\u91d1\u989d\u5f02\u5e38\u7684srcbillid\uff1a" + srcId);
                }
                if (!EmptyUtil.isNoEmpty(relationFromSrc.get(srcId))) continue;
                destIdSet.addAll((Collection)relationFromSrc.get(srcId));
            }
            BigDecimal sumDest = BigDecimal.ZERO;
            HashMap<String, ArrayList<String>> targetEntity_Ids = new HashMap<String, ArrayList<String>>(size);
            for (String string : destIdSet) {
                String tempEntity = (String)targetId_entity.get(string);
                ArrayList<String> ids = (ArrayList<String>)targetEntity_Ids.get(tempEntity);
                if (EmptyUtil.isEmpty((Collection)ids)) {
                    ids = new ArrayList<String>();
                    ids.add(string);
                    targetEntity_Ids.put(tempEntity, ids);
                    continue;
                }
                ids.add(string);
            }
            for (Map.Entry entry2 : targetEntity_Ids.entrySet()) {
                boolean isTargetAbs = ((TargetEntityRuleInfo)this.entity_targetRuleInfo.get(entry2.getKey())).getAbs();
                BigDecimal tempSum = BigDecimal.ZERO;
                for (String oneRowId : (List)entry2.getValue()) {
                    BigDecimal destAmt = (BigDecimal)this.targetResult.get(oneRowId);
                    if (null == destAmt) {
                        logger.info("\u8d85\u989d\u63a7\u5236\u4e2d\u91c7\u96c6\u3010\u76ee\u6807\u5355\u3011\u91d1\u989d\u5f02\u5e38\u7684destbillid\uff1a" + oneRowId);
                        continue;
                    }
                    tempSum = tempSum.add(destAmt);
                }
                tempSum = isTargetAbs ? tempSum.abs() : tempSum;
                sumDest = sumDest.add(tempSum);
            }
            sumSrc = isSrcAbs ? sumSrc.abs() : sumSrc;
            logger.info("srcAmt:" + sumSrc + ";targetAmt:" + sumDest);
            if (sumSrc.compareTo(sumDest) >= 0) continue;
            logger.info("\u8d85\u989d\u5bf9\u5e94\u7684\u89c4\u5219\uff1a" + this.rule.getString("id"));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

