/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat.ctrl;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fcs.common.dao.TargetEntityRuleInfo;
import kd.tmc.fcs.mservice.repeat.ctrl.AbstractMatchRule;

public class HeadToEntrySingleMatchRule
extends AbstractMatchRule {
    private static Log logger = LogFactory.getLog(HeadToEntrySingleMatchRule.class);

    @Override
    public Boolean isMatch(DynamicObject[] allRecords) {
        boolean checkRecord = this.filterRecord(allRecords);
        if (!checkRecord) {
            return Boolean.TRUE;
        }
        this.dealSrcBillEntityWithHead();
        this.dealTargetBillEntityWithEntry();
        this.checkBotpMatchRule();
        Boolean isMatch = Boolean.TRUE;
        boolean isSrcAbs = this.rule.getBoolean("issrcabs");
        for (DynamicObject record : this.realDealRecords) {
            BigDecimal srcAmt = (BigDecimal)this.srcResult.get(record.getString("srcbillpkid"));
            BigDecimal targetAmt = (BigDecimal)this.targetResult.get(record.getString("destbillid"));
            if (srcAmt != null && targetAmt != null) {
                String targetEntity = record.getString("destentity");
                boolean isTargetAbs = ((TargetEntityRuleInfo)this.entity_targetRuleInfo.get(targetEntity)).getAbs();
                srcAmt = isSrcAbs ? srcAmt.abs() : srcAmt;
                targetAmt = isTargetAbs ? targetAmt.abs() : targetAmt;
                logger.info("srcAmt:" + srcAmt + ";targetAmt:" + targetAmt);
                if (srcAmt.compareTo(targetAmt) >= 0) {
                    isMatch = Boolean.TRUE;
                    continue;
                }
                logger.info("\u8d85\u989d\u5bf9\u5e94\u7684\u89c4\u5219\uff1a" + this.rule.getString("id"));
                isMatch = Boolean.FALSE;
                break;
            }
            logger.info("\u8d85\u989d\u63a7\u5236\u4e2d\u91c7\u96c6\u91d1\u989d\u5f02\u5e38\u7684\u8bb0\u5f55\uff1a" + record);
        }
        return isMatch;
    }
}

