/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.repeat.ctrl;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.dao.TargetEntityRuleInfo;
import kd.tmc.fcs.mservice.repeat.ctrl.AbstractMatchRule;

public class HeadToHeadMatchRule
extends AbstractMatchRule {
    private static final Log logger = LogFactory.getLog(HeadToHeadMatchRule.class);

    @Override
    public Boolean isMatch(DynamicObject[] allRecords) {
        boolean checkRecord = this.filterRecord(allRecords);
        if (!checkRecord) {
            return Boolean.TRUE;
        }
        this.dealSrcBillEntityWithHead();
        this.dealTargetBillEntityWithHead();
        this.checkBotpMatchRule();
        Map<String, List<DynamicObject>> mapTargetRecord = this.realDealRecords.stream().collect(Collectors.groupingBy(s -> s.getString("destentity")));
        BigDecimal srcSum = this.srcResult.values().stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        boolean isSrcAbs = this.rule.getBoolean("issrcabs");
        srcSum = isSrcAbs ? srcSum.abs() : srcSum;
        BigDecimal targetSum = BigDecimal.ZERO;
        for (Map.Entry<String, List<DynamicObject>> entry : mapTargetRecord.entrySet()) {
            HashSet<String> dealTargetBill = new HashSet<String>(this.targetResult.size());
            String targetEntity = entry.getKey();
            boolean isTargetAbs = ((TargetEntityRuleInfo)this.entity_targetRuleInfo.get(targetEntity)).getAbs();
            BigDecimal sum = BigDecimal.ZERO;
            for (DynamicObject temp : entry.getValue()) {
                if (dealTargetBill.contains(temp.getString("destbillpkid"))) continue;
                dealTargetBill.add(temp.getString("destbillpkid"));
                BigDecimal targetAmt = (BigDecimal)this.targetResult.get(temp.getString("destbillpkid"));
                if (EmptyUtil.isNoEmpty((BigDecimal)targetAmt)) {
                    sum = sum.add(targetAmt);
                    continue;
                }
                logger.info("\u8d85\u989d\u63a7\u5236\u4e2d\u91c7\u96c6\u3010\u76ee\u6807\u5355\u3011\u91d1\u989d\u5f02\u5e38\u7684destbillid\uff1a" + temp.getString("destbillid"));
            }
            sum = isTargetAbs ? sum.abs() : sum;
            targetSum = targetSum.add(sum);
        }
        logger.info("srcSum:" + srcSum + ";targetSum:" + targetSum);
        if (srcSum.compareTo(targetSum) >= 0) {
            return Boolean.TRUE;
        }
        logger.info("\u8d85\u989d\u5bf9\u5e94\u7684\u89c4\u5219\uff1a" + this.rule.getString("id"));
        return Boolean.FALSE;
    }
}

