/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.safetyinspect;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.PayAccessBlackEnum;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang3.tuple.Pair;

public class SafetyCollectTask
extends AbstractTask {
    private static final String SQL = "SELECT distinct ftenantname as tenant,fcheckresult as result FROM t_ai_datacheck_result WHERE fdatachecktaskno = 'fcs_safetyinspect_check'";
    private Map<String, List<String>> srcentityDisplayName = new HashMap<String, List<String>>(16);
    private Map<String, List<String>> destentityDisplayName = new HashMap<String, List<String>>(16);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        StringBuilder sqlStr = new StringBuilder(SQL);
        sqlStr.append(" and fcreatetime >= ").append("'").append(DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd")).append("'");
        DataSet dataSet = DB.queryDataSet((String)"SafetyCollectTask", (DBRoute)DBRoute.of((String)"fi"), (String)sqlStr.toString(), (Object[])new Object[0]);
        List tenants = TmcDataServiceHelper.loadFromCache((String)"fcs_tenantwhite", (String)"tenant", null).values().stream().map(w -> w.getString("tenant")).collect(Collectors.toList());
        Iterator iterator = dataSet.iterator();
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection payaccess = QueryServiceHelper.query((String)"fcs_payaccess", (String)"srcentity,destentity,name", null);
        this.srcentityDisplayName = payaccess.stream().collect(Collectors.groupingBy(s -> s.getString("srcentity"), Collectors.mapping(n -> n.getString("name").contains(" -> ") ? n.getString("name").split(" -> ")[0] : "notfound", Collectors.toList())));
        this.destentityDisplayName = payaccess.stream().collect(Collectors.groupingBy(s -> s.getString("destentity"), Collectors.mapping(n -> n.getString("name").contains(" -> ") ? n.getString("name").split(" -> ")[1] : "notfound", Collectors.toList())));
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            String tenant = row.getString("tenant");
            if (!tenants.stream().filter(tenant::matches).collect(Collectors.toList()).isEmpty()) continue;
            String result = row.getString("result");
            String number = "SC-" + RandomUtils.nextInt();
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"fcs_safetyinspect");
            data.set("tenantname", (Object)tenant);
            data.set("billno", (Object)number);
            data.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            this.setAll(data, result);
            data.set("customer", (Object)(data.getString("tenantname") + "(" + data.getString("customer") + ")"));
            data.set("tenantname", (Object)tenant);
            QFilter filter = new QFilter("tenantname", "=", (Object)data.getString("tenantname"));
            filter.and(new QFilter("bizdate", "=", (Object)data.getDate("bizdate")));
            boolean exists = QueryServiceHelper.exists((String)"fcs_safetyinspect", (QFilter[])filter.toArray());
            if (exists) continue;
            datas.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])datas.stream().collect(Collectors.groupingBy(s -> Pair.of((Object)s.getString("tenantname"), (Object)s.getDate("bizdate")), Collectors.toList())).values().stream().map(c -> (DynamicObject)c.get(0)).toArray(DynamicObject[]::new)));
    }

    private void setAll(DynamicObject data, String result) {
        if (result.contains("customer")) {
            String[] split2;
            String[] split1;
            String[] split = result.split(", \\{");
            block28: for (String cell : split1 = split[0].replace("{", "").replace("}", "").split(", ")) {
                if (!EmptyUtil.isNoEmpty((String)cell)) continue;
                split2 = cell.split("=");
                switch (split2[0]) {
                    case "tenantname": {
                        data.set("tenantname", (Object)split2[1].replace("'", ""));
                        continue block28;
                    }
                    case "customer": {
                        data.set("customer", (Object)split2[1].replace("'", ""));
                        continue block28;
                    }
                    case "bizDate": {
                        data.set("bizdate", (Object)DateUtils.stringToDate((String)split2[1], (String)"yyyy-MM-dd"));
                        continue block28;
                    }
                    case "isFirststat": {
                        data.set("isfirststat", (Object)split2[1]);
                        continue block28;
                    }
                    case "repeatCount": {
                        data.set("repeatcount", (Object)Integer.parseInt(split2[1]));
                        continue block28;
                    }
                    case "excessCount": {
                        data.set("excesscount", (Object)Integer.parseInt(split2[1]));
                        continue block28;
                    }
                    case "suspectCount": {
                        data.set("suspectcount", (Object)Integer.parseInt(split2[1]));
                        continue block28;
                    }
                    case "flowingCount": {
                        data.set("flowingcount", (Object)Integer.parseInt(split2[1]));
                        continue block28;
                    }
                    case "logCount": {
                        data.set("logcount", (Object)Integer.parseInt(split2[1]));
                    }
                }
            }
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("useentry");
            DynamicObjectCollection repeatEntrys = data.getDynamicObjectCollection("repeatentry");
            DynamicObjectCollection srcUseEntry = data.getDynamicObjectCollection("srcuseentry");
            for (int i = 1; i < split.length; ++i) {
                String displayName;
                List<String> names;
                DynamicObject row;
                split2 = split[i].split(", ");
                if (split2.length == 2 && split2[1].contains("}")) {
                    row = srcUseEntry.addNew();
                    row.set("su_srcbillentity", (Object)split2[0]);
                    if ("customsign".equals(split2[0])) {
                        row.set("su_billname", (Object)ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf", (String)"SafetyCollectTask_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    } else {
                        MainEntityType dataEntityType;
                        try {
                            dataEntityType = MetadataServiceHelper.getDataEntityType((String)split2[0]);
                        }
                        catch (Exception e) {
                            row.set("su_billname", (Object)ResManager.loadKDString((String)"\u73b0\u573a\u4e8c\u5f00\u5355\u636e", (String)"SafetyCollectTask_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                            row.set("su_checkcount", (Object)Integer.parseInt(split2[1].replace("}", "")));
                            continue;
                        }
                        if (dataEntityType != null) {
                            names = this.srcentityDisplayName.get(split2[0]);
                            if (EmptyUtil.isNoEmpty(names)) {
                                displayName = names.get(0);
                                if ("notfound".equals(displayName)) {
                                    displayName = dataEntityType.getDisplayName().getLocaleValue();
                                }
                            } else {
                                displayName = dataEntityType.getDisplayName().getLocaleValue();
                            }
                            row.set("su_billname", (Object)displayName);
                        }
                    }
                    row.set("su_checkcount", (Object)Integer.parseInt(split2[1].replace("}", "")));
                    continue;
                }
                if (split2.length == 4 && split2[3].contains("}")) {
                    row = repeatEntrys.addNew();
                    row.set("srcbillentity", (Object)split2[0]);
                    row.set("destbillentity", (Object)split2[1]);
                    MainEntityType srcDataEntityType = null;
                    try {
                        srcDataEntityType = MetadataServiceHelper.getDataEntityType((String)split2[0]);
                    }
                    catch (Exception e) {
                        row.set("srcbillentityname", (Object)ResManager.loadKDString((String)"\u73b0\u573a\u4e8c\u5f00\u5355\u636e", (String)"SafetyCollectTask_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                        row.set("srcappname", (Object)ResManager.loadKDString((String)"\u73b0\u573a\u4e8c\u5f00\u5355\u636e", (String)"SafetyCollectTask_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    }
                    if (srcDataEntityType != null) {
                        names = this.srcentityDisplayName.get(split2[0]);
                        if (EmptyUtil.isNoEmpty(names)) {
                            displayName = names.get(0);
                            if ("notfound".equals(displayName)) {
                                displayName = srcDataEntityType.getDisplayName().getLocaleValue();
                            }
                        } else {
                            displayName = srcDataEntityType.getDisplayName().getLocaleValue();
                        }
                        row.set("srcbillentityname", (Object)displayName);
                        row.set("srcappname", (Object)AppMetadataCache.getAppInfo((String)srcDataEntityType.getAppId()).getName());
                        row.set("srcappid", (Object)srcDataEntityType.getAppId());
                    } else if (this.srcentityDisplayName.containsKey(split2[0])) {
                        row.set("srcbillentityname", (Object)ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf", (String)"SafetyCollectTask_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                        row.set("srcappname", (Object)ResManager.loadKDString((String)"\u5916\u90e8\u7cfb\u7edf", (String)"SafetyCollectTask_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    }
                    MainEntityType destDataEntityType = null;
                    try {
                        destDataEntityType = MetadataServiceHelper.getDataEntityType((String)split2[1]);
                    }
                    catch (Exception e) {
                        row.set("destbillentityname", (Object)ResManager.loadKDString((String)"\u73b0\u573a\u4e8c\u5f00\u5355\u636e", (String)"SafetyCollectTask_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    }
                    if (destDataEntityType != null) {
                        String displayName2;
                        List<String> names2 = this.destentityDisplayName.get(split2[1]);
                        if (EmptyUtil.isNoEmpty(names2)) {
                            displayName2 = names2.get(0);
                            if ("notfound".equals(displayName2)) {
                                displayName2 = destDataEntityType.getDisplayName().getLocaleValue();
                            }
                        } else {
                            displayName2 = destDataEntityType.getDisplayName().getLocaleValue();
                        }
                        row.set("destbillentityname", (Object)displayName2);
                    }
                    row.set("pushtype", (Object)split2[2]);
                    row.set("count", (Object)Integer.parseInt(split2[3].replace("}", "")));
                    continue;
                }
                if (split2.length != 5 || !split2[4].contains("}")) continue;
                String displayName3 = PayAccessBlackEnum.getName((String)split2[0]);
                DynamicObject row2 = entrys.addNew();
                row2.set("billentity", (Object)split2[0]);
                row2.set("billentityname", (Object)displayName3);
                row2.set("covered", (Object)Integer.parseInt(split2[3]));
                row2.set("needcover", (Object)Integer.parseInt(split2[4].replace("}", "")));
            }
        }
    }
}

