/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.safetyinspect;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RepeatCheckResultEnum;
import kd.tmc.fcs.common.model.SafetyUpBugInfo;

public class SafetyDataDMPTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SafetyDataDMPTask.class);
    private static final String NUMBER = "fcs_safetydmpconfig";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/PKCS5Padding";
    private static final String sql = "select r.fentryid entryid,r.fsrcbillentity srcbillentity,r.fdestbillentity destbillentity,r.fsrcbillentityname srcbillentityname,r.fdestbillentityname destbillentityname,r.fpushtype pushtype,r.fcount count,h.fcustomer customer,h.fbizdate bizdate,d.frouteid routeid,d.fphone phone from t_fcs_safetyinspect_r r left join t_fcs_safetyinspect h on r.fid = h.fid left join t_fcs_safetydata_dmp d on r.fsrcappid = d.fappid where h.fcreatetime >= to_date(?) and r.fpushtype != 'bizcheck' and r.fsrcappid != ' ' and r.fsrcappid != '' and r.fsrcappid is not null and d.fphone != ' '";

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        logger.info("SafetyDataDMPTask start");
        String postUrl = "https://devops.kingdee.com:8000";
        String shortUrl = "/app/dmp/DmpBugApi";
        this.doPost(postUrl, shortUrl);
        logger.info("SafetyDataDMPTask end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(String postUrl, String shortUrl) {
        String accessToken = null;
        HashMap<Long, String> bugNumberMap = new HashMap<Long, String>(16);
        try {
            DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)NUMBER, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)NUMBER)});
            if (EmptyUtil.isEmpty((DynamicObject)config)) {
                return;
            }
            HashMap<String, String> bodyMap = new HashMap<String, String>(8);
            bodyMap.put("appId", config.getString("appId"));
            bodyMap.put("appSecret", config.getString("appsecret"));
            bodyMap.put("accountId", config.getString("accountId"));
            bodyMap.put("tenantid", config.getString("tenantid"));
            String bodyStr = JSONObject.toJSONString(bodyMap);
            String appTokenURL = postUrl + "/api/getAppToken.do";
            String resultObj = this.doPostByHttpClient(appTokenURL, bodyStr);
            Map res = (Map)SerializationUtils.fromJsonString((String)resultObj, Map.class);
            String appToken = null;
            Object data = res.get("data");
            if (null != data) {
                if ("success".equalsIgnoreCase(res.get("state").toString())) {
                    if (data instanceof Map) {
                        appToken = ((Map)data).get("app_token").toString();
                    }
                } else {
                    throw new Exception("url " + appTokenURL + " login fail " + resultObj);
                }
            }
            HashMap<String, String> accessMap = new HashMap<String, String>(8);
            accessMap.put("user", config.getString("user"));
            accessMap.put("usertype", config.getString("usertype"));
            accessMap.put("accountId", config.getString("accountId"));
            accessMap.put("tenantid", config.getString("tenantid"));
            accessMap.put("apptoken", appToken);
            String accessString = JSONObject.toJSONString(accessMap);
            String accessTokenURL = postUrl + "/api/login.do";
            resultObj = this.doPostByHttpClient(accessTokenURL, accessString);
            res = (Map)SerializationUtils.fromJsonString((String)resultObj, Map.class);
            if ("success".equalsIgnoreCase(res.get("state").toString())) {
                data = res.get("data");
                if (data instanceof Map) {
                    accessToken = ((Map)data).get("access_token").toString();
                }
            } else {
                throw new Exception(resultObj);
            }
            List<SafetyUpBugInfo> infos = this.getTodayRecords();
            if (!infos.isEmpty()) {
                for (SafetyUpBugInfo info : infos) {
                    Map thisBugData;
                    String number;
                    HashMap<String, String> queryParaMap = new HashMap<String, String>();
                    queryParaMap.put("product", ResManager.loadKDString((String)"\u652f\u4ed8\u5b89\u5168\u5de1\u68c0\u670d\u52a1", (String)"SafetyDataDMPTask_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
                    queryParaMap.put("route", info.getRoutId());
                    String dataenv = String.format(ResManager.loadKDString((String)"\u5ba2\u6237\u73af\u5883\uff1a%s", (String)"SafetyDataDMPTask_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]), info.getCustomer());
                    queryParaMap.put("dataenv", dataenv);
                    String name = String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u5b89\u5168\u5de1\u68c0\u51fa\u73b0%s", (String)"SafetyDataDMPTask_2", (String)"tmc-fcs-mservice", (Object[])new Object[0]), info.getPushType());
                    queryParaMap.put("name", name);
                    String bugdes = String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u65e5\u671f\uff1a%1$s\uff0c\u6e90\u5355\uff1a%2$s\uff0c\u76ee\u6807\u5355\uff1a%3$s\uff0c\u5f02\u5e38\u6b21\u6570\uff1a%4$s", (String)"SafetyDataDMPTask_3", (String)"tmc-fcs-mservice", (Object[])new Object[0]), info.getBizDate(), info.getSrcBillEntityName(), info.getDestBillEntityName(), info.getCount());
                    queryParaMap.put("bugdes", bugdes);
                    queryParaMap.put("pic", info.getPhone());
                    bodyStr = JSONObject.toJSONString(queryParaMap);
                    String importData = "{\"data\":[\r\n" + bodyStr + "],\r\n\"action\":\"insert\"}";
                    String url = postUrl + "/kapi%s?access_token=" + accessToken;
                    url = String.format(url, shortUrl);
                    logger.info("url:" + url);
                    logger.info("importData:" + importData);
                    String msg = this.doPostByHttpClient(url, importData);
                    Map map = (Map)SerializationUtils.fromJsonString((String)msg, Map.class);
                    Boolean isSuccess = (Boolean)map.get("success");
                    logger.info(msg);
                    if (!isSuccess.booleanValue() || !EmptyUtil.isNoEmpty((String)(number = (String)(thisBugData = (Map)((List)map.get("data")).get(0)).get("number")))) continue;
                    bugNumberMap.put(info.getEntryId(), number);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.backWritingBugNumber(bugNumberMap);
        }
    }

    private void backWritingBugNumber(Map<Long, String> bugNumberMap) {
        DynamicObject[] safetyRecords;
        logger.info(bugNumberMap.toString());
        Set<Long> entryIds = bugNumberMap.keySet();
        if (entryIds.size() == 0) {
            return;
        }
        for (DynamicObject record : safetyRecords = TmcDataServiceHelper.load((String)"fcs_safetyinspect", (String)"id,repeatentry.id,repeatentry.bugnumber", (QFilter[])new QFilter[]{new QFilter("repeatentry.id", "in", entryIds)})) {
            DynamicObjectCollection repeatEntrys = record.getDynamicObjectCollection("repeatentry");
            for (DynamicObject row : repeatEntrys) {
                long entryId = row.getLong("id");
                row.set("bugnumber", (Object)bugNumberMap.get(entryId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])safetyRecords);
    }

    private List<SafetyUpBugInfo> getTodayRecords() {
        String today = new SimpleDateFormat("yyyy-MM-dd").format(DateUtils.getCurrentDate());
        ArrayList<SafetyUpBugInfo> infos = new ArrayList<SafetyUpBugInfo>(10);
        DataSet dataSet = DB.queryDataSet((String)"fcs_SafetyDataDMPTask", (DBRoute)DBRouteConst.TMC, (String)sql, (Object[])new Object[]{today});
        DynamicObjectCollection whiteDs = QueryServiceHelper.query((String)"fcs_safetysetdmpwhite", (String)"repeatctrlset.srcentity srcbillentity,repeatctrlset.ctrlentity destbillentity", null);
        Set whiteSet = whiteDs.stream().map(s -> s.getString("srcbillentity") + "_" + s.getString("destbillentity")).collect(Collectors.toSet());
        for (Row data : dataSet) {
            String pushType;
            String thisSet = data.getString("srcbillentity") + "_" + data.getString("destbillentity");
            if (whiteSet.contains(thisSet)) continue;
            SafetyUpBugInfo info = new SafetyUpBugInfo();
            info.setCustomer(data.getString("customer"));
            info.setBizDate(DateUtils.formatString((Date)data.getDate("bizdate"), (String)"yyyy-MM-dd"));
            info.setSrcBillEntityName(data.getString("srcbillentityname"));
            info.setDestBillEntityName(data.getString("destbillentityname"));
            switch (pushType = data.getString("pushtype")) {
                case "double": {
                    info.setPushType(RepeatCheckResultEnum.REPEAT.getName());
                    break;
                }
                case "over": {
                    info.setPushType(RepeatCheckResultEnum.EXCESS.getName());
                    break;
                }
                case "bizcheck": {
                    info.setPushType(RepeatCheckResultEnum.BIZCHECK.getName());
                    break;
                }
            }
            info.setCount(data.getString("count"));
            info.setRoutId(data.getString("routeid"));
            info.setPhone(data.getString("phone"));
            info.setEntryId(data.getLong("entryid"));
            infos.add(info);
        }
        return infos;
    }

    private String doPostByHttpClient(String url, String data) throws IOException {
        HashMap<String, String> header = new HashMap<String, String>(1);
        header.put("Content-Type", "application/json; charset=UTF-8");
        return HttpClientUtils.postjson((String)url, header, (String)data);
    }
}

