/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.safetyinspect;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.SuspectCtrlTypeEnum;
import kd.tmc.fcs.common.property.PayAccesslProp;

public class SafetyInspectTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SafetyInspectTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("SafetyInspectTask_start");
        try {
            if ("patchfi".equals(RequestContext.get().getTenantId())) {
                return;
            }
            Date date = new Date();
            String number = "SI-" + DateUtils.formatString((Date)date, (String)"yyyyMMddHHmmss");
            String customer = TmcDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(TmcOrgDataHelper.getOrgRootId((Long)8L)))}).getString("name");
            Date startTime = DateUtils.truncateDate((Date)DateUtils.getLastDay((Date)date, (int)1));
            Date endTime = DateUtils.truncateDate((Date)date);
            QFilter qFilter = new QFilter("createtime", ">=", (Object)startTime).and("createtime", "<", (Object)endTime);
            QFilter fi = new QFilter("logtype", "in", Arrays.asList("repeatctrl", "bizcheck"));
            DataSet query = QueryServiceHelper.queryDataSet((String)"fcs_repeatctrllog", (String)"fcs_repeatctrllog", (String)"id,sourcebillid,sourcebilltype,destbilltype,checkresult,repeatset.customsign as customsign,logtype", (QFilter[])new QFilter[]{qFilter, fi}, null);
            int repeatCount = query.copy().filter("checkresult = 'repeat'").count("id", true);
            int excessCount = query.copy().filter("checkresult = 'excess'").count("id", true);
            String selectStr = "id,ctrltype,billid,suspectentry.suspectbillentity.number,suspectentry.suspectbillid,suspectentry.suspectdescribe";
            DynamicObjectCollection suspectBills = QueryServiceHelper.query((String)"fcs_suspectbill", (String)selectStr, (QFilter[])new QFilter[]{qFilter});
            long suspectCount = suspectBills.stream().filter(s -> !SuspectCtrlTypeEnum.CONTROL.getValue().equals(s.getString("ctrltype"))).map(s -> s.getLong("id")).distinct().count();
            long flowingCount = suspectBills.stream().filter(s -> "bei_transdetail".equals(s.get("suspectentry.suspectbillentity.number"))).map(s -> s.getLong("id")).distinct().count();
            long logCount = suspectBills.stream().filter(s -> "bei_banklog".equals(s.get("suspectentry.suspectbillentity.number"))).map(s -> s.getLong("id")).distinct().count();
            DynamicObject safetyInspect = BusinessDataServiceHelper.newDynamicObject((String)"fcs_safetyinspect");
            safetyInspect.set("billno", (Object)number);
            safetyInspect.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            safetyInspect.set("customer", (Object)customer);
            safetyInspect.set("bizdate", (Object)startTime);
            safetyInspect.set("isfirststat", (Object)"0");
            safetyInspect.set("repeatcount", (Object)repeatCount);
            safetyInspect.set("excesscount", (Object)excessCount);
            safetyInspect.set("suspectcount", (Object)suspectCount);
            safetyInspect.set("flowingcount", (Object)flowingCount);
            safetyInspect.set("logcount", (Object)logCount);
            safetyInspect.set("tenantname", (Object)AccountUtils.getTenantByid((String)RequestContext.get().getTenantId()).getName());
            this.setDetailEntry(suspectBills, safetyInspect);
            this.setUseEntry(qFilter, safetyInspect);
            this.setRepeatEntry(query, safetyInspect);
            this.setSrcRepeatEntry(query, safetyInspect);
            query.close();
            QFilter filter = new QFilter("customer", "=", (Object)customer);
            filter.and(new QFilter("bizdate", "=", (Object)startTime));
            DeleteServiceHelper.delete((String)"fcs_safetyinspect", (QFilter[])filter.toArray());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{safetyInspect});
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        finally {
            logger.info("SafetyInspectTask_end");
        }
    }

    private void setRepeatEntry(DataSet query, DynamicObject safetyInspect) {
        DynamicObjectCollection repeatEntrys = safetyInspect.getDynamicObjectCollection("repeatentry");
        DataSet Rds = query.copy().filter("checkresult = 'repeat'").groupBy(new String[]{"sourcebilltype", "destbilltype", "customsign"}).count("checkresult").finish();
        while (Rds.hasNext()) {
            Row row = Rds.next();
            DynamicObject entry = repeatEntrys.addNew();
            entry.set("srcbillentity", EmptyUtil.isNoEmpty((Object)row.get("sourcebilltype")) ? row.get("sourcebilltype") : row.get("customsign"));
            entry.set("destbillentity", row.get("destbilltype"));
            entry.set("pushtype", (Object)"double");
            entry.set("count", row.get("checkresult"));
        }
        DataSet Exds = query.copy().filter("checkresult = 'excess'").groupBy(new String[]{"sourcebilltype", "destbilltype", "customsign"}).count("checkresult").finish();
        while (Exds.hasNext()) {
            Row row = Exds.next();
            DynamicObject entry = repeatEntrys.addNew();
            entry.set("srcbillentity", EmptyUtil.isNoEmpty((Object)row.get("sourcebilltype")) ? row.get("sourcebilltype") : row.get("customsign"));
            entry.set("destbillentity", row.get("destbilltype"));
            entry.set("pushtype", (Object)"over");
            entry.set("count", row.get("checkresult"));
        }
        DataSet bizds = query.copy().filter("logtype = 'bizcheck'").groupBy(new String[]{"sourcebilltype", "destbilltype"}).count("logtype").finish();
        while (bizds.hasNext()) {
            Row row = bizds.next();
            DynamicObject entry = repeatEntrys.addNew();
            entry.set("srcbillentity", row.get("sourcebilltype"));
            entry.set("destbillentity", row.get("destbilltype"));
            entry.set("pushtype", (Object)"bizcheck");
            entry.set("count", row.get("logtype"));
        }
    }

    private void setSrcRepeatEntry(DataSet query, DynamicObject safetyInspect) {
        DynamicObjectCollection srcUseEntry = safetyInspect.getDynamicObjectCollection("srcuseentry");
        int customCount = query.copy().filter("customsign != ''").count("id", false);
        if (customCount > 0) {
            DynamicObject row1 = srcUseEntry.addNew();
            row1.set("su_srcbillentity", (Object)"customsign");
            row1.set("su_checkcount", (Object)customCount);
        }
        DataSet dataSet = query.filter("customsign = ''").groupBy(new String[]{"sourcebilltype"}).countDistinct(new String[]{"sourcebillid"}).finish();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            DynamicObject entry = srcUseEntry.addNew();
            entry.set("su_srcbillentity", row.get("sourcebilltype"));
            entry.set("su_checkcount", row.get("sourcebillid"));
        }
    }

    private void setDetailEntry(DynamicObjectCollection suspectBills, DynamicObject safetyInspect) {
        List flowingDatas = suspectBills.stream().filter(s -> SuspectCtrlTypeEnum.CONTROL.getValue().equals(s.getString("ctrltype"))).collect(Collectors.toList());
        DynamicObjectCollection detailEntrys = safetyInspect.getDynamicObjectCollection("detailentry");
        for (DynamicObject data : flowingDatas) {
            String describle;
            List checkFlag;
            if (!"bei_transdetail".equals(data.get("suspectentry.suspectbillentity.number")) || !EmptyUtil.isNoEmpty(checkFlag = Arrays.stream((describle = data.getString("suspectentry.suspectdescribe")).split(";")).filter(s -> s.contains(ResManager.loadKDString((String)"\u5355\u636e\u5934.\u5bf9\u8d26\u6807\u8bc6\u7801", (String)"SafetyInspectTask_0", (String)"tmc-fcs-mservice", (Object[])new Object[0])) && !s.contains(ResManager.loadKDString((String)"\uff08\u94f6\u884c\u8fd4\u56de\uff09", (String)"SafetyInspectTask_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]))).collect(Collectors.toList()))) continue;
            String[] split = ((String)checkFlag.get(0)).split("\uff1a");
            DynamicObject row = detailEntrys.addNew();
            row.set("billid", data.get("billid"));
            row.set("detailid", data.get("suspectentry.suspectbillid"));
            row.set("checkflag", split.length == 2 ? split[1] : null);
        }
    }

    private void setUseEntry(QFilter logQFilter, DynamicObject safetyInspect) {
        DynamicObjectCollection repeatLog = QueryServiceHelper.query((String)"fcs_repeatctrllog", (String)"destbilltype,destbillid", (QFilter[])new QFilter[]{logQFilter, new QFilter("logtype", "=", (Object)"repeatctrl").and("destbilltype", "in", (Object)PayAccesslProp.BLACK_LIST)});
        Map<String, List<DynamicObject>> checkLog = repeatLog.stream().collect(Collectors.groupingBy(l -> l.getString("destbilltype")));
        DynamicObjectCollection useEntrys = safetyInspect.getDynamicObjectCollection("useentry");
        for (Map.Entry<String, List<DynamicObject>> entry : checkLog.entrySet()) {
            if (entry.getValue().size() == 0) continue;
            String entityNumber = entry.getKey();
            String sourceBillField = "cas_agentpaybill".equals(entry.getKey()) ? "hsourcebillid" : "sourcebillid";
            Set repeatLogIds = repeatLog.stream().map(e -> e.getLong("destbillid")).collect(Collectors.toSet());
            DynamicObjectCollection bizBills = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{logQFilter, new QFilter(sourceBillField, "!=", (Object)0L).and(sourceBillField, "is not null", null)});
            Set bizBillIds = bizBills.stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            if (bizBillIds.size() <= 0) continue;
            DynamicObject row = useEntrys.addNew();
            row.set("billentity", (Object)entityNumber);
            int needCoverCount = bizBillIds.size();
            bizBillIds.retainAll(repeatLogIds);
            int coverCount = bizBillIds.size();
            row.set("covered", (Object)coverCount);
            row.set("needcover", (Object)needCoverCount);
        }
    }
}

