/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.safetyinspect;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.data.collect.model.DataCollect;
import kd.bos.data.collect.service.DataCollectServiceHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fcs.common.model.SafetyInspectBean;
import kd.tmc.fcs.common.model.SafetyRepeatBean;
import kd.tmc.fcs.common.model.SafetySrcUsageConditionBean;
import kd.tmc.fcs.common.model.SafetyUsageConditionBean;

public class SafetySendDataTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SafetySendDataTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date lastTowDay = DateUtils.truncateDate((Date)DateUtils.getLastDay((Date)new Date(), (int)2));
        String selectStr = "billno,customer,tenantname,bizdate,isfirststat,isreport,repeatcount,excesscount,suspectcount,flowingcount,deatailcount,logcount,balancecount,receiptcount,useentry.billentity,repeatentry.srcbillentity,repeatentry.destbillentity,repeatentry.pushtype,repeatentry.count,useentry.covered,useentry.needcover,srcuseentry,srcuseentry.su_srcbillentity,srcuseentry.su_checkcount";
        DynamicObject[] safetyDatas = TmcDataServiceHelper.load((String)"fcs_safetyinspect", (String)selectStr, (QFilter[])new QFilter[]{new QFilter("bizdate", ">=", (Object)lastTowDay)});
        ArrayList<String> postData = new ArrayList<String>(safetyDatas.length);
        for (DynamicObject data : safetyDatas) {
            SafetyInspectBean safetyInspect = new SafetyInspectBean();
            safetyInspect.setCustomer(data.getString("customer"));
            safetyInspect.setBizDate(data.getDate("bizdate"));
            safetyInspect.setFirststat(data.getBoolean("isfirststat"));
            safetyInspect.setRepeatCount(data.getInt("repeatcount"));
            safetyInspect.setExcessCount(data.getInt("excesscount"));
            safetyInspect.setSuspectCount(data.getInt("suspectcount"));
            safetyInspect.setFlowingCount(data.getInt("flowingcount"));
            safetyInspect.setLogCount(data.getInt("logcount"));
            safetyInspect.setTenantname(data.getString("tenantname"));
            DynamicObjectCollection useEntry = data.getDynamicObjectCollection("useentry");
            ArrayList<Object> usageList = new ArrayList<Object>(useEntry.size());
            for (DynamicObject row : useEntry) {
                SafetyUsageConditionBean useData = new SafetyUsageConditionBean();
                useData.setBillEntity(row.getString("billentity"));
                useData.setCheckCount(0);
                useData.setCheckRate(0L);
                useData.setCovered(row.getInt("covered"));
                useData.setNeedCover(row.getInt("needcover"));
                usageList.add(useData);
            }
            safetyInspect.setUseEntry(usageList);
            DynamicObjectCollection repeatEntry = data.getDynamicObjectCollection("repeatentry");
            ArrayList<SafetyRepeatBean> RepeatList = new ArrayList<SafetyRepeatBean>(repeatEntry.size());
            for (DynamicObject row : repeatEntry) {
                SafetyRepeatBean repeatData = new SafetyRepeatBean();
                repeatData.setSrcbillentity(row.getString("srcbillentity"));
                repeatData.setDestbillentity(row.getString("destbillentity"));
                repeatData.setPushtype(row.getString("pushtype"));
                repeatData.setCount(row.getInt("count"));
                RepeatList.add(repeatData);
            }
            safetyInspect.setRepeatEntry(RepeatList);
            DynamicObjectCollection srcUseEntry = data.getDynamicObjectCollection("srcuseentry");
            ArrayList<SafetySrcUsageConditionBean> srcUseList = new ArrayList<SafetySrcUsageConditionBean>(srcUseEntry.size());
            for (DynamicObject row : srcUseEntry) {
                SafetySrcUsageConditionBean suseData = new SafetySrcUsageConditionBean();
                suseData.setSrcBillEntity(row.getString("su_srcbillentity"));
                suseData.setCheckCount(row.getInt("su_checkcount"));
                srcUseList.add(suseData);
            }
            safetyInspect.setSrcUseEntry(srcUseList);
            postData.add(safetyInspect.toString());
            data.set("isreport", (Object)true);
            logger.info("\u4e0a\u62a5\u7684\u6570\u636e\u7f16\u7801\uff1a" + data.getString("billno"));
        }
        if (postData.size() > 0) {
            SafetySendDataTask.postSafetyData(postData);
        }
        if (safetyDatas.length > 0) {
            SaveServiceHelper.save((DynamicObject[])safetyDatas);
        }
    }

    private static void postSafetyData(List<String> postDatas) {
        ArrayList<DataCollect> dataList = new ArrayList<DataCollect>(postDatas.size());
        for (String postData : postDatas) {
            DataCollect data = new DataCollect();
            data.setFormId("bd_datachecktask");
            data.setProjectId("cosmic");
            data.setStoreId("server_beacon");
            data.setEventName("fi_datacheck");
            data.setCreatTime(new Date());
            HashMap<String, String> cusMap = new HashMap<String, String>(16);
            cusMap.put("datachecktaskno", "fcs_safetyinspect_check");
            cusMap.put("datachecktaskname", "SafetyInspectCheck");
            cusMap.put("checkresult", postData);
            cusMap.put("ispass", "1");
            cusMap.put("appid", "fcs");
            cusMap.put("checkdatetime", DateUtils.formatString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            data.setCusData(cusMap);
            dataList.add(data);
        }
        DataCollectServiceHelper.addBatchData(dataList, null);
    }
}

