/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.similarity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fcs.common.enums.RiskCheckScopeEnum;

public class BillTextDiagConfig
implements Serializable {
    private static final long serialVersionUID = 7635181506236293519L;
    private String scope;
    private double threshold;
    private String billNumber;
    private String checkNumber;
    private String companyNumber;
    private String filterCondition;
    private String objectScope;
    private String billDescField;
    private String billCompanyField;
    private String checkCompanyField;
    private String companyField;
    private String companyBusinessField;
    private String billAcctField;
    private String checkAcctField;
    private String billBankNumField;
    private String billOpBankNumField;
    private String checkBankNumField;
    private String checkOpBankNumField;

    public static List<BillTextDiagConfig> loadFromDynamicObject(DynamicObject itemConfig) {
        ArrayList<BillTextDiagConfig> configList = new ArrayList<BillTextDiagConfig>(10);
        String billNumber = itemConfig.getDynamicObject("appbill").getString("number");
        String checkWay = itemConfig.getString("checkway");
        double threshold = itemConfig.getBigDecimal("similarity").doubleValue();
        if (RiskCheckScopeEnum.CONTENT.getValue().equals(checkWay)) {
            BillTextDiagConfig config = new BillTextDiagConfig();
            config.setScope(checkWay);
            config.setThreshold(threshold);
            config.setBillNumber(billNumber);
            ((DynamicObject)itemConfig.getDynamicObjectCollection("filterentry").get(0)).getDynamicObjectCollection("paramentry").forEach(config::setByParam);
            configList.add(config);
        } else {
            DynamicObjectCollection filterList = itemConfig.getDynamicObjectCollection("filterentry");
            for (DynamicObject filter : filterList) {
                BillTextDiagConfig config = new BillTextDiagConfig();
                config.setScope(checkWay);
                config.setThreshold(threshold);
                config.setBillNumber(billNumber);
                config.setCheckNumber(filter.getDynamicObject("flobject").getString("number"));
                config.setFilterCondition(filter.getString("flcondition_tag"));
                config.setObjectScope(filter.getString("flobjscope_tag"));
                filter.getDynamicObjectCollection("paramentry").forEach(config::setByParam);
                configList.add(config);
            }
        }
        return configList;
    }

    private void setByParam(DynamicObject paramObject) {
        String param = paramObject.getString("param");
        String field = paramObject.getString("paramfield");
        switch (param) {
            case "desc": {
                this.setBillDescField(field);
                break;
            }
            case "business": {
                String number = paramObject.getDynamicObject("parambill").getString("number");
                this.setCompanyNumber(number);
                this.setCompanyBusinessField(field);
                break;
            }
            case "company": {
                this.setBillCompanyField(field);
                break;
            }
            case "companyname": {
                this.setCompanyField(field);
                break;
            }
            case "checkcompany": {
                this.setCheckCompanyField(field);
                break;
            }
            case "accountbank": {
                this.setBillAcctField(field);
                break;
            }
            case "checkaccount": {
                this.setCheckAcctField(field);
                break;
            }
            case "banknum": {
                this.setBillBankNumField(field);
                break;
            }
            case "opbanknum": {
                this.setBillOpBankNumField(field);
                break;
            }
            case "checkbanknum": {
                this.setCheckBankNumField(field);
                break;
            }
            case "checkopbanknum": {
                this.setCheckOpBankNumField(field);
                break;
            }
        }
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    public String getBillDescField() {
        return this.billDescField;
    }

    public void setBillDescField(String billDescField) {
        this.billDescField = billDescField;
    }

    public String getBillCompanyField() {
        return this.billCompanyField;
    }

    public void setBillCompanyField(String billCompanyField) {
        this.billCompanyField = billCompanyField;
    }

    public String getCompanyField() {
        return this.companyField;
    }

    public void setCompanyField(String companyField) {
        this.companyField = companyField;
    }

    public String getCompanyBusinessField() {
        return this.companyBusinessField;
    }

    public void setCompanyBusinessField(String companyBusinessField) {
        this.companyBusinessField = companyBusinessField;
    }

    public String getBillNumber() {
        return this.billNumber;
    }

    public void setBillNumber(String billNumber) {
        this.billNumber = billNumber;
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public void setCompanyNumber(String companyNumber) {
        this.companyNumber = companyNumber;
    }

    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public String getCheckCompanyField() {
        return this.checkCompanyField;
    }

    public void setCheckCompanyField(String checkCompanyField) {
        this.checkCompanyField = checkCompanyField;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public String getObjectScope() {
        return this.objectScope;
    }

    public void setObjectScope(String objectScope) {
        this.objectScope = objectScope;
    }

    public String getBillOpBankNumField() {
        return this.billOpBankNumField;
    }

    public void setBillOpBankNumField(String billOpBankNumField) {
        this.billOpBankNumField = billOpBankNumField;
    }

    public String getBillAcctField() {
        return this.billAcctField;
    }

    public void setBillAcctField(String billAcctField) {
        this.billAcctField = billAcctField;
    }

    public String getCheckAcctField() {
        return this.checkAcctField;
    }

    public void setCheckAcctField(String checkAcctField) {
        this.checkAcctField = checkAcctField;
    }

    public String getBillBankNumField() {
        return this.billBankNumField;
    }

    public void setBillBankNumField(String billBankNumField) {
        this.billBankNumField = billBankNumField;
    }

    public String getCheckBankNumField() {
        return this.checkBankNumField;
    }

    public void setCheckBankNumField(String checkBankNumField) {
        this.checkBankNumField = checkBankNumField;
    }

    public String getCheckOpBankNumField() {
        return this.checkOpBankNumField;
    }

    public void setCheckOpBankNumField(String checkOpBankNumField) {
        this.checkOpBankNumField = checkOpBankNumField;
    }
}

