/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.similarity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.risk.RiskItemResult;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RiskCheckScopeEnum;
import kd.tmc.fcs.common.enums.ScreenItemEnum;
import kd.tmc.fcs.common.helper.ConditionFactory;
import kd.tmc.fcs.common.helper.RiskServiceHelper;
import kd.tmc.fcs.mservice.similarity.BillTextDiagConfig;
import kd.tmc.fcs.mservice.similarity.DiagnosisResult;
import kd.tmc.fcs.mservice.similarity.SimilarityRequest;
import kd.tmc.fcs.mservice.similarity.SimilarityResponse;
import kd.tmc.fcs.mservice.similarity.TextSimilarityService;

public class BusinessDiagnosisService {
    private static final Log logger = LogFactory.getLog(BusinessDiagnosisService.class);
    private static final int BATCH_REQUEST = 50;
    private static final int QUERY_BATCH_SIZE = 5000;

    public List<RiskItemResult> diagnosis(List<Long> orgBillIds, DynamicObject riskItemConfig) {
        HashSet<Long> billIdList = new HashSet<Long>(orgBillIds);
        int batchSize = billIdList.size();
        long diaStartTime = System.currentTimeMillis();
        String diaItemName = ScreenItemEnum.getName((String)riskItemConfig.getString("screenitem"));
        logger.info("\u7b5b\u67e5\u9879\u8be6\u60c5\u3010{}\u3011\u6279\u6b21\u5f00\u542f\u3010{}\u3011", (Object)diaItemName, (Object)batchSize);
        ArrayList<DiagnosisResult> resultList = new ArrayList<DiagnosisResult>(10);
        List<BillTextDiagConfig> configList = BillTextDiagConfig.loadFromDynamicObject(riskItemConfig);
        if (RiskCheckScopeEnum.CONTENT.getValue().equals(configList.get(0).getScope())) {
            resultList.addAll(this.diagnosisDesc(billIdList, configList.get(0)));
        } else {
            ConditionFactory factory = new ConditionFactory();
            for (BillTextDiagConfig config : configList) {
                long startTime = System.currentTimeMillis();
                Set<Long> matchIds = new HashSet<Long>(billIdList);
                if (EmptyUtil.isNotBlank((CharSequence)config.getFilterCondition())) {
                    CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)config.getFilterCondition(), CRCondition.class);
                    factory.init(conditionObj, config.getBillNumber());
                    matchIds = factory.runCondition(new HashSet<Long>(billIdList));
                }
                if (EmptyUtil.isEmpty(matchIds)) {
                    logger.info("\u672c\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u82b1\u8d39\uff08ms\uff09:{}", (Object)(System.currentTimeMillis() - startTime));
                    continue;
                }
                if (EmptyUtil.isEmpty(matchIds = this.filterInGroup(matchIds, config.getBillNumber(), config.getBillOpBankNumField()))) {
                    logger.info("\u672c\u5355\u636e\u90fd\u662f\u96c6\u56e2\u5916\u5355\u636e\uff0c\u82b1\u8d39\uff08ms\uff09:{}", (Object)(System.currentTimeMillis() - startTime));
                    continue;
                }
                QFilter objectFilter = null;
                if (EmptyUtil.isNotBlank((CharSequence)config.getObjectScope())) {
                    CRCondition conditionObj = (CRCondition)SerializationUtils.fromJsonString((String)config.getObjectScope(), CRCondition.class);
                    FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)config.getCheckNumber()), conditionObj.getFilterCondition());
                    fb.buildFilter();
                    objectFilter = fb.getQFilter();
                }
                String selectProp = "id,billno," + config.getBillCompanyField() + "," + config.getBillAcctField();
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryDiagBusiness", (String)config.getBillNumber(), (String)selectProp, (QFilter[])new QFilter("id", "in", matchIds).toArray(), (String)config.getBillAcctField());
                Throwable throwable = null;
                try {
                    HashMap<Long, List<Tuple<Long, String[]>>> orgBillMap = new HashMap<Long, List<Tuple<Long, String[]>>>(16);
                    int size = 0;
                    for (Row row : dataSet) {
                        Long billCom = row.getLong(config.getBillAcctField());
                        String checkCom = row.getString(config.getBillCompanyField());
                        if (EmptyUtil.isEmpty((Long)billCom) || EmptyUtil.isBlank((CharSequence)checkCom)) continue;
                        List bills = orgBillMap.computeIfAbsent(billCom, t -> new ArrayList(10));
                        bills.add(Tuple.create((Object)row.getLong("id"), (Object)new String[]{row.getString("billno"), checkCom}));
                        if (++size < 5000) continue;
                        List<DiagnosisResult> checkResults = this.diagnosisOrgBusiness(orgBillMap, config, objectFilter);
                        if (EmptyUtil.isNoEmpty(checkResults)) {
                            resultList.addAll(checkResults);
                            Set errorBillIds = checkResults.stream().map(DiagnosisResult::getBillId).collect(Collectors.toSet());
                            billIdList.removeAll(errorBillIds);
                        }
                        size = 0;
                        orgBillMap.clear();
                    }
                    if (orgBillMap.isEmpty()) continue;
                    resultList.addAll(this.diagnosisOrgBusiness(orgBillMap, config, objectFilter));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataSet == null) continue;
                    if (throwable != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataSet.close();
                }
            }
        }
        logger.info("\u7b5b\u67e5\u9879\u8be6\u60c5\u3010{}\u3011\u6279\u6b21\u7ed3\u675f\u3010{}\u3011\uff0c\u82b1\u8d39(ms)\u3010{}\u3011", new Object[]{diaItemName, batchSize, System.currentTimeMillis() - diaStartTime});
        return resultList.stream().map(t -> this.toErrorResult(riskItemConfig, (DiagnosisResult)t)).collect(Collectors.toList());
    }

    private List<DiagnosisResult> diagnosisOrgBusiness(Map<Long, List<Tuple<Long, String[]>>> orgBillMap, BillTextDiagConfig config, QFilter objectFilter) {
        ArrayList<DiagnosisResult> results = new ArrayList<DiagnosisResult>(10);
        for (Map.Entry<Long, List<Tuple<Long, String[]>>> entry : orgBillMap.entrySet()) {
            Set<Long> checkIds;
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(new QFilter(config.getCheckAcctField(), "=", (Object)entry.getKey()));
            if (null != objectFilter) {
                filterList.add(objectFilter);
            }
            if (EmptyUtil.isEmpty(checkIds = QueryServiceHelper.queryPrimaryKeys((String)config.getCheckNumber(), (QFilter[])filterList.toArray(new QFilter[0]), null, (int)-1).stream().map(t -> Long.parseLong(t.toString())).collect(Collectors.toSet())) || EmptyUtil.isEmpty(checkIds = this.filterInGroup(checkIds, config.getCheckNumber(), config.getCheckOpBankNumField()))) continue;
            logger.info("\u5355\u636e\u7ec4\u7ec7\u3010{}\u3011\u68c0\u67e5\u96c6\u56e2\u5185\u4e1a\u52a1\u7b5b\u67e5\u5bf9\u8c61\u5927\u5c0f\u3010{}\u3011", (Object)entry.getKey(), (Object)checkIds.size());
            results.addAll(this.diagnosisSimilar(entry.getValue(), checkIds, config));
        }
        return results;
    }

    private RiskItemResult toErrorResult(DynamicObject riskItemConfig, DiagnosisResult result) {
        RiskItemResult errorResult = new RiskItemResult();
        String number = riskItemConfig.getDynamicObject("appbill").getString("number");
        errorResult.setDataType(number);
        errorResult.setBillId(result.getBillId());
        errorResult.setBillNo(result.getBillNumber());
        errorResult.setErrorDescDetail(result.getErrorDetail());
        return errorResult;
    }

    public List<DiagnosisResult> diagnosisDesc(Set<Long> billIdList, BillTextDiagConfig config) {
        ArrayList<DiagnosisResult> results = new ArrayList<DiagnosisResult>(10);
        String billCompanyField = config.getBillCompanyField();
        String billOpBankNumField = config.getBillOpBankNumField();
        String billDescField = config.getBillDescField();
        String billProp = "id," + billDescField + "," + billCompanyField + "," + billOpBankNumField;
        try (DataSet billSet = QueryServiceHelper.queryDataSet((String)"diagnosisDesc", (String)config.getBillNumber(), (String)billProp, (QFilter[])new QFilter[]{new QFilter("id", "in", billIdList)}, null);){
            HashMap<Long, String[]> billBatchMap = new HashMap<Long, String[]>(16);
            for (Row row : billSet) {
                if (EmptyUtil.isBlank((CharSequence)row.getString(billDescField)) || EmptyUtil.isBlank((CharSequence)row.getString(billCompanyField)) || EmptyUtil.isBlank((CharSequence)row.getString(billOpBankNumField))) continue;
                billBatchMap.put(row.getLong("id"), new String[]{row.getString(billDescField), row.getString(billCompanyField), row.getString(billOpBankNumField)});
                if (billBatchMap.size() < 5000) continue;
                results.addAll(this.batchDiagnosisDesc(billBatchMap, config));
                billBatchMap.clear();
            }
            if (!billBatchMap.isEmpty()) {
                results.addAll(this.batchDiagnosisDesc(billBatchMap, config));
            }
        }
        return results;
    }

    private List<DiagnosisResult> batchDiagnosisDesc(Map<Long, String[]> billBatchMap, BillTextDiagConfig config) {
        if (!(billBatchMap = this.filterInnerBankNum(billBatchMap.entrySet(), t -> ((String[])t.getValue())[2]).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            Set companyIds = billBatchMap.values().stream().map(strings -> strings[1]).collect(Collectors.toSet());
            String companyField = config.getCompanyField();
            String businessField = config.getCompanyBusinessField();
            String selectFields = companyField + "," + businessField;
            Map<Object, String> comMap = QueryServiceHelper.query((String)config.getCompanyNumber(), (String)selectFields, (QFilter[])new QFilter(companyField, "in", companyIds).toArray()).stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.get(businessField))).collect(Collectors.toMap(t -> t.get(companyField), t -> t.getString(businessField), (p, q) -> p));
            List<SimilarityRequest> requests = billBatchMap.entrySet().stream().map(t -> new SimilarityRequest(((Long)t.getKey()).toString(), ((String[])t.getValue())[0], (String)comMap.get(((String[])t.getValue())[1]))).filter(t -> EmptyUtil.isNotBlank((CharSequence)t.getDesc()) && EmptyUtil.isNotBlank((CharSequence)t.getBusiness())).collect(Collectors.toList());
            return this.requestSimDesc(requests, config);
        }
        return Collections.emptyList();
    }

    private <T> Collection<T> filterInnerBankNum(Collection<T> list, Function<T, String> opFun) {
        Set opNums = list.stream().map(opFun).collect(Collectors.toSet());
        QFilter accountFilter = new QFilter("bankaccountnumber", "in", opNums);
        Set inBanks = RiskServiceHelper.getAccountNumberByFilter((QFilter[])accountFilter.toArray());
        return list.stream().filter(t -> !inBanks.contains(opFun.apply(t))).collect(Collectors.toList());
    }

    private List<DiagnosisResult> requestSimDesc(List<SimilarityRequest> requests, BillTextDiagConfig config) {
        Map requestMap = requests.stream().collect(Collectors.toMap(SimilarityRequest::getId, Function.identity(), (p, q) -> p));
        return Lists.partition(requests, (int)50).stream().flatMap(p -> TextSimilarityService.descRequest(p).entrySet().stream().map(t -> this.toDigContentResult((String)t.getKey(), ((SimilarityResponse)t.getValue()).getSimilarity(), (SimilarityRequest)requestMap.get(t.getKey()))).filter(t -> t.getSimilarity() >= 0.0 && t.getSimilarity() < config.getThreshold())).collect(Collectors.toList());
    }

    private DiagnosisResult toDigContentResult(String id, Double similarity, SimilarityRequest request) {
        DiagnosisResult result = new DiagnosisResult();
        result.setBillId(Long.parseLong(id));
        result.setDesc(request.getDesc());
        result.setBusiness(request.getBusiness());
        result.setSimilarity(similarity);
        result.setErrorDetail(String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u4ea4\u6613\u5bf9\u624b\u7684\u4e3b\u8425\u4e1a\u52a1\u662f\u201c%1$s\u201d\uff0c\u4f46\u5f53\u524d\u4ea4\u6613\u7684\u4e1a\u52a1\u4e8b\u7531\u662f\u201c%2$s\u201d\uff0c\u4e0e\u4ea4\u6613\u5bf9\u624b\u7684\u4e3b\u8425\u4e1a\u52a1\u4e0d\u76f8\u7b26\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"BusinessDiagnosisService_0", (String)"tmc-fcs-mservice", (Object[])new Object[0]), request.getBusiness(), request.getDesc()));
        return result;
    }

    public List<DiagnosisResult> diagnosisSimilar(List<Tuple<Long, String[]>> billList, Collection<Long> checkIdList, BillTextDiagConfig config) {
        ArrayList<DiagnosisResult> resultList = new ArrayList<DiagnosisResult>(10);
        String checkCompanyField = config.getCheckCompanyField();
        HashMap<Long, Tuple<String, String>> checkMap = new HashMap<Long, Tuple<String, String>>(16);
        HashSet<String> companyIds = new HashSet<String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"diagnosisSimilar", (String)config.getCheckNumber(), (String)("id,billno," + checkCompanyField), (QFilter[])new QFilter("id", "in", checkIdList).toArray(), null);){
            for (Row row : dataSet) {
                String checkCompany = row.getString(checkCompanyField);
                if (EmptyUtil.isNotBlank((CharSequence)checkCompany) && !companyIds.contains(checkCompany)) {
                    if (!companyIds.contains("checkCompany")) {
                        companyIds.add(checkCompany);
                    }
                    checkMap.put(row.getLong("id"), (Tuple<String, String>)Tuple.create((Object)row.getString("billno"), (Object)checkCompany));
                }
                if (companyIds.size() < 50) continue;
                List<DiagnosisResult> batchRes = this.requestSimilarity(billList, checkMap, companyIds, config);
                companyIds.clear();
                checkMap.clear();
                if (batchRes.isEmpty()) continue;
                Set removeIds = batchRes.stream().map(DiagnosisResult::getBillId).collect(Collectors.toSet());
                billList = billList.stream().filter(t -> !removeIds.contains(t.item1)).collect(Collectors.toList());
                resultList.addAll(batchRes);
                if (!billList.isEmpty()) continue;
                break;
            }
        }
        if (!checkMap.isEmpty()) {
            List<DiagnosisResult> batchRes = this.requestSimilarity(billList, checkMap, companyIds, config);
            resultList.addAll(batchRes);
        }
        return resultList;
    }

    private List<DiagnosisResult> requestSimilarity(List<Tuple<Long, String[]>> billList, Map<Long, Tuple<String, String>> checkMap, Set<String> companyIds, BillTextDiagConfig config) {
        ArrayList<DiagnosisResult> resultList = new ArrayList<DiagnosisResult>(10);
        String companyField = config.getCompanyField();
        String businessField = config.getCompanyBusinessField();
        Set billCompanyIds = billList.stream().map(t -> ((String[])t.item2)[1]).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        companyIds.addAll(billCompanyIds);
        String selectFields = companyField + "," + businessField;
        Map<Object, String> comMap = QueryServiceHelper.query((String)config.getCompanyNumber(), (String)selectFields, (QFilter[])new QFilter(companyField, "in", companyIds).toArray()).stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.get(businessField))).collect(Collectors.toMap(t -> t.get(companyField), t -> t.getString(businessField), (p, q) -> p));
        checkMap = checkMap.entrySet().stream().filter(t -> comMap.containsKey(((Tuple)t.getValue()).item2)).collect(Collectors.toMap(t -> (String)comMap.get(((Tuple)t.getValue()).item2), Function.identity(), (p, q) -> p)).values().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (p, q) -> p));
        if (checkMap.isEmpty()) {
            return resultList;
        }
        List<SimilarityRequest> requests = checkMap.entrySet().stream().map(t -> new SimilarityRequest(((Long)t.getKey()).toString(), null, (String)comMap.get(((Tuple)t.getValue()).item2))).collect(Collectors.toList());
        Map requestMap = requests.stream().collect(Collectors.toMap(SimilarityRequest::getId, Function.identity(), (p, q) -> p));
        Map<String, List<Tuple>> billListMap = billList.stream().filter(t -> comMap.containsKey(((String[])t.item2)[1])).collect(Collectors.groupingBy(t -> (String)comMap.get(((String[])t.item2)[1])));
        for (Map.Entry<String, List<Tuple>> entry : billListMap.entrySet()) {
            String billCompanyBuz = entry.getKey();
            Optional<Map.Entry> optional = TextSimilarityService.businessRequest(billCompanyBuz, requests).entrySet().stream().filter(t -> ((SimilarityResponse)t.getValue()).getSimilarity() > config.getThreshold()).findFirst();
            if (!optional.isPresent()) continue;
            Map.Entry resEntry = optional.get();
            Tuple<String, String> tuple = checkMap.get(Long.parseLong((String)resEntry.getKey()));
            SimilarityRequest request = (SimilarityRequest)requestMap.get(resEntry.getKey());
            List<DiagnosisResult> results = entry.getValue().stream().map(t -> this.toDiaBuzResult((Tuple<Long, String[]>)t, billCompanyBuz, (String)resEntry.getKey(), ((SimilarityResponse)resEntry.getValue()).getSimilarity(), (String)tuple.item1, request.getBusiness())).collect(Collectors.toList());
            results.forEach(t -> logger.info("\u5355\u636e\u3010{}\u3011\u3010{}\u3011\u4e0e\u7b5b\u67e5\u5355\u636e\u3010{}\u3011\u3010{}\u3011\u4e3b\u8425\u4e1a\u52a1\u76f8\u4f3c", new Object[]{config.getBillNumber(), t.getBillNumber(), config.getCheckNumber(), t.getSimilarBillNumber()}));
            resultList.addAll(results);
        }
        return resultList;
    }

    private DiagnosisResult toDiaBuzResult(Tuple<Long, String[]> bill, String billBusiness, String id, Double similarity, String checkBillNumber, String simBusiness) {
        DiagnosisResult result = new DiagnosisResult();
        result.setBillId((Long)bill.item1);
        result.setBillNumber(((String[])bill.item2)[0]);
        result.setBusiness(billBusiness);
        result.setSimilarBillId(Long.parseLong(id));
        result.setSimilarBillNumber(checkBillNumber);
        result.setSimilarBusiness(simBusiness);
        result.setSimilarity(similarity);
        result.setErrorDetail(ResManager.loadKDString((String)"\u901a\u8fc7\u5927\u6570\u636e\u5206\u6790\uff0c\u8be5\u7b14\u4ea4\u6613\u5bf9\u624b\u7684\u4e3b\u8425\u4e1a\u52a1\u4e0e\u8fc7\u5f80\u5df2\u53d1\u751f\u4ea4\u6613\u7684\u4ea4\u6613\u5bf9\u624b\u7684\u4e3b\u8425\u4e1a\u52a1\u76f8\u4f3c\uff0c\u5b58\u5728\u4e1a\u52a1\u98ce\u9669\u3002", (String)"BusinessDiagnosisService_1", (String)"tmc-fcs-mservice", (Object[])new Object[0]));
        return result;
    }

    private Set<Long> filterInGroup(Set<Long> list, String billNumber, String opBankField) {
        String accProp = "id," + opBankField;
        HashSet<String> allAcct = new HashSet<String>(16);
        HashMap<Long, String> acctMap = new HashMap<Long, String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"filterInGroup", (String)billNumber, (String)accProp, (QFilter[])new QFilter("id", "in", list).toArray(), null);){
            for (Row row : dataSet) {
                String opBank = row.getString(opBankField);
                if (!EmptyUtil.isNotBlank((CharSequence)opBank)) continue;
                allAcct.add(opBank);
                acctMap.put(row.getLong("id"), opBank);
            }
        }
        if (acctMap.isEmpty()) {
            return Collections.emptySet();
        }
        QFilter accountFilter = new QFilter("bankaccountnumber", "in", allAcct);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryAccountBank", (String)"bd_accountbanks", (String)"bankaccountnumber", (QFilter[])accountFilter.toArray(), null);
        Object object = null;
        try {
            HashSet<String> accountSet = new HashSet<String>(16);
            for (Row row : dataSet) {
                String bankNum = row.getString("bankaccountnumber");
                if (!EmptyUtil.isNotBlank((CharSequence)bankNum)) continue;
                accountSet.add(bankNum);
            }
            Set set = acctMap.entrySet().stream().filter(t -> accountSet.contains(t.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            return set;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }
}

