/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.similarity;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.service.ebservice.http.HttpHelper;
import kd.tmc.fcs.common.helper.RiskServiceHelper;
import kd.tmc.fcs.mservice.similarity.SimilarityRequest;
import kd.tmc.fcs.mservice.similarity.SimilarityResponse;

public class TextSimilarityService {
    private static final Log logger = LogFactory.getLog(TextSimilarityService.class);

    public static Map<String, SimilarityResponse> descRequest(List<SimilarityRequest> dataList) {
        Map<String, SimilarityResponse> res = new HashMap<String, SimilarityResponse>(16);
        String url = RiskServiceHelper.getRiskServerPath() + "/similar/desc";
        try {
            Map<String, List<SimilarityRequest>> request = Collections.singletonMap("data", dataList);
            String req = SerializationUtils.toJsonString(request);
            String response = HttpHelper.doPost((String)url, (String)req, (int)5000);
            logger.info("desc similarity request {} return", (Object)dataList.size());
            Map resMap = new HashMap(16);
            resMap = (Map)SerializationUtils.fromJsonString((String)response, resMap.getClass());
            Object data = resMap.get("data");
            if (null != data) {
                List list = (List)data;
                res = list.stream().map(TextSimilarityService::toResponse).collect(Collectors.toMap(SimilarityResponse::getId, Function.identity(), (p, q) -> p));
                SimilarityRequest sampleRequest = dataList.get(0);
                logger.info("first desc request {}, response {}", (Object)SerializationUtils.toJsonString((Object)sampleRequest), (Object)SerializationUtils.toJsonString(list.get(0)));
            }
        }
        catch (Exception e) {
            logger.error("request desc error:", (Throwable)e);
            throw e;
        }
        return res;
    }

    private static SimilarityResponse toResponse(Map<String, Object> map) {
        SimilarityResponse response = new SimilarityResponse();
        response.setId(map.get("id").toString());
        response.setSimilarity(Double.parseDouble(map.get("similarity").toString()));
        return response;
    }

    public static Map<String, SimilarityResponse> businessRequest(String billBusiness, List<SimilarityRequest> dataList) {
        Map<String, SimilarityResponse> res = new HashMap<String, SimilarityResponse>(16);
        String url = RiskServiceHelper.getRiskServerPath() + "/similar/business";
        try {
            HashMap<String, Object> request = new HashMap<String, Object>(16);
            request.put("billBusiness", billBusiness);
            request.put("data", dataList);
            String req = SerializationUtils.toJsonString(request);
            String response = HttpHelper.doPost((String)url, (String)req, (int)5000);
            logger.info("business similarity request size {} return", (Object)dataList.size());
            Map resMap = new HashMap(16);
            resMap = (Map)SerializationUtils.fromJsonString((String)response, resMap.getClass());
            Object data = resMap.get("data");
            if (null != data) {
                List list = (List)data;
                res = list.stream().map(TextSimilarityService::toResponse).collect(Collectors.toMap(SimilarityResponse::getId, Function.identity(), (p, q) -> p));
                SimilarityRequest sampleRequest = dataList.get(0);
                logger.info("first business request {}, response {}", (Object)SerializationUtils.toJsonString((Object)sampleRequest), (Object)SerializationUtils.toJsonString((Object)res.get(sampleRequest.getId())));
            }
        }
        catch (Exception e) {
            logger.error("request business error:", (Throwable)e);
            throw e;
        }
        return res;
    }
}

