/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.snap;

import com.alibaba.fastjson.JSON;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.SnapDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.log.bean.SnapLog;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.SnapGenerateHelper;
import kd.tmc.fcs.common.helper.SnapSchemeHelper;

public class GenSnapService {
    private static final Log logger = LogFactory.getLog(GenSnapService.class);

    public void genSnap(DynamicObject snapScheme, String type) {
        long time = System.nanoTime();
        SnapLog snapLog = new SnapLog();
        DataSet ds = null;
        try {
            Long orgId = snapScheme.getDynamicObject("org").getLong("id");
            RequestContext.get().setOrgId(orgId.longValue());
            String queryPlugin = snapScheme.getString("plugin");
            String schemeId = (String)snapScheme.getDynamicObject("queryscheme").getPkValue();
            DynamicObject reportForm = snapScheme.getDynamicObject("reportform");
            snapLog = SnapDataHelper.createSnapLog((DynamicObject)snapScheme, (DynamicObject)reportForm);
            String formId = reportForm.getString("number");
            DynamicObjectCollection paramEntry = snapScheme.getDynamicObjectCollection("param_entry");
            QFilter[] filters = SnapSchemeHelper.parseFilter((DynamicObjectCollection)paramEntry);
            ds = SnapGenerateHelper.snapGenerate((String)queryPlugin, (String)formId, (String)schemeId, (QFilter[])filters, (String)snapScheme.getString("number"));
        }
        catch (Throwable e) {
            snapLog.setException(JSON.toJSONString((Object)e.getStackTrace()));
            logger.error("\u751f\u6210\u5feb\u7167\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", e);
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u5feb\u7167\u6570\u636e\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"GenSnapService_0", (String)"tmc-fcs-mservice", (Object[])new Object[]{e.getMessage()}));
        }
        finally {
            if (null != ds) {
                ds.close();
            }
            Long costMs = (System.nanoTime() - time) / 1000L / 1000L;
            if (EmptyUtil.isNoEmpty((Object)snapLog)) {
                snapLog.setCosttime(costMs);
                snapLog.setType(type);
            }
            this.saveSnapLog(snapLog);
        }
    }

    private void saveSnapLog(SnapLog snapLog) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fcs_snaplog");
        log.set("report", (Object)snapLog.getReport());
        log.set("snapscheme", (Object)snapLog.getSnapScheme());
        log.set("traceid", (Object)snapLog.getTraceid());
        log.set("type", (Object)snapLog.getType());
        log.set("costtime", (Object)snapLog.getCosttime());
        log.set("exception", snapLog.getException() != null ? snapLog.getException().substring(0, Math.min(255, snapLog.getException().length())) : null);
        log.set("exception_TAG", (Object)snapLog.getException());
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        TmcDataServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

