/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.snap.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fcs.mservice.snap.GenSnapService;

public class GenSnapScheduleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(GenSnapScheduleTask.class);
    private static final int PAGE_SIZE = 100;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        logger.info("\u751f\u6210\u5feb\u7167\u8c03\u5ea6\u4efb\u52a1start...");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        int totalCnt = TmcDataServiceHelper.count((String)"fcs_snapscheme", (QFilter[])filter.toArray());
        logger.info("\u751f\u6210\u5feb\u7167\u8c03\u5ea6\u4efb\u52a1\u6570\u91cf\uff1a" + totalCnt);
        StringBuilder errorMsgs = new StringBuilder(16);
        int pageIndex = 0;
        for (int pages = totalCnt % 100 == 0 ? totalCnt / 100 : totalCnt / 100 + 1; pages > 0; --pages) {
            DynamicObject[] snapSchemes = TmcDataServiceHelper.load((String)"fcs_snapscheme", (String)"number,name,org,plugin,reportform,queryscheme,param_entry.paramname,param_entry.paramtype,param_entry.paramvalue,param_entry.basedatainfo", (QFilter[])new QFilter[]{filter}, (String)"", (int)pageIndex, (int)100);
            logger.info("pageIndex: " + pageIndex + "\u8c03\u5ea6\u4efb\u52a1\u5f85\u751f\u6210\u5feb\u7167\u6570\u91cf\uff1a" + snapSchemes.length);
            for (DynamicObject snapScheme : snapSchemes) {
                try {
                    new GenSnapService().genSnap(snapScheme, "schedule");
                }
                catch (Exception e) {
                    String errorMsg = e.getMessage();
                    String schemeName = snapScheme.getString("name");
                    errorMsgs.append(schemeName).append(ResManager.loadKDString((String)"\u62a5\u8868\u751f\u6210\u5feb\u7167\u9519\u8bef\uff0c\u9519\u8bef\u4fe1\u606f\uff1a%s\u3002", (String)"GenSnapScheduleTask_0", (String)"tmc-fcs-mservice", (Object[])new Object[]{errorMsg})).append("\n");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)errorMsgs.toString())) {
            throw new KDBizException(errorMsgs.toString());
        }
        logger.info("\u751f\u6210\u5feb\u7167\u8c03\u5ea6\u4efb\u52a1end...");
    }
}

