/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.mservice.subscribe;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.mservice.repeat.PayAccessRepeatCtrlServiceImpl;

public class TmcSubscribeService {
    private static Log logger = LogFactory.getLog(PayAccessRepeatCtrlServiceImpl.class);
    private static final String KEY_OPERATEKEY = "operatekey";
    private static final String KEY_BILLID = "billid";
    private static final String KEY_ENTITYNAME = "entityname";
    private static final String KEY_BILLNO = "billno";

    public void subscribe(String params) {
        logger.info("subscribe paramas:{}", (Object)params);
        if (EmptyUtil.isEmpty((String)params)) {
            return;
        }
        List paramMap = (List)SerializationUtils.fromJsonString((String)params, List.class);
        String entityName = (String)((Map)paramMap.get(0)).get(KEY_ENTITYNAME);
        QFilter filter = new QFilter("datasource.number", "=", (Object)entityName).and(new QFilter("enable", "=", (Object)"1"));
        if (!TmcDataServiceHelper.exists((String)"fbd_subscribe", (QFilter[])filter.toArray())) {
            logger.info("no subscribe, entityName:{}", (Object)entityName);
            return;
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                ArrayList<DynamicObject> pools = new ArrayList<DynamicObject>(paramMap.size());
                for (Map param : paramMap) {
                    DynamicObject pool = TmcDataServiceHelper.newDynamicObject((String)"fbd_billpool");
                    pool.set("datasource", (Object)entityName);
                    pool.set(KEY_BILLNO, param.get(KEY_BILLNO));
                    pool.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                    pool.set(KEY_BILLID, param.get(KEY_BILLID));
                    pool.set(KEY_OPERATEKEY, param.get(KEY_OPERATEKEY));
                    pools.add(pool);
                }
                OperationServiceHelper.executeOperate((String)"save", (String)"fbd_billpool", (DynamicObject[])pools.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error((Throwable)e);
            }
        }
    }
}

