/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.IOperationResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.constant.RpcResultStatusCode;
import kd.tmc.fcs.mservice.archive.ArchiveResult;
import kd.tmc.fcs.mservice.archive.IArchiveService;

public class ArchiveOpService
extends AbstractTmcBizOppService {
    private List<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>();

    public List<String> getSelector() {
        List selectors = super.getSelector();
        selectors.add("srctype");
        selectors.add("archivetype");
        selectors.add("timeprop");
        selectors.add("day");
        selectors.add("livetime");
        selectors.add("archivefilter");
        selectors.add("archivefilter_TAG");
        selectors.add("filtergridap");
        selectors.add("archiveliveday");
        selectors.add("archivemincnt");
        selectors.add("archivedel");
        selectors.add("onlydelete");
        return selectors;
    }

    public void process(DynamicObject[] settings) throws KDException {
        List<ArchiveResult> archiveResultList = this.runService(settings);
        Map idToObjMap = Arrays.stream(settings).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity()));
        for (ArchiveResult result : archiveResultList) {
            if (result.getStatusCode() == RpcResultStatusCode.SUCCESS) continue;
            Long settingId = result.getArchiveSettingId();
            DynamicObject setting = (DynamicObject)idToObjMap.get(settingId);
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("", ErrorLevel.Error, setting.getPkValue(), (Object)setting.getDynamicObjectType().getName());
            operateErrorInfo.setMessage(setting.get("number") + ":" + result.getMessage());
            this.errorInfoList.add(operateErrorInfo);
        }
    }

    public void onReturnOperation(IOperationResult result) {
        for (OperateErrorInfo operateErrorInfo : this.errorInfoList) {
            result.addErrorInfo(operateErrorInfo);
        }
    }

    protected List<ArchiveResult> runService(DynamicObject[] settings) {
        IArchiveService service = IArchiveService.create();
        return service.archive(Arrays.asList(settings));
    }
}

