/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billbalance;

import java.sql.Timestamp;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDigestHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.business.opservice.billbalance.config.AmountMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BalanceMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BillDimBalanceConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.FreezeMapConfig;
import kd.tmc.fcs.common.enums.BillBalanceMapEnum;

public class BillDimBalanceHelper {
    private static final String KEY_COL = "%s:%s,%s:%s,%s:%s,%s:%s,";

    public static BillDimBalanceConfig getBillDimBalanceConfig(DynamicObject billDim) {
        String billEntity = billDim.getString("billentity.number");
        QFilter billFilter = BillDimBalanceHelper.getFilterGridFilter(billDim.getString("billfilter_tag"), billEntity);
        BillDimBalanceConfig dimConfig = BillDimBalanceConfig.build(billEntity, billDim.getString("billbalentity.number"), billFilter);
        dimConfig.setBillIdProp(billDim.getString("billidprop")).setOrgProp(billDim.getString("orgprop")).setCurrencyProp(billDim.getString("currencyprop")).setStartDateProp(billDim.getString("startdateprop")).setEndDateProp(billDim.getString("enddateprop")).setCreateBalCycle(billDim.getString("createbalcycle"));
        String dimenProps = billDim.getString("dimenprops");
        if (EmptyUtil.isNoEmpty((String)dimenProps) && !dimenProps.equals(",,")) {
            String[] split;
            for (String p : split = dimenProps.substring(1, dimenProps.length() - 1).split(",")) {
                dimConfig.addDimenProp(p);
            }
        }
        DynamicObjectCollection initAmountEntry = billDim.getDynamicObjectCollection("initamountentry");
        for (DynamicObject entry : initAmountEntry) {
            String entityNumber = entry.getDynamicObject("ie_billentity").getString("number");
            QFilter filter = BillDimBalanceHelper.getFilterGridFilter(entry.getString("ie_filter_tag"), entityNumber);
            AmountMapConfig amountMapConfig = AmountMapConfig.build(entityNumber, entry.getString("ie_srcbillprop"), entry.getString("ie_bizdateprop"), entry.getString("ie_amountprop"), entry.getString("ie_loansign"), filter).setDestBillProp(entry.getString("ie_destbillprop"));
            dimConfig.addInitAmountEntry(amountMapConfig);
        }
        DynamicObjectCollection amountEntry = billDim.getDynamicObjectCollection("amountentry");
        for (DynamicObject entry : amountEntry) {
            String entityNumber = entry.getDynamicObject("ae_billentity").getString("number");
            QFilter filter = BillDimBalanceHelper.getFilterGridFilter(entry.getString("ae_filter_tag"), entityNumber);
            AmountMapConfig amountMapConfig = AmountMapConfig.build(entityNumber, entry.getString("ae_srcbillprop"), entry.getString("ae_bizdateprop"), entry.getString("ae_amountprop"), entry.getString("ae_loansign"), filter).setDestBillProp(entry.getString("ae_destbillprop"));
            dimConfig.addAmountEntry(amountMapConfig);
        }
        DynamicObjectCollection freezeEntry = billDim.getDynamicObjectCollection("freezeentry");
        for (DynamicObject entry : freezeEntry) {
            String entityNumber = entry.getDynamicObject("fe_billentity").getString("number");
            QFilter filter = BillDimBalanceHelper.getFilterGridFilter(entry.getString("fe_filter_tag"), entityNumber);
            FreezeMapConfig freezeMapConfig = FreezeMapConfig.build(entityNumber, entry.getString("fe_srcbillprop"), entry.getString("fe_bizdateprop"), entry.getString("fe_amountprop"), entry.getString("fe_freezetypeprop"), filter).setDestBillProp(entry.getString("fe_destbillprop"));
            dimConfig.addFreezeAmountEntry(freezeMapConfig);
        }
        BillDimBalanceHelper.getBillBalConfig(billDim, dimConfig.getBillBalConfig());
        return dimConfig;
    }

    private static void getBillBalConfig(DynamicObject billDim, BalanceMapConfig balanceMapConfig) {
        DynamicObjectCollection billBalEntry = billDim.getDynamicObjectCollection("billbalentry");
        block12: for (DynamicObject entry : billBalEntry) {
            String balProp = entry.getString("be_balprop");
            String balSelProp = entry.getString("be_balselprop");
            BillBalanceMapEnum propEnum = BillBalanceMapEnum.getEnum((String)balProp);
            if (propEnum != null) {
                switch (propEnum) {
                    case ID: {
                        balanceMapConfig.setBillIdProp(balSelProp);
                        continue block12;
                    }
                    case ORG: {
                        balanceMapConfig.setOrgProp(balSelProp);
                        continue block12;
                    }
                    case CURRENCY: {
                        balanceMapConfig.setCurrencyProp(balSelProp);
                        continue block12;
                    }
                    case BIZDATE: {
                        balanceMapConfig.setBizDateProp(balSelProp);
                        continue block12;
                    }
                    case AMOUNT: {
                        balanceMapConfig.setAmountProp(balSelProp);
                        continue block12;
                    }
                    case DEBITAMOUNT: {
                        balanceMapConfig.setDebitAmountProp(balSelProp);
                        continue block12;
                    }
                    case CREDITAMOUNT: {
                        balanceMapConfig.setCreditAmountProp(balSelProp);
                        continue block12;
                    }
                    case VALIBALANCE: {
                        balanceMapConfig.setValiBalanceProp(balSelProp);
                        continue block12;
                    }
                    case LSTBALANCE: {
                        balanceMapConfig.setLstBalanceProp(balSelProp);
                        continue block12;
                    }
                    case FREEZEBALANCE: {
                        balanceMapConfig.setFreezeBalanceProp(balSelProp);
                        continue block12;
                    }
                }
                continue;
            }
            balanceMapConfig.addDimenProp(balProp, balSelProp);
        }
    }

    public static QFilter getFilterGridFilter(String filterTag, String entityName) {
        if (EmptyUtil.isEmpty((String)filterTag)) {
            return null;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterTag, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)entityName), filterCondition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    public static String genKeyCol(DynamicObject balanceObj, BalanceMapConfig balanceMapConfig) {
        Date bizDate = balanceObj.getDate(balanceMapConfig.getBizDateProp());
        if (bizDate == null) {
            return " ";
        }
        String keyCol = String.format(KEY_COL, balanceMapConfig.getBillIdProp(), balanceObj.getLong(balanceMapConfig.getBillIdProp()), balanceMapConfig.getBizDateProp(), new Timestamp(bizDate.getTime()), balanceMapConfig.getOrgProp(), balanceObj.getLong(balanceMapConfig.getOrgProp()), balanceMapConfig.getCurrencyProp(), balanceObj.getLong(balanceMapConfig.getCurrencyProp()));
        return TmcDigestHelper.getSHA256Base64Str((String)keyCol);
    }
}

