/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.actions.SerializationUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.business.opservice.billbalance.BillDimBalanceHelper;
import kd.tmc.fcs.business.opservice.billbalance.BillDimBalanceInfo;
import kd.tmc.fcs.business.opservice.billbalance.BillDimBalanceParam;
import kd.tmc.fcs.business.opservice.billbalance.BillDimDataDAOService;
import kd.tmc.fcs.business.opservice.billbalance.BillDimDataService;
import kd.tmc.fcs.business.opservice.billbalance.config.BalanceMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BillDimBalanceConfig;
import kd.tmc.fcs.common.enums.CreateBalCycleEnum;

public class BillDimBalanceService {
    private static final int INIT_SIZE = 10;
    private static final Log logger = LogFactory.getLog(BillDimBalanceService.class);
    private BillDimDataDAOService dataDaoService = null;

    public BillDimBalanceService(BillDimDataDAOService dataDaoService) {
        this.dataDaoService = dataDaoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBillBalance(BillDimBalanceParam param) {
        BillDimDataService dimenService = new BillDimDataService(this.dataDaoService);
        DataSet dsBill = dimenService.getBillData(param);
        if (dsBill == null || dsBill.isEmpty()) {
            return;
        }
        DataSet dsAmount = dimenService.getBillAmount(param, dsBill.copy());
        try {
            this.updateBillBalance(param, dsBill, dsAmount);
        }
        finally {
            this.close(dsBill);
            this.close(dsAmount);
        }
    }

    private void updateBillBalance(BillDimBalanceParam param, DataSet dsBill, DataSet dsAmount) {
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        boolean isRebuild = param.isRebuild();
        String billBalEntity = dimConfig.getBillBalEntity();
        String billIdProp = balanceMapConfig.getBillIdProp();
        String[] fieldNames = dsAmount.getRowMeta().getFieldNames();
        Map<Long, List<Row>> billIdGroupMap = this.getBillIdGroupMap(dsAmount.copy(), billIdProp);
        ArrayList<DynamicObject> saveBillBalances = new ArrayList<DynamicObject>(10);
        Set<Object> deleteBillIds = new HashSet(10);
        Map<Object, Object> dateBillMap = new HashMap(billIdGroupMap.size());
        List<BillDimBalanceInfo> balanceInfoList = this.getBillDimBalanceInfos(billIdGroupMap, param);
        HashMap<Long, DynamicObject> lastBillBalanceMap = new HashMap<Long, DynamicObject>(10);
        if (isRebuild) {
            deleteBillIds = balanceInfoList.stream().map(BillDimBalanceInfo::getBillId).collect(Collectors.toSet());
            deleteBillIds.addAll(this.getDeleteBalanceBillIds(param, billIdGroupMap.keySet()));
        } else {
            dateBillMap = balanceInfoList.stream().collect(Collectors.groupingBy(BillDimBalanceInfo::getBeginDate, Collectors.mapping(BillDimBalanceInfo::getBillId, Collectors.toSet())));
            for (Map.Entry<Object, Object> entry : dateBillMap.entrySet()) {
                lastBillBalanceMap.putAll(this.getLastDateBillBalance(dimConfig, (Set)entry.getValue(), (Date)entry.getKey()));
            }
        }
        for (BillDimBalanceInfo balanceInfo : balanceInfoList) {
            Long billId = balanceInfo.getBillId();
            DynamicObject lastBillBalance = !isRebuild ? (DynamicObject)lastBillBalanceMap.get(billId) : null;
            List<DynamicObject> billBalances = this.getBillBalances(billBalEntity, fieldNames, balanceInfo.getRows(), balanceMapConfig);
            String createBalCycle = dimConfig.getCreateBalCycle();
            if (CreateBalCycleEnum.isAmount((String)createBalCycle)) {
                this.updateDayBillBalance(billBalances, lastBillBalance, balanceMapConfig);
            } else {
                billBalances = this.addBillDayBalance(dimConfig, billBalances, lastBillBalance, balanceInfo);
            }
            saveBillBalances.addAll(billBalances);
        }
        if (!isRebuild) {
            List<DynamicObject> billBalances = this.addNoAmountBillBalance(param, dsBill.copy(), billIdGroupMap.keySet(), dateBillMap);
            saveBillBalances.addAll(billBalances);
        }
        if (!EmptyUtil.isEmpty(saveBillBalances)) {
            this.saveBillBalances(param, saveBillBalances, deleteBillIds);
        }
    }

    private void saveBillBalances(BillDimBalanceParam param, List<DynamicObject> saveBillBalances, Set<Long> deleteBillIds) {
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        String billIdProp = balanceMapConfig.getBillIdProp();
        String bizDateProp = balanceMapConfig.getBizDateProp();
        String currencyProp = balanceMapConfig.getCurrencyProp();
        ArrayList<DynamicObject> updateBalances = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> addBalances = new ArrayList<DynamicObject>(10);
        Set<Long> billIdSet = saveBillBalances.stream().map(b -> b.getLong(billIdProp)).collect(Collectors.toSet());
        DynamicObject minDateBalance = saveBillBalances.stream().min(Comparator.comparing(b -> b.getDate(bizDateProp))).get();
        Date currentDate = DateUtils.getCurrentDate();
        Date endDate = param.getEndDate() != null ? param.getEndDate() : currentDate;
        List<DynamicObject> billBalances = this.dataDaoService.loadBillBalances(dimConfig, billIdSet, minDateBalance.getDate(bizDateProp), endDate);
        Map<String, DynamicObject> balanceMap = billBalances.stream().collect(Collectors.toMap(b -> this.getBalanceKey((DynamicObject)b, billIdProp, currencyProp, bizDateProp), b -> b, (b1, b2) -> b1));
        HashSet<String> notUpdateProps = new HashSet<String>(Arrays.asList(billIdProp, currencyProp, bizDateProp, balanceMapConfig.getOrgProp()));
        List<String> updateProps = balanceMapConfig.getAllQueryProps().stream().filter(p -> !notUpdateProps.contains(p)).collect(Collectors.toList());
        DynamicObject billBalanceInfo = saveBillBalances.get(0);
        for (int i = updateProps.size() - 1; i >= 0; --i) {
            if (billBalanceInfo.containsProperty((String)updateProps.get(i))) continue;
            updateProps.remove(i);
        }
        for (DynamicObject saveBillBalance : saveBillBalances) {
            this.setEndBizDate(balanceMapConfig, saveBillBalance, currentDate);
            String balanceKey = this.getBalanceKey(saveBillBalance, billIdProp, currencyProp, bizDateProp);
            DynamicObject billBalance = balanceMap.get(balanceKey);
            if (billBalance != null) {
                updateProps.forEach(p -> billBalance.set(p, saveBillBalance.get(p)));
                updateBalances.add(billBalance);
                continue;
            }
            addBalances.add(saveBillBalance);
            balanceMap.put(balanceKey, saveBillBalance);
        }
        if (EmptyUtil.isNoEmpty(deleteBillIds)) {
            deleteBillIds.removeAll(updateBalances.stream().map(b -> this.getBillId((DynamicObject)b, billIdProp)).collect(Collectors.toSet()));
            this.deleteBillBalance(param, deleteBillIds);
        }
        if (!addBalances.isEmpty()) {
            this.dataDaoService.saveBillBalance(addBalances);
        }
        if (!updateBalances.isEmpty()) {
            this.dataDaoService.updateBillBalance(updateBalances);
        }
    }

    private void setEndBizDate(BalanceMapConfig balanceMapConfig, DynamicObject saveBillBalance, Date currentDate) {
        String endDateProp = balanceMapConfig.getEndDateProp();
        if (EmptyUtil.isNoEmpty((String)endDateProp)) {
            Date bizDate = saveBillBalance.getDate(balanceMapConfig.getBizDateProp());
            Date bizEndDate = bizDate.compareTo(currentDate) >= 0 ? DateUtils.getAppointDay((int)9999, (int)12, (int)31) : DateUtils.getNextDay((Date)bizDate, (int)1);
            saveBillBalance.set(endDateProp, (Object)bizEndDate);
        }
    }

    private String getBalanceKey(DynamicObject balance, String billIdProp, String currencyProp, String bizDateProp) {
        long billId = this.getBillId(balance, billIdProp);
        long currencyId = this.getBillId(balance, currencyProp);
        return billId + "_" + currencyId + "_" + DateUtils.formatString((Date)balance.getDate(bizDateProp), (String)"yyyyMMdd");
    }

    private long getBillId(DynamicObject balance, String billIdProp) {
        Object bill = balance.get(billIdProp);
        if (bill == null) {
            return 0L;
        }
        return bill instanceof DynamicObject ? ((DynamicObject)bill).getLong("id") : ((Long)bill).longValue();
    }

    private List<DynamicObject> addNoAmountBillBalance(BillDimBalanceParam param, DataSet dsBill, Set<Long> amountBillIdSet, Map<Date, Set<Long>> dateBillMap) {
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        BalanceMapConfig billBalConfig = dimConfig.getBillBalConfig();
        String billIdProp = billBalConfig.getBillIdProp();
        HashSet<Long> billIdSet = new HashSet<Long>(10);
        dsBill.forEach(d -> billIdSet.add(d.getLong(billIdProp)));
        billIdSet.removeAll(amountBillIdSet);
        ArrayList<DynamicObject> billBalanceList = new ArrayList<DynamicObject>(10);
        if (!billIdSet.isEmpty()) {
            Date currentDate = DateUtils.getCurrentDate();
            Date beginDate = param.getBeginDate() == null ? currentDate : param.getBeginDate();
            Date endDate = param.getEndDate() == null ? currentDate : param.getEndDate();
            endDate = DateUtils.getNextDay((Date)endDate, (int)1);
            boolean calcFreezeBalance = billBalConfig.isCalcFreezeBalance();
            Map<Long, DynamicObject> lastBillBalancMap = this.getLastDateBillBalance(dimConfig, billIdSet, beginDate);
            for (Map.Entry<Long, DynamicObject> entry : lastBillBalancMap.entrySet()) {
                TreeMap<Date, DynamicObject> balanceObjMap = new TreeMap<Date, DynamicObject>();
                DynamicObject billBalance = entry.getValue();
                BigDecimal lstFreezeBalance = calcFreezeBalance ? billBalance.getBigDecimal(billBalConfig.getFreezeBalanceProp()) : BigDecimal.ZERO;
                Date lastBizDate = billBalance.getDate(billBalConfig.getBizDateProp());
                Date startDate = DateUtils.truncateDate((Date)DateUtils.getNextDay((Date)lastBizDate, (int)1));
                this.addBillBalanceByDate(dimConfig, startDate, endDate, billBalance.getBigDecimal(billBalConfig.getAmountProp()), lstFreezeBalance, balanceObjMap, billBalance);
                billBalanceList.addAll(balanceObjMap.values());
                Set idSet = dateBillMap.computeIfAbsent(startDate, d -> new HashSet(10));
                idSet.add(entry.getKey());
            }
        }
        return billBalanceList;
    }

    private Map<Long, List<Row>> getBillIdGroupMap(DataSet dataSet, String billIdProp) {
        HashMap<Long, List<Row>> billAmountMap = new HashMap<Long, List<Row>>(10);
        for (Row row : dataSet) {
            List rows = billAmountMap.computeIfAbsent(row.getLong(billIdProp), o -> new ArrayList(10));
            rows.add(row);
        }
        return billAmountMap;
    }

    private Set<Long> getDeleteBalanceBillIds(BillDimBalanceParam param, Set<Long> billIdSet) {
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        HashSet<Long> deleteBillIds = new HashSet<Long>(10);
        if (EmptyUtil.isNoEmpty(param.getBillIds()) || dimConfig.isInnerAccountBalance()) {
            return deleteBillIds;
        }
        String billIdProp = dimConfig.getBillBalConfig().getBillIdProp();
        DataSet dsBalance = this.dataDaoService.queryBillDataSet(dimConfig.getBillBalEntity(), billIdProp, null).distinct();
        HashSet<Long> balBillIdSet = new HashSet<Long>(10);
        dsBalance.forEach(d -> balBillIdSet.add(d.getLong(billIdProp)));
        balBillIdSet.removeAll(billIdSet);
        return balBillIdSet;
    }

    private void deleteBillBalance(BillDimBalanceParam param, Set<Long> deleteBillIds) {
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        String billBalEntity = dimConfig.getBillBalEntity();
        String billIdProp = balanceMapConfig.getBillIdProp();
        if (!EmptyUtil.isEmpty(deleteBillIds)) {
            this.dataDaoService.deleteBillBalance(billBalEntity, deleteBillIds, billIdProp);
        }
    }

    private List<BillDimBalanceInfo> getBillDimBalanceInfos(Map<Long, List<Row>> billIdGroupMap, BillDimBalanceParam param) {
        BalanceMapConfig balanceMapConfig = param.getDimConfig().getBillBalConfig();
        String billIdProp = balanceMapConfig.getBillIdProp();
        String bizDateProp = balanceMapConfig.getBizDateProp();
        ArrayList<BillDimBalanceInfo> balanceInfoList = new ArrayList<BillDimBalanceInfo>(billIdGroupMap.size());
        for (Map.Entry<Long, List<Row>> entry : billIdGroupMap.entrySet()) {
            List<Row> rows = entry.getValue();
            rows.sort(Comparator.comparing(r -> r.getDate(bizDateProp)));
            Row firstRow = rows.get(0);
            Row lastRow = rows.get(rows.size() - 1);
            Date beginDate = this.getBeginDate(param, firstRow);
            Date endDate = this.getEndDate(param, lastRow);
            Long billId = firstRow.getLong(billIdProp);
            balanceInfoList.add(BillDimBalanceInfo.build(billId, beginDate, endDate, rows));
        }
        return balanceInfoList;
    }

    private void updateDayBillBalance(List<DynamicObject> billBalances, DynamicObject lastBillBalance, BalanceMapConfig balanceMapConfig) {
        BigDecimal lstBalance = lastBillBalance != null ? lastBillBalance.getBigDecimal(balanceMapConfig.getAmountProp()) : BigDecimal.ZERO;
        BigDecimal lstValidBalance = lastBillBalance != null ? lastBillBalance.getBigDecimal(balanceMapConfig.getValiBalanceProp()) : lstBalance;
        BigDecimal lstFreezeBalance = lstBalance.subtract(lstValidBalance);
        int size = billBalances.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject billBalanceObj = billBalances.get(i);
            BigDecimal creditAmount = billBalanceObj.getBigDecimal(balanceMapConfig.getCreditAmountProp());
            BigDecimal debitAmount = billBalanceObj.getBigDecimal(balanceMapConfig.getDebitAmountProp());
            billBalanceObj.set(balanceMapConfig.getLstBalanceProp(), (Object)lstBalance);
            billBalanceObj.set(balanceMapConfig.getAmountProp(), (Object)lstBalance.add(creditAmount).subtract(debitAmount));
            lstBalance = billBalanceObj.getBigDecimal(balanceMapConfig.getAmountProp());
            lstFreezeBalance = this.updateFreezeBalance(lstBalance, lstFreezeBalance, billBalanceObj, balanceMapConfig);
        }
    }

    public void updateBillBalanceByBillDimConfig(List<Long> configIds, Set<Object> billIds, Date beginDate, Date endDate, boolean isThrowException) {
        List<DynamicObject> dimConfigObjs = this.dataDaoService.queryBillDimConfig(configIds);
        if (dimConfigObjs.isEmpty()) {
            return;
        }
        for (DynamicObject dimConfigObj : dimConfigObjs) {
            BillDimBalanceConfig dimConfig = BillDimBalanceHelper.getBillDimBalanceConfig(dimConfigObj);
            BillDimBalanceParam param = BillDimBalanceParam.build(beginDate, endDate, dimConfig).setBillIds(billIds);
            logger.info("start updateBillBalance: {}", (Object)SerializationUtils.toJsonString((Object)param));
            try {
                this.updateBillBalance(param);
                dimConfigObj.set("lastbaltime", (Object)new Date());
                this.dataDaoService.saveBillBalance(Collections.singletonList(dimConfigObj));
            }
            catch (Exception e) {
                logger.error(String.format("updateBillBalance error, param: %s", SerializationUtils.toJsonString((Object)param)), (Throwable)e);
                if (!isThrowException) continue;
                throw e;
            }
        }
    }

    private void close(DataSet dsData) {
        if (dsData != null) {
            dsData.close();
        }
    }

    private Date getMinDate(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return date1.compareTo(date2) < 0 ? date1 : date2;
        }
        return date1 != null ? date1 : date2;
    }

    private Date getMaxDate(Date date1, Date date2) {
        if (date1 != null && date2 != null) {
            return date1.compareTo(date2) < 0 ? date2 : date1;
        }
        return date1 != null ? date1 : date2;
    }

    private Date getBeginDate(BillDimBalanceParam param, Row firstRow) {
        Object bizDate;
        BillDimBalanceConfig dimenInfo = param.getDimConfig();
        Date beginDate = param.getBeginDate();
        if (EmptyUtil.isNoEmpty((String)dimenInfo.getStartDateProp())) {
            beginDate = this.getMaxDate(beginDate, firstRow.getDate("startdate"));
        }
        return EmptyUtil.isNoEmpty((Object)(bizDate = firstRow.get(dimenInfo.getBillBalConfig().getBizDateProp()))) ? this.getMinDate(beginDate, (Date)bizDate) : beginDate;
    }

    private Date getEndDate(BillDimBalanceParam param, Row row) {
        Object bizDate;
        BillDimBalanceConfig dimenInfo = param.getDimConfig();
        Date endDate = param.getEndDate();
        if (EmptyUtil.isNoEmpty((String)dimenInfo.getEndDateProp())) {
            endDate = this.getMinDate(endDate, row.getDate("enddate"));
        }
        if (endDate == null) {
            endDate = DateUtils.getCurrentDate();
        }
        return EmptyUtil.isNoEmpty((Object)(bizDate = row.get(dimenInfo.getBillBalConfig().getBizDateProp()))) ? this.getMaxDate(endDate, (Date)bizDate) : endDate;
    }

    private List<DynamicObject> addBillDayBalance(BillDimBalanceConfig dimConfig, List<DynamicObject> billBalanceObjs, DynamicObject lastBillBalance, BillDimBalanceInfo balanceInfo) {
        BigDecimal lstValidBalance;
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        String amountProp = balanceMapConfig.getAmountProp();
        String balDebitAmountProp = balanceMapConfig.getDebitAmountProp();
        String balCreditAmountProp = balanceMapConfig.getCreditAmountProp();
        String balBizDateProp = balanceMapConfig.getBizDateProp();
        String valiBalanceProp = balanceMapConfig.getValiBalanceProp();
        String lstBalanceProp = balanceMapConfig.getLstBalanceProp();
        BigDecimal lstBalance = lastBillBalance != null ? lastBillBalance.getBigDecimal(amountProp) : BigDecimal.ZERO;
        BigDecimal bigDecimal = lstValidBalance = lastBillBalance != null ? lastBillBalance.getBigDecimal(valiBalanceProp) : lstBalance;
        BigDecimal lstFreezeBalance = balanceMapConfig.isCalcFreezeBalance() ? (lastBillBalance != null ? lastBillBalance.getBigDecimal(balanceMapConfig.getFreezeBalanceProp()) : BigDecimal.ZERO) : lstBalance.subtract(lstValidBalance);
        Date beginDate = balanceInfo.getBeginDate();
        Date endDate = balanceInfo.getEndDate();
        TreeMap<Date, DynamicObject> balanceObjMap = new TreeMap<Date, DynamicObject>();
        Date lastBizDate = null;
        if (lastBillBalance != null) {
            lastBizDate = lastBillBalance.getDate(balBizDateProp);
            balanceObjMap.put(lastBizDate, lastBillBalance);
        }
        int size = billBalanceObjs.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject billBalanceObj = billBalanceObjs.get(i);
            Date bizDate = billBalanceObj.getDate(balBizDateProp);
            if (i == 0 && beginDate != null && beginDate.before(bizDate)) {
                this.addBillBalanceByDate(dimConfig, beginDate, bizDate, lstBalance, lstFreezeBalance, balanceObjMap, billBalanceObj);
            }
            BigDecimal creditAmount = billBalanceObj.getBigDecimal(balCreditAmountProp);
            BigDecimal debitAmount = billBalanceObj.getBigDecimal(balDebitAmountProp);
            billBalanceObj.set(lstBalanceProp, (Object)lstBalance);
            billBalanceObj.set(amountProp, (Object)lstBalance.add(creditAmount).subtract(debitAmount));
            if (i > 0) {
                DynamicObject lstBillBalance = billBalanceObjs.get(i - 1);
                lstBalance = lstBillBalance.getBigDecimal(amountProp);
                Date lstBizDate = DateUtils.getNextDay((Date)lstBillBalance.getDate(balBizDateProp), (int)1);
                this.addBillBalanceByDate(dimConfig, lstBizDate, bizDate, lstBalance, lstFreezeBalance, balanceObjMap, billBalanceObj);
            }
            lstBalance = billBalanceObj.getBigDecimal(amountProp);
            lstFreezeBalance = this.updateFreezeBalance(lstBalance, lstFreezeBalance, billBalanceObj, balanceMapConfig);
            if (!EmptyUtil.isNoEmpty((BigDecimal)creditAmount) && !EmptyUtil.isNoEmpty((BigDecimal)debitAmount) && !EmptyUtil.isNoEmpty((BigDecimal)lstFreezeBalance) && !EmptyUtil.isNoEmpty((BigDecimal)lstBalance)) continue;
            balanceObjMap.put(bizDate, billBalanceObj);
        }
        DynamicObject lastBalanceObj = billBalanceObjs.get(billBalanceObjs.size() - 1);
        lstBalance = lastBalanceObj.getBigDecimal(amountProp);
        Date lstBizDate = DateUtils.getNextDay((Date)lastBalanceObj.getDate(balBizDateProp), (int)1);
        Date nextDay = DateUtils.getNextDay((Date)endDate, (int)1);
        this.addBillBalanceByDate(dimConfig, lstBizDate, nextDay, lstBalance, lstFreezeBalance, balanceObjMap, lastBalanceObj);
        if (lastBizDate != null) {
            balanceObjMap.remove(lastBizDate);
        }
        return new ArrayList<DynamicObject>(balanceObjMap.values());
    }

    private BigDecimal updateFreezeBalance(BigDecimal lstBalance, BigDecimal lstFreezeBalance, DynamicObject billBalanceObj, BalanceMapConfig balanceMapConfig) {
        if (billBalanceObj.containsProperty(balanceMapConfig.getFreezeBalanceProp())) {
            BigDecimal freezeBalance = billBalanceObj.getBigDecimal(balanceMapConfig.getFreezeBalanceProp());
            if (freezeBalance != null && freezeBalance.compareTo(BigDecimal.ZERO) != 0) {
                lstFreezeBalance = lstFreezeBalance.add(freezeBalance);
            }
            billBalanceObj.set(balanceMapConfig.getFreezeBalanceProp(), (Object)lstFreezeBalance);
            BigDecimal validBalance = lstBalance.subtract(lstFreezeBalance);
            billBalanceObj.set(balanceMapConfig.getValiBalanceProp(), (Object)this.getValidBalance(validBalance, lstFreezeBalance));
        } else {
            billBalanceObj.set(balanceMapConfig.getValiBalanceProp(), (Object)lstBalance);
        }
        return lstFreezeBalance;
    }

    private BigDecimal getValidBalance(BigDecimal validBalance, BigDecimal freezeBalance) {
        return freezeBalance.compareTo(BillDimDataService.CHECK_FREEZE_AMOUNT) >= 0 ? BigDecimal.ZERO : validBalance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, DynamicObject> getLastDateBillBalance(BillDimBalanceConfig dimConfig, Set<Long> billIds, Date beginDate) {
        BalanceMapConfig billBalConfig = dimConfig.getBillBalConfig();
        HashMap<Long, DynamicObject> billBalMap = new HashMap<Long, DynamicObject>(10);
        DataSet dataSet = this.dataDaoService.queryMaxDateBillBalance(dimConfig, new HashSet<Long>(billIds), beginDate);
        if (dataSet == null || dataSet.isEmpty()) {
            return billBalMap;
        }
        boolean calcFreezeBalance = billBalConfig.isCalcFreezeBalance();
        try {
            String billIdProp = billBalConfig.getBillIdProp();
            for (Row firstRow : dataSet) {
                Long billId = firstRow.getLong(billIdProp);
                if (billBalMap.containsKey(billId)) continue;
                DynamicObject balanceObj = TmcDataServiceHelper.newDynamicObject((String)dimConfig.getBillBalEntity());
                balanceObj.set(billBalConfig.getBillIdProp(), (Object)billId);
                balanceObj.set(billBalConfig.getOrgProp(), (Object)firstRow.getLong(billBalConfig.getOrgProp()));
                balanceObj.set(billBalConfig.getCurrencyProp(), (Object)firstRow.getLong(billBalConfig.getCurrencyProp()));
                balanceObj.set(billBalConfig.getBizDateProp(), (Object)firstRow.getDate(billBalConfig.getBizDateProp()));
                balanceObj.set(billBalConfig.getAmountProp(), (Object)firstRow.getBigDecimal(billBalConfig.getAmountProp()));
                balanceObj.set(billBalConfig.getValiBalanceProp(), (Object)firstRow.getBigDecimal(billBalConfig.getValiBalanceProp()));
                if (calcFreezeBalance) {
                    balanceObj.set(billBalConfig.getFreezeBalanceProp(), (Object)firstRow.getBigDecimal(billBalConfig.getFreezeBalanceProp()));
                }
                billBalMap.put(billId, balanceObj);
            }
        }
        finally {
            this.close(dataSet);
        }
        return billBalMap;
    }

    private void addBillBalanceByDate(BillDimBalanceConfig dimConfig, Date beginDate, Date endDate, BigDecimal lstBalance, BigDecimal lstFreezeBalance, TreeMap<Date, DynamicObject> balanceObjMap, DynamicObject billBalanceObj) {
        String entityName = billBalanceObj.getDataEntityType().getName();
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        CreateBalCycleEnum createBalCycleEnum = CreateBalCycleEnum.getEnum((String)dimConfig.getCreateBalCycle());
        Date startDate = beginDate;
        block8: while (startDate.before(endDate)) {
            switch (createBalCycleEnum) {
                case WEEK: {
                    Date firstDayOfWeek = DateUtils.getFirstDayOfWeek((Date)startDate);
                    if (!balanceObjMap.containsKey(firstDayOfWeek)) {
                        startDate = firstDayOfWeek;
                    } else {
                        Date endDayOfWeek = DateUtils.getNextDay((Date)firstDayOfWeek, (int)6);
                        if (!balanceObjMap.subMap(firstDayOfWeek, endDayOfWeek).isEmpty()) {
                            startDate = DateUtils.getNextWeek((Date)firstDayOfWeek, (int)1);
                            continue block8;
                        }
                    }
                    if (startDate.compareTo(beginDate) >= 0) break;
                    startDate = DateUtils.getNextWeek((Date)firstDayOfWeek, (int)1);
                    break;
                }
                case MONTH: {
                    Date firstDayOfMonth = DateUtils.getFirstDayOfMonth((Date)startDate);
                    if (!balanceObjMap.containsKey(firstDayOfMonth)) {
                        startDate = firstDayOfMonth;
                    } else {
                        Date date = DateUtils.getLastDayOfMonth((Date)firstDayOfMonth);
                        if (!balanceObjMap.subMap(firstDayOfMonth, date).isEmpty()) {
                            startDate = DateUtils.getNextMonth((Date)firstDayOfMonth, (int)1);
                            continue block8;
                        }
                    }
                    if (startDate.compareTo(beginDate) >= 0) break;
                    startDate = DateUtils.getNextMonth((Date)firstDayOfMonth, (int)1);
                    break;
                }
            }
            if (startDate.compareTo(endDate) >= 0) {
                return;
            }
            DynamicObject addBalanceObj = TmcDataServiceHelper.newDynamicObject((String)entityName);
            for (Map.Entry entry : balanceMapConfig.getDimenProps().entrySet()) {
                addBalanceObj.set((String)entry.getValue(), billBalanceObj.get((String)entry.getKey()));
            }
            addBalanceObj.set(balanceMapConfig.getBillIdProp(), billBalanceObj.get(balanceMapConfig.getBillIdProp()));
            addBalanceObj.set(balanceMapConfig.getOrgProp(), billBalanceObj.get(balanceMapConfig.getOrgProp()));
            addBalanceObj.set(balanceMapConfig.getCurrencyProp(), billBalanceObj.get(balanceMapConfig.getCurrencyProp()));
            addBalanceObj.set(balanceMapConfig.getBizDateProp(), (Object)startDate);
            addBalanceObj.set(balanceMapConfig.getLstBalanceProp(), (Object)lstBalance);
            addBalanceObj.set(balanceMapConfig.getAmountProp(), (Object)lstBalance);
            BigDecimal validBalance = this.getValidBalance(lstBalance.subtract(lstFreezeBalance), lstFreezeBalance);
            addBalanceObj.set(balanceMapConfig.getValiBalanceProp(), (Object)validBalance);
            addBalanceObj.set(balanceMapConfig.getDebitAmountProp(), (Object)BigDecimal.ZERO);
            addBalanceObj.set(balanceMapConfig.getCreditAmountProp(), (Object)BigDecimal.ZERO);
            String string = balanceMapConfig.getFreezeBalanceProp();
            if (addBalanceObj.containsProperty(string)) {
                addBalanceObj.set(string, (Object)lstFreezeBalance);
            }
            if (addBalanceObj.containsProperty("keycol")) {
                addBalanceObj.set("keycol", (Object)BillDimBalanceHelper.genKeyCol(addBalanceObj, balanceMapConfig));
            }
            if (EmptyUtil.isNoEmpty((BigDecimal)lstBalance) || EmptyUtil.isNoEmpty((BigDecimal)validBalance) || EmptyUtil.isNoEmpty((BigDecimal)lstFreezeBalance)) {
                balanceObjMap.put(startDate, addBalanceObj);
            }
            switch (createBalCycleEnum) {
                case WEEK: {
                    startDate = DateUtils.getNextDay((Date)startDate, (int)7);
                    continue block8;
                }
                case DAY: {
                    startDate = DateUtils.getNextDay((Date)startDate, (int)1);
                    continue block8;
                }
            }
            startDate = DateUtils.getNextMonth((Date)startDate, (int)1);
        }
    }

    private List<DynamicObject> getBillBalances(String billBalEntity, String[] fieldNames, List<Row> billBalRows, BalanceMapConfig balanceMapConfig) {
        ArrayList<DynamicObject> billBalances = new ArrayList<DynamicObject>(10);
        for (Row row : billBalRows) {
            DynamicObject balanceObj = TmcDataServiceHelper.newDynamicObject((String)billBalEntity);
            BigDecimal freezeCredit = BigDecimal.ZERO;
            BigDecimal freezeDebit = BigDecimal.ZERO;
            String[] stringArray = fieldNames;
            int n = stringArray.length;
            block9: for (int i = 0; i < n; ++i) {
                String fieldName;
                switch (fieldName = stringArray[i]) {
                    case "freezecreditamount": {
                        freezeCredit = row.getBigDecimal(fieldName);
                        continue block9;
                    }
                    case "freezedebitamount": {
                        freezeDebit = row.getBigDecimal(fieldName);
                        continue block9;
                    }
                    default: {
                        if (!balanceObj.containsProperty(fieldName)) continue block9;
                        balanceObj.set(fieldName, row.get(fieldName));
                    }
                }
            }
            if (balanceObj.containsProperty(balanceMapConfig.getFreezeBalanceProp())) {
                balanceObj.set(balanceMapConfig.getFreezeBalanceProp(), (Object)freezeCredit.subtract(freezeDebit));
            }
            if (balanceObj.containsProperty("keycol")) {
                balanceObj.set("keycol", (Object)BillDimBalanceHelper.genKeyCol(balanceObj, balanceMapConfig));
            }
            billBalances.add(balanceObj);
        }
        return billBalances;
    }
}

