/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billbalance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.ListUtils;
import kd.tmc.fcs.business.opservice.billbalance.BillDimDataDAOService;
import kd.tmc.fcs.business.opservice.billbalance.config.BalanceMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BillDimBalanceConfig;

public class BillDimDataDAOServiceImpl
implements BillDimDataDAOService {
    private static final int SPLIT_SIZE = 1000;

    @Override
    public DataSet queryBillDataSet(String billEntity, String selectFields, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)String.format("queryBillDataSet_%s", billEntity), (String)billEntity, (String)selectFields, (QFilter[])(filter != null ? filter.toArray() : null), null);
    }

    @Override
    public DataSet queryBillAmountDataSet(String billEntity, String selectFields, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)String.format("queryBillAmountDataSet_%s", billEntity), (String)billEntity, (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    @Override
    public DataSet queryBillInitAmountDataSet(String billEntity, String selectFields, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)String.format("queryBillInitAmountDataSet_%s", billEntity), (String)billEntity, (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet queryMaxDateBillBalance(BillDimBalanceConfig dimConfig, Set<Long> billIds, Date beginDate) {
        BalanceMapConfig billBalConfig = dimConfig.getBillBalConfig();
        String billBalEntity = dimConfig.getBillBalEntity();
        List splitList = ListUtils.splitList(new ArrayList<Long>(billIds), (long)1000L);
        String billIdProp = billBalConfig.getBillIdProp();
        String bizDateProp = billBalConfig.getBizDateProp();
        DataSet dsData = null;
        for (List billIdList : splitList) {
            QFilter qFilter = new QFilter(bizDateProp, "<", (Object)beginDate).and(billIdProp, "in", (Object)billIdList);
            List<String> queryProps = billBalConfig.getQueryProps();
            String selectProps = String.join((CharSequence)",", queryProps);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryMaxDateBillBalance", (String)billBalEntity, (String)selectProps, (QFilter[])qFilter.toArray(), null);
            DataSet dsGroupByBillId = null;
            try {
                dsGroupByBillId = dataSet.groupBy(new String[]{billIdProp}).max(bizDateProp).finish();
                DataSet dsMaxDate = dataSet.join(dsGroupByBillId).on(billIdProp, billIdProp).on(bizDateProp, bizDateProp).select(queryProps.toArray(new String[0]), new String[0]).finish();
                dsData = dsData != null ? dsData.union(dsMaxDate) : dsMaxDate;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((AutoCloseable)dataSet);
                IOUtils.closeQuietly(dsGroupByBillId);
                throw throwable;
            }
            IOUtils.closeQuietly((AutoCloseable)dataSet);
            IOUtils.closeQuietly((AutoCloseable)dsGroupByBillId);
        }
        return dsData;
    }

    @Override
    public boolean deleteBillBalance(String billBalEntity, Set<Long> billIds, Date beginDate, String billIdProp, String bizDateProp) {
        List splitList = ListUtils.splitList(new ArrayList<Long>(billIds), (long)1000L);
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            for (List ids : splitList) {
                QFilter qFilter = new QFilter(billIdProp, "in", (Object)ids).and(bizDateProp, ">=", (Object)beginDate);
                DeleteServiceHelper.delete((String)billBalEntity, (QFilter[])qFilter.toArray());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean deleteBillBalance(String billBalEntity, Set<Long> billIds, String billIdProp) {
        if (EmptyUtil.isEmpty(billIds)) {
            return false;
        }
        List splitList = ListUtils.splitList(new ArrayList<Long>(billIds), (long)1000L);
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            for (List ids : splitList) {
                DeleteServiceHelper.delete((String)billBalEntity, (QFilter[])new QFilter(billIdProp, "in", (Object)ids).toArray());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean saveBillBalance(List<DynamicObject> billBalances) {
        List splitList = ListUtils.splitList(billBalances, (long)1000L);
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            for (List bills : splitList) {
                SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[0]));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public boolean updateBillBalance(List<DynamicObject> billBalances) {
        List splitList = ListUtils.splitList(billBalances, (long)1000L);
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            for (List bills : splitList) {
                SaveServiceHelper.update((DynamicObject[])bills.toArray(new DynamicObject[0]));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            try {
                handle.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    public DataSet queryBillFreezeDataSet(String billEntity, String selectFields, QFilter filter) {
        return QueryServiceHelper.queryDataSet((String)String.format("queryBillFreezeDataSet_%s", billEntity), (String)billEntity, (String)selectFields, (QFilter[])filter.toArray(), null);
    }

    @Override
    public List<DynamicObject> queryBillDimConfig(List<Long> configIds) {
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and("billstatus", "=", (Object)"C");
        if (EmptyUtil.isNoEmpty(configIds)) {
            qFilter.and("id", "in", configIds);
        }
        Map billDimMap = BusinessDataServiceHelper.loadFromCache((String)"fcs_billdimbalance", (QFilter[])qFilter.toArray());
        return new ArrayList<DynamicObject>(billDimMap.values());
    }

    @Override
    public List<DynamicObject> loadBillBalances(BillDimBalanceConfig dimConfig, Set<Long> billIds, Date beginDate, Date endDate) {
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        List splitList = ListUtils.splitList(new ArrayList<Long>(billIds), (long)1000L);
        ArrayList<DynamicObject> balanceList = new ArrayList<DynamicObject>(10);
        String selectProperties = String.join((CharSequence)",", balanceMapConfig.getAllQueryProps());
        if (dimConfig.containProp("modifytime")) {
            selectProperties = selectProperties + ",modifytime";
        }
        for (List billIdList : splitList) {
            QFilter qFilter = new QFilter(balanceMapConfig.getBizDateProp(), ">=", (Object)beginDate);
            qFilter.and(balanceMapConfig.getBillIdProp(), "in", (Object)billIdList);
            DynamicObject[] balances = BusinessDataServiceHelper.load((String)dimConfig.getBillBalEntity(), (String)selectProperties, (QFilter[])qFilter.toArray());
            if (balances.length <= 0) continue;
            balanceList.addAll(Arrays.asList(balances));
        }
        return balanceList;
    }
}

