/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.EntityPropInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.business.opservice.billbalance.BillDimBalanceParam;
import kd.tmc.fcs.business.opservice.billbalance.BillDimDataDAOService;
import kd.tmc.fcs.business.opservice.billbalance.config.AmountMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BalanceMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BillDimBalanceConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.FreezeMapConfig;
import kd.tmc.fcs.common.enums.BillFrozenTypeEnum;
import kd.tmc.fcs.common.enums.LoanSignEnum;

public class BillDimDataService {
    public static final String MAX_FREEZE_AMOUNT = "999999999999.99";
    public static final BigDecimal CHECK_FREEZE_AMOUNT = new BigDecimal("999999999999.99");
    private BillDimDataDAOService operateService = null;

    public BillDimDataService(BillDimDataDAOService operateService) {
        this.operateService = operateService;
    }

    public DataSet getBillData(BillDimBalanceParam param) {
        String endDateProp;
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        String billEntity = dimConfig.getBillEntity();
        EntityPropInfo dimenProp = this.getSelectProps(dimConfig);
        QFilter condition = dimConfig.getCondition();
        if (condition == null) {
            condition = new QFilter("1", "=", (Object)1);
        }
        if (EmptyUtil.isNoEmpty(param.getBillIds())) {
            condition.and(dimConfig.getBillIdProp(), "in", param.getBillIds());
        }
        if (EmptyUtil.isNoEmpty((String)(endDateProp = dimConfig.getEndDateProp())) && (beginDate != null || endDate != null)) {
            QFilter filter = QFilter.isNull((String)endDateProp);
            if (beginDate != null) {
                filter.or(endDateProp, ">=", (Object)beginDate);
            } else if (endDate != null) {
                filter.or(endDateProp, ">=", (Object)endDate);
            }
            condition.and(filter);
        }
        return this.operateService.queryBillDataSet(billEntity, dimenProp.getQueryProps(), condition);
    }

    public DataSet getBillAmount(BillDimBalanceParam param, DataSet dsBill) {
        DataSet dsFreeze;
        if (dsBill == null || dsBill.isEmpty()) {
            return dsBill;
        }
        BillDimBalanceConfig dimConfig = param.getDimConfig();
        Date beginDate = param.getBeginDate();
        Date endDate = param.getEndDate();
        EntityPropInfo dimenProp = this.getSelectProps(dimConfig);
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        if (dimConfig.isInnerAccountBalance() && dimConfig.containProp("enddate")) {
            balanceMapConfig.setEndDateProp("enddate");
        }
        String balBillIdProp = balanceMapConfig.getBillIdProp();
        String balBizDateProp = balanceMapConfig.getBizDateProp();
        ArrayList<String> amountProps = new ArrayList<String>(Arrays.asList(balanceMapConfig.getDebitAmountProp(), balanceMapConfig.getCreditAmountProp()));
        DataSet dsBillAmount = this.getAmountDataSet(dsBill, dimConfig.getAmountEntry(), balanceMapConfig, beginDate, endDate, Boolean.FALSE);
        DataSet dsInitData = this.getAmountDataSet(dsBill, dimConfig.getInitAmountEntry(), balanceMapConfig, beginDate, endDate, Boolean.TRUE);
        if (dsInitData != null) {
            DataSet dataSet = dsBillAmount = dsBillAmount != null ? dsBillAmount.union(dsInitData) : dsInitData;
        }
        if ((dsFreeze = this.getFreezeAmountDataSet(dsBill, dimConfig.getFreezeEntry(), balanceMapConfig, beginDate, endDate)) != null && !dsFreeze.isEmpty()) {
            dsBillAmount = this.getFreezeBillAmount(amountProps, dsBillAmount, dsFreeze);
        }
        if (dsBillAmount == null || dsBillAmount.isEmpty()) {
            return this.getEmptyBillDataSet(dsBill, balBizDateProp, beginDate, amountProps);
        }
        GroupbyDataSet dsGroupBillAmount = dsBillAmount.groupBy(new String[]{balBillIdProp, balBizDateProp});
        for (String amountProp : amountProps) {
            dsGroupBillAmount = dsGroupBillAmount.sum(amountProp);
        }
        dsBillAmount = dsGroupBillAmount.finish();
        Set<String> props = dimenProp.getProps().stream().map(EntityPropInfo::getName).collect(Collectors.toSet());
        props.remove(balBillIdProp);
        ArrayList<String> selectProps = new ArrayList<String>(Arrays.asList(balBillIdProp, balBizDateProp));
        selectProps.addAll(amountProps);
        dsBillAmount = dsBillAmount.join(dsBill).on(balBillIdProp, balBillIdProp).select(selectProps.toArray(new String[0]), props.toArray(new String[0])).finish();
        return dsBillAmount;
    }

    private DataSet getFreezeBillAmount(List<String> amountProps, DataSet dsBillAmount, DataSet dsFreeze) {
        if (dsBillAmount != null) {
            dsBillAmount = dsBillAmount.addField("0", "freezedebitamount");
            dsBillAmount = dsBillAmount.addField("0", "freezecreditamount");
            dsBillAmount = dsBillAmount.union(dsFreeze);
        } else {
            dsBillAmount = dsFreeze;
        }
        amountProps.add("freezedebitamount");
        amountProps.add("freezecreditamount");
        return dsBillAmount;
    }

    private DataSet getEmptyBillDataSet(DataSet dsBill, String balBizDateProp, Date beginDate, List<String> amountProps) {
        Set fieldMap = Arrays.stream(dsBill.getRowMeta().getFieldNames()).collect(Collectors.toSet());
        for (String amountProp : amountProps) {
            if (fieldMap.contains(amountProp)) continue;
            dsBill = dsBill.addField("0", amountProp);
        }
        if (fieldMap.contains(balBizDateProp)) {
            dsBill.removeFields(new String[]{balBizDateProp});
        }
        if (beginDate == null) {
            beginDate = DateUtils.getCurrentDate();
        }
        dsBill = dsBill.addField(String.format("to_date('%s', 'yy-MM-dd')", DateUtils.formatString((Date)beginDate, (String)"yyyy-MM-dd")), balBizDateProp);
        return dsBill;
    }

    private EntityPropInfo getSelectProps(BillDimBalanceConfig dimConfig) {
        BalanceMapConfig balanceMapConfig = dimConfig.getBillBalConfig();
        EntityPropInfo dimenProp = new EntityPropInfo();
        dimenProp.addProp(dimConfig.getBillIdProp(), balanceMapConfig.getBillIdProp()).addProp(dimConfig.getOrgProp(), balanceMapConfig.getOrgProp()).addProp(dimConfig.getCurrencyProp(), balanceMapConfig.getCurrencyProp());
        for (String string : dimConfig.getDimenProps()) {
            dimenProp.addProp(string, string);
        }
        if (EmptyUtil.isNoEmpty((String)dimConfig.getStartDateProp())) {
            dimenProp.addProp(dimConfig.getStartDateProp(), "startdate");
        }
        if (EmptyUtil.isNoEmpty((String)dimConfig.getEndDateProp())) {
            dimenProp.addProp(dimConfig.getEndDateProp(), "enddate");
        }
        for (AmountMapConfig amountMapConfig : dimConfig.getAmountEntry()) {
            if (!EmptyUtil.isNoEmpty((String)amountMapConfig.getDestBillProp())) continue;
            dimenProp.addProp(amountMapConfig.getDestBillProp(), amountMapConfig.getDestBillProp());
        }
        for (FreezeMapConfig freezeMapConfig : dimConfig.getFreezeEntry()) {
            if (!EmptyUtil.isNoEmpty((String)freezeMapConfig.getDestBillProp())) continue;
            dimenProp.addProp(freezeMapConfig.getDestBillProp(), freezeMapConfig.getDestBillProp());
        }
        return dimenProp;
    }

    private DataSet getAmountDataSet(DataSet dsBill, List<AmountMapConfig> amountEntry, BalanceMapConfig balanceMapConfig, Date beginDate, Date endDate, boolean isInit) {
        DataSet dsAmount = null;
        String balBillIdProp = balanceMapConfig.getBillIdProp();
        String balDebitAmountProp = balanceMapConfig.getDebitAmountProp();
        String balCreditAmountProp = balanceMapConfig.getCreditAmountProp();
        String balBizDateProp = balanceMapConfig.getBizDateProp();
        dsBill = dsBill.copy();
        int size = amountEntry.size();
        for (int i = 0; i < size; ++i) {
            String destBillProp;
            AmountMapConfig amountInfo = amountEntry.get(i);
            String billEntity = amountInfo.getBillEntity();
            boolean isCredit = LoanSignEnum.isCredit((String)amountInfo.getLoanSign());
            EntityPropInfo dimenProp = new EntityPropInfo();
            String queryProps = dimenProp.addProp(amountInfo.getSrcBillProp(), balBillIdProp).addProp(amountInfo.getBizDateProp(), balBizDateProp).addProp(isCredit ? "0" : amountInfo.getAmountProp(), balDebitAmountProp).addProp(isCredit ? amountInfo.getAmountProp() : "0", balCreditAmountProp).getQueryProps();
            QFilter condition = amountInfo.getCondition();
            condition = condition == null ? QFilter.isNotNull((String)amountInfo.getBizDateProp()) : condition.and(QFilter.isNotNull((String)amountInfo.getBizDateProp()));
            if (beginDate != null) {
                condition.and(amountInfo.getBizDateProp(), ">=", (Object)beginDate);
            }
            if (endDate != null) {
                condition.and(amountInfo.getBizDateProp(), "<=", (Object)endDate);
            }
            if (EmptyUtil.isNoEmpty((String)(destBillProp = amountInfo.getDestBillProp()))) {
                queryProps = queryProps + "," + destBillProp;
            }
            DataSet dataSet = isInit ? this.operateService.queryBillInitAmountDataSet(billEntity, queryProps, condition) : this.operateService.queryBillAmountDataSet(billEntity, queryProps, condition);
            dataSet = EmptyUtil.isNoEmpty((String)destBillProp) ? dataSet.join(dsBill).on(balBillIdProp, destBillProp).select(new String[]{balBizDateProp, balDebitAmountProp, balCreditAmountProp}, new String[]{balBillIdProp}).finish() : dsBill.join(dataSet).on(balBillIdProp, balBillIdProp).select(new String[]{balBillIdProp}, new String[]{balBizDateProp, balDebitAmountProp, balCreditAmountProp}).finish();
            dsAmount = dsAmount == null ? dataSet : dsAmount.union(dataSet);
        }
        return dsAmount;
    }

    private DataSet getFreezeAmountDataSet(DataSet dsBill, List<FreezeMapConfig> freezeEntry, BalanceMapConfig balanceMapConfig, Date beginDate, Date endDate) {
        if (EmptyUtil.isEmpty(freezeEntry)) {
            return null;
        }
        String balBillIdProp = balanceMapConfig.getBillIdProp();
        String balAmountProp = balanceMapConfig.getAmountProp();
        String balDebitAmountProp = balanceMapConfig.getDebitAmountProp();
        String balCreditAmountProp = balanceMapConfig.getCreditAmountProp();
        String balBizDateProp = balanceMapConfig.getBizDateProp();
        DataSet dsFreeze = null;
        int size = freezeEntry.size();
        for (int i = 0; i < size; ++i) {
            FreezeMapConfig config = freezeEntry.get(i);
            String billEntity = config.getBillEntity();
            EntityPropInfo dimenProp = new EntityPropInfo();
            String queryProps = dimenProp.addProp(config.getSrcBillProp(), balBillIdProp).addProp(config.getBizDateProp(), balBizDateProp).addProp(config.getAmountProp(), balAmountProp).addProp(config.getFreezeTypeProp(), "freezetype").getQueryProps();
            QFilter condition = config.getCondition();
            if (condition == null) {
                condition = new QFilter("1", "=", (Object)1);
            }
            if (beginDate != null) {
                condition.and(config.getBizDateProp(), ">=", (Object)beginDate);
            }
            if (endDate != null) {
                condition.and(config.getBizDateProp(), "<=", (Object)endDate);
            }
            DataSet dataSet = this.operateService.queryBillFreezeDataSet(billEntity, queryProps, condition);
            String destBillProp = config.getDestBillProp();
            if (EmptyUtil.isNoEmpty((String)destBillProp)) {
                dataSet = dataSet.join(dsBill.copy()).on(balBillIdProp, destBillProp).select(new String[]{balBizDateProp, balAmountProp, "freezetype"}, new String[]{balBillIdProp}).finish();
            }
            dsFreeze = dsFreeze == null ? dataSet : dsFreeze.union(dataSet);
        }
        if (dsFreeze == null || dsFreeze.isEmpty()) {
            return dsFreeze;
        }
        dsFreeze = dsFreeze.addField("0", balDebitAmountProp);
        dsFreeze = dsFreeze.addField("0", balCreditAmountProp);
        String creditAmount = String.format("case %1$s when '%2$s' then %3$s when '%4$s' then %5$s else 0 end", "freezetype", BillFrozenTypeEnum.AMOUNT_FROZEN.getValue(), balAmountProp, BillFrozenTypeEnum.ACCOUNT_FROZEN.getValue(), MAX_FREEZE_AMOUNT);
        dsFreeze = dsFreeze.addField(creditAmount, "freezecreditamount");
        String debitAmount = String.format("case %1$s when '%2$s' then %3$s when '%4$s' then %5$s else 0 end", "freezetype", BillFrozenTypeEnum.AMOUNT_THAW.getValue(), balAmountProp, BillFrozenTypeEnum.ACCOUNT_THAW.getValue(), MAX_FREEZE_AMOUNT);
        dsFreeze = dsFreeze.addField(debitAmount, "freezedebitamount");
        dsFreeze = dsFreeze.removeFields(new String[]{balAmountProp});
        dsFreeze = dsFreeze.groupBy(new String[]{balBillIdProp, balBizDateProp}).sum(balDebitAmountProp).sum(balCreditAmountProp).sum("freezedebitamount").sum("freezecreditamount").finish();
        return dsFreeze;
    }
}

