/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billbalance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.business.opservice.billbalance.BillDimBalanceService;
import kd.tmc.fcs.business.opservice.billbalance.BillDimDataDAOServiceImpl;

public class RebuildBalanceService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(8);
        sic.add("billno");
        sic.add("billentity.number");
        sic.add("billbalentity.number");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        Map variable = this.getOperationVariable();
        Date beginDate = this.str2Date((String)variable.get("beginDate"));
        Date endDate = this.str2Date((String)variable.get("endDate"));
        String selBillIds = (String)variable.get("billIds");
        Set<Object> billIds = null;
        if (EmptyUtil.isNoEmpty((String)selBillIds)) {
            billIds = Arrays.stream(selBillIds.split(",")).map(Long::parseLong).collect(Collectors.toSet());
        }
        List<Long> configIds = Arrays.stream(dataEntities).map(d -> d.getLong("id")).collect(Collectors.toList());
        BillDimBalanceService balanceService = new BillDimBalanceService(new BillDimDataDAOServiceImpl());
        balanceService.updateBillBalanceByBillDimConfig(configIds, billIds, beginDate, endDate, true);
    }

    private Date str2Date(String value) {
        return EmptyUtil.isNoEmpty((String)value) ? DateUtils.stringToDate((String)value, (String)"yyyy-MM-dd") : null;
    }
}

