/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billbalance.config;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.business.opservice.billbalance.config.AmountMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.BalanceMapConfig;
import kd.tmc.fcs.business.opservice.billbalance.config.FreezeMapConfig;
import kd.tmc.fcs.common.enums.CreateBalCycleEnum;

public class BillDimBalanceConfig {
    private static final String IFM_ACCOUNTBALANCE = "ifm_accountbalance";
    private String billEntity;
    private String billBalEntity;
    private String billIdProp = "id";
    private String orgProp = "org";
    private String currencyProp = "currency";
    private String startDateProp;
    private String endDateProp;
    private QFilter condition;
    private String createBalCycle = CreateBalCycleEnum.AMOUNT.getValue();
    private List<String> dimenProps = new ArrayList<String>(8);
    private List<AmountMapConfig> amountEntry = new ArrayList<AmountMapConfig>(8);
    private List<AmountMapConfig> initAmountEntry = new ArrayList<AmountMapConfig>(8);
    private List<FreezeMapConfig> freezeEntry = new ArrayList<FreezeMapConfig>(8);
    private final BalanceMapConfig balanceMapConfig = new BalanceMapConfig();

    public static BillDimBalanceConfig build(String billEntity, String billBalEntity, QFilter condition) {
        return new BillDimBalanceConfig().setBillEntity(billEntity).setBillBalEntity(billBalEntity).setCondition(condition);
    }

    public void addAmountEntry(AmountMapConfig amountInfo) {
        this.amountEntry.add(amountInfo);
    }

    public void addInitAmountEntry(AmountMapConfig amountInfo) {
        this.initAmountEntry.add(amountInfo);
    }

    public void addFreezeAmountEntry(FreezeMapConfig freezeInfo) {
        this.freezeEntry.add(freezeInfo);
    }

    public boolean containProp(String propName) {
        return EntityMetadataCache.getDataEntityType((String)this.getBillBalEntity()).getAllFields().containsKey(propName);
    }

    public void addDimenProp(String prop) {
        if (EmptyUtil.isNoEmpty((String)prop)) {
            this.dimenProps.add(prop);
        }
    }

    public boolean isInnerAccountBalance() {
        return IFM_ACCOUNTBALANCE.equalsIgnoreCase(this.billBalEntity);
    }

    public String getBillEntity() {
        return this.billEntity;
    }

    public BillDimBalanceConfig setBillEntity(String billEntity) {
        this.billEntity = billEntity;
        return this;
    }

    public String getBillBalEntity() {
        return this.billBalEntity;
    }

    public BillDimBalanceConfig setBillBalEntity(String billBalEntity) {
        this.billBalEntity = billBalEntity;
        return this;
    }

    public String getBillIdProp() {
        return this.billIdProp;
    }

    public BillDimBalanceConfig setBillIdProp(String billIdProp) {
        this.billIdProp = billIdProp;
        return this;
    }

    public String getOrgProp() {
        return this.orgProp;
    }

    public BillDimBalanceConfig setOrgProp(String orgProp) {
        this.orgProp = orgProp;
        return this;
    }

    public String getCurrencyProp() {
        return this.currencyProp;
    }

    public BillDimBalanceConfig setCurrencyProp(String currencyProp) {
        this.currencyProp = currencyProp;
        return this;
    }

    public String getStartDateProp() {
        return this.startDateProp;
    }

    public BillDimBalanceConfig setStartDateProp(String startDateProp) {
        this.startDateProp = startDateProp;
        return this;
    }

    public String getEndDateProp() {
        return this.endDateProp;
    }

    public BillDimBalanceConfig setEndDateProp(String endDateProp) {
        this.endDateProp = endDateProp;
        return this;
    }

    public QFilter getCondition() {
        return this.condition;
    }

    public BillDimBalanceConfig setCondition(QFilter condition) {
        this.condition = condition;
        return this;
    }

    public String getCreateBalCycle() {
        return this.createBalCycle;
    }

    public BillDimBalanceConfig setCreateBalCycle(String createBalCycle) {
        this.createBalCycle = createBalCycle;
        return this;
    }

    public List<AmountMapConfig> getAmountEntry() {
        return this.amountEntry;
    }

    public List<AmountMapConfig> getInitAmountEntry() {
        return this.initAmountEntry;
    }

    public List<FreezeMapConfig> getFreezeEntry() {
        return this.freezeEntry;
    }

    public List<String> getDimenProps() {
        return this.dimenProps;
    }

    public BalanceMapConfig getBillBalConfig() {
        return this.balanceMapConfig;
    }
}

