/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.billversion;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillVersionBatchChangeService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BillVersionBatchChangeService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("entityname");
        sic.add("idsetstr");
        sic.add("entry");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject dataEntity = dataEntities[0];
        String entityName = dataEntity.getString("entityname");
        String idSetStr = dataEntity.getString("idsetstr");
        Set idSet = (Set)SerializationUtils.fromJsonString((String)idSetStr, Set.class);
        List collect = idSet.stream().map(String::valueOf).collect(Collectors.toList());
        List<Object> requestIds = new ArrayList(10);
        try {
            DynamicObject[] historyData;
            Map request = MutexServiceHelper.batchRequest(collect, (String)entityName, (String)"BillBatchChange");
            requestIds = request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            List requestFailIds = request.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(requestFailIds)) {
                logger.info("\u5355\u636e\u6279\u91cf\u53d8\u66f4\u83b7\u53d6\u4e0d\u5230\u9501\u7684ID\uff1a" + JSON.toJSONString(requestFailIds));
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4e0d\u5230\u5355\u636e\u6279\u91cf\u53d8\u66f4\u4e92\u65a5\u9501\uff0c\u8bf7\u7a0d\u540e\u5904\u7406\u3002", (String)"BillVersionBatchChangeService_0", (String)"tmc-fcs-business", (Object[])new Object[0]));
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
            Map allFields = dataEntityType.getAllFields();
            DynamicObjectCollection entrys = dataEntity.getDynamicObjectCollection("entry");
            List headPropList = entrys.stream().filter(s -> !s.getString("changefield").contains(".")).collect(Collectors.toList());
            HashMap<String, Object> headMap = new HashMap<String, Object>(headPropList.size());
            for (DynamicObject headProp : headPropList) {
                String headChangeProp = headProp.getString("changefield");
                String string = headProp.getString("afterchangeval");
                this.transPropToMap(headMap, allFields, headChangeProp, string);
            }
            Map<String, List<DynamicObject>> entryPropMap = entrys.stream().filter(s -> s.getString("changefield").contains(".")).collect(Collectors.groupingBy(e -> e.getString("changefield").split("\\.")[0]));
            HashMap<String, HashMap<String, Object>> entryAllMap = new HashMap<String, HashMap<String, Object>>(entryPropMap.size());
            for (Map.Entry entry : entryPropMap.entrySet()) {
                String entryName = (String)entry.getKey();
                List entryPropList = (List)entry.getValue();
                HashMap<String, Object> entryMap = new HashMap<String, Object>(entryPropList.size());
                for (DynamicObject dynamicObject : entryPropList) {
                    String entryChangeProp = dynamicObject.getString("changefield");
                    String entryChangeValue = dynamicObject.getString("afterchangeval");
                    this.transPropToMap(entryMap, allFields, entryChangeProp.split("\\.")[1], entryChangeValue);
                }
                entryAllMap.put(entryName, entryMap);
            }
            for (DynamicObject history : historyData = TmcDataServiceHelper.load((Object[])idSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName))) {
                BillChangeHistoryHelper.addChangeHistory(null, (String)"", (String)"", (String)"", (String)"batch", (DynamicObject)history);
                for (Map.Entry entry : headMap.entrySet()) {
                    String entryKey = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (entryKey.contains("_mulbasedata")) {
                        String prop = this.getMulBaseDataProp(entryKey);
                        DynamicObjectCollection collection = TmcDataServiceHelper.generateMultiPropValue((DynamicObject)history, (String)prop, (DynamicObject[])((DynamicObject[])value));
                        history.set(prop, (Object)collection);
                        continue;
                    }
                    history.set(entryKey, value);
                }
                for (Map.Entry entry : entryAllMap.entrySet()) {
                    String entryName = (String)entry.getKey();
                    DynamicObjectCollection historyEntrys = history.getDynamicObjectCollection(entryName);
                    if (EmptyUtil.isEmpty((DynamicObjectCollection)historyEntrys)) continue;
                    Map entryMap = (Map)entry.getValue();
                    for (DynamicObject historyEntry : historyEntrys) {
                        for (Map.Entry entryEntry : entryMap.entrySet()) {
                            String entryKey = (String)entryEntry.getKey();
                            Object value = entryEntry.getValue();
                            if (entryKey.contains("_mulbasedata")) {
                                DynamicObject[] changeValues;
                                String prop = this.getMulBaseDataProp(entryKey);
                                DynamicObjectCollection collection = historyEntry.getDynamicObjectCollection(prop);
                                collection.clear();
                                for (DynamicObject changeValue : changeValues = (DynamicObject[])value) {
                                    DynamicObject proEntrys = collection.addNew();
                                    proEntrys.set("fbasedataid", changeValue.getPkValue());
                                }
                                historyEntry.set(prop, (Object)collection);
                                continue;
                            }
                            historyEntry.set(entryKey, value);
                        }
                    }
                }
            }
            this.saveSourBill(historyData);
        }
        finally {
            if (requestIds.size() > 0) {
                MutexServiceHelper.batchRelease(requestIds, (String)entityName, (String)"BillBatchChange");
                logger.info("\u91ca\u653e\u6279\u91cf\u53d8\u66f4\u9501:" + JSON.toJSONString(requestIds));
            }
        }
    }

    private String getMulBaseDataProp(String entryKey) {
        int lastIndexOf = entryKey.lastIndexOf("_mulbasedata");
        return entryKey.substring(0, lastIndexOf);
    }

    private void saveSourBill(DynamicObject[] historyData) {
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])historyData);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void transPropToMap(Map<String, Object> map, Map<String, IDataEntityProperty> allFields, String changeProp, String changeValue) {
        IDataEntityProperty property = allFields.get(changeProp);
        if (property instanceof BasedataProp) {
            map.put(changeProp, Long.parseLong(changeValue));
        } else if (property instanceof MulBasedataProp) {
            String baseEntityId = ((MulBasedataProp)property).getBaseEntityId();
            Object[] pkIdArr = changeValue.contains(";") ? Arrays.stream(changeValue.split(";")).map(Long::parseLong).toArray() : new Long[]{Long.parseLong(changeValue)};
            Map mulData = TmcDataServiceHelper.loadFromCache((Object[])pkIdArr, (String)baseEntityId);
            map.put(changeProp + "_mulbasedata", mulData.values().toArray(new DynamicObject[0]));
        } else if (property instanceof DateTimeProp) {
            String format = "yyyy-MM-dd HH:mm:ss";
            if (property instanceof DateProp) {
                format = "yyyy-MM-dd";
            }
            map.put(changeProp, DateUtils.stringToDate((String)changeValue, (String)format));
        } else if (property instanceof ComboProp || property instanceof TextProp || property instanceof BooleanProp || property instanceof DecimalProp) {
            map.put(changeProp, changeValue);
        }
    }
}

