/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.payaccess;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.PayAccessHelper;
import kd.tmc.fcs.common.property.PayAccesslProp;

public class PayAccessUnRegistService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("destentity");
        list.add("srcentity");
        list.add("operate");
        list.add("enable");
        return list;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<String> entrySet = new HashSet<String>(16);
        HashSet<Object> idSet = new HashSet<Object>(16);
        for (DynamicObject dataEntity : dataEntities) {
            String destEntity = dataEntity.getDynamicObject("destentity").getString("number");
            DynamicObject srcEntity = dataEntity.getDynamicObject("srcentity");
            entrySet.add(destEntity);
            if (EmptyUtil.isNoEmpty((DynamicObject)srcEntity)) {
                entrySet.add(srcEntity.getString("number"));
            }
            Object pkValue = dataEntity.getPkValue();
            idSet.add(pkValue);
        }
        Map payAccessMap = PayAccessHelper.getPayAccessInfo(entrySet, idSet);
        for (DynamicObject payAccess : payAccessMap.values()) {
            String destEntity = payAccess.getDynamicObject("destentity").getString("number");
            entrySet.remove(destEntity);
            DynamicObject srcEntity = payAccess.getDynamicObject("srcentity");
            if (!EmptyUtil.isNoEmpty((DynamicObject)srcEntity)) continue;
            entrySet.remove(srcEntity.getString("number"));
        }
        Map blackMap = PayAccessHelper.queryWhiteOrBlackListByEntity(entrySet, (String)"fcs_payaccess_blacklist");
        if (!blackMap.isEmpty()) {
            Set collect = blackMap.values().stream().map(s -> s.getDynamicObject("destentity").getString("number")).collect(Collectors.toSet());
            entrySet.removeAll(collect);
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (EmptyUtil.isNoEmpty(entrySet)) {
                    for (String entry : entrySet) {
                        if (PayAccesslProp.BLACK_LIST.contains(entry)) continue;
                        OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entry, (String)"PayAccess_hide");
                    }
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }
}

