/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.repeatctrl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fcs.common.property.PayAccesslProp;

public class RepeatCtrlRegistService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            if (!"1".equals(dataEntity.getString("enable"))) continue;
            String entityNumber = dataEntity.getDynamicObject("ctrlentity").getString("number");
            try (TXHandle tx = TX.requiresNew();){
                try {
                    List<String> opLists = this.getAfterLoginOperation(dataEntity, entityNumber);
                    if (opLists.size() <= 0) continue;
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)"PayAccess_hide", opLists);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private List<String> getAfterLoginOperation(DynamicObject dataEntity, String entityNumber) {
        DynamicObject[] checkctrls;
        Set opSet = Arrays.stream(dataEntity.getString("opreat").replaceFirst(",", "").split(",")).collect(Collectors.toSet());
        opSet.addAll(PayAccesslProp.OPKEYS);
        QFilter filter = new QFilter("ctrlentity", "=", (Object)entityNumber);
        filter.and("enable", "=", (Object)"1");
        filter.and("id", "!=", dataEntity.getPkValue());
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fcs_checkctrl", (String)"id,ctrlentity,opreat", (QFilter[])new QFilter[]{filter});
        for (DynamicObject checkctrl : checkctrls = (DynamicObject[])query.toArray((Object[])new DynamicObject[0])) {
            opSet.addAll(Arrays.stream(checkctrl.getString("opreat").replaceFirst(",", "").split(",")).collect(Collectors.toList()));
        }
        if (PayAccesslProp.BLACK_LIST.contains(entityNumber)) {
            opSet.removeAll(PayAccesslProp.OPKEYS);
        }
        return new ArrayList<String>(opSet);
    }
}

