/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.risk;

import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RiskTradeWarnRegistService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("billentity");
        sel.add("warnop");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            if (!BaseEnableEnum.ENABLE.getValue().equals(dataEntity.getString("enable"))) continue;
            DynamicObject billEntity = dataEntity.getDynamicObject("billentity");
            String billNumber = billEntity.getString("number");
            String warnOp = dataEntity.getString("warnop");
            try (TXHandle tx = TX.requiresNew();){
                try {
                    if (!EmptyUtil.isNoEmpty((String)warnOp)) continue;
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)billNumber, (String)"RiskTradeWarn", Collections.singletonList(warnOp));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

