/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.schedule;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.ScheduleTaskTypeEnum;

public class ScheduleExecuteService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ScheduleExecuteService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("name");
        selector.add("executor");
        selector.add("tasktype");
        selector.add("taskentry");
        selector.add("bizapp");
        selector.add("taskentry.schejob");
        return selector;
    }

    public void process(DynamicObject[] dynamicObjects) throws KDException {
        for (DynamicObject object : dynamicObjects) {
            RequestContext rc = RequestContext.get();
            DynamicObject executor = object.getDynamicObject("executor");
            JobInfo job = new JobInfo();
            job.setRunByLang(Lang.get());
            job.setJobType(JobType.BIZ);
            job.setName(rc.getUserName() + " execute job");
            job.setId(Uuid16.create().toString());
            long userId = EmptyUtil.isEmpty((DynamicObject)executor) ? rc.getCurrUserId() : executor.getLong("id");
            job.setRunByUserId(userId);
            job.setTaskClassname("kd.bos.ext.tmc.task.TmcScheduleTask");
            HashMap<String, Object> params = new HashMap<String, Object>(4);
            params.put("intellSchemaidList", Collections.singleton(Collections.singletonMap("Id", object.getLong("id"))));
            params.put("type", "1");
            job.setParams(params);
            job.setAppId(this.getDispatchApp(object));
            job.setRunConcurrently(false);
            String taskId = JobClient.dispatch((JobInfo)job);
            logger.info("submit job {} on taskId[{}]", (Object)object.getString("name"), (Object)taskId);
        }
    }

    private String getDispatchApp(DynamicObject sch) {
        if (ScheduleTaskTypeEnum.isOperation((String)sch.getString("tasktype"))) {
            return sch.getString("bizapp.number");
        }
        DynamicObject schJob = ((DynamicObject)sch.getDynamicObjectCollection("taskentry").get(0)).getDynamicObject("schejob");
        return schJob.getString("appid");
    }
}

