/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.opservice.suspect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.SuspectCtrlTypeEnum;

public class SuspectUnRegistService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("destentity");
        sic.add("ctrltype");
        sic.add("checkop");
        sic.add("landingop");
        sic.add("enable");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            String entityNumber = dataEntity.getDynamicObject("destentity").getString("number");
            QFilter filter = new QFilter("destentity", "=", (Object)entityNumber);
            filter.and("enable", "=", (Object)"1");
            filter.and("id", "!=", dataEntity.getPkValue());
            Map otherSets = BusinessDataServiceHelper.loadFromCache((String)"fcs_suspectset", (String)"id,ctrltype,checkop,landingop", (QFilter[])new QFilter[]{filter});
            try (TXHandle tx = TX.requiresNew();){
                try {
                    if (otherSets.isEmpty()) {
                        OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"SuspectRepeatGen");
                        OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)entityNumber, (String)"SuspectRepeatCtrl");
                        continue;
                    }
                    HashSet landingOP = new HashSet(4);
                    HashSet checkOP = new HashSet(4);
                    for (DynamicObject suspectSet : otherSets.values()) {
                        if (!SuspectCtrlTypeEnum.WARNING.getValue().equals(suspectSet.getString("ctrltype"))) {
                            landingOP.addAll(Arrays.stream(suspectSet.getString("landingop").replaceFirst(",", "").split(",")).collect(Collectors.toSet()));
                        }
                        checkOP.addAll(Arrays.stream(suspectSet.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toSet()));
                    }
                    if (EmptyUtil.isNoEmpty(landingOP)) {
                        OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)"SuspectRepeatCtrl", new ArrayList(landingOP));
                    }
                    OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)"SuspectRepeatGen", new ArrayList(checkOP));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }
}

