/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.validate.repeatctrl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RepeatCtrlRegistValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List list = super.getSelector();
        list.add("ctrlentity");
        list.add("opreat");
        list.add("isload");
        list.add("entryentity");
        list.add("subentryentity");
        list.add("isrepeat");
        list.add("isctrlamt");
        list.add("srcentity");
        list.add("srcrule");
        list.add("issrcmulamt");
        list.add("srcmulamt_tag");
        list.add("srcamtfield");
        list.add("targetrule");
        list.add("istargetmulamt");
        list.add("targetmulamt_tag");
        list.add("targetamtfield");
        list.add("othertargetentity");
        list.add("othertargetamtfield");
        list.add("isothermulamt");
        list.add("othermulamt_tag");
        list.add("enable");
        list.add("entryentity.seq");
        list.add("subentryentity.seq");
        return list;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            boolean isRepeat = dataEntity.getBoolean("isrepeat");
            boolean isCtrlAmt = dataEntity.getBoolean("isctrlamt");
            if (!isRepeat && !isCtrlAmt) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u9632\u91cd\u63a8\u548c\u9632\u8d85\u989d\u81f3\u5c11\u9009\u4e00\u4e2a\u6253\u5f00\u3002", (String)"RepeatCtrlRegistValidator_2", (String)"tmc-fcs-business", (Object[])new Object[0]));
            }
            if (!isCtrlAmt) continue;
            DynamicObjectCollection entryEntitys = dataEntity.getDynamicObjectCollection("entryentity");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntitys)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u3010\u9632\u8d85\u989d\u8bbe\u7f6e\u3011\u7684\u91c7\u96c6\u89c4\u5219\u3002", (String)"RepeatCtrlRegistValidator_3", (String)"tmc-fcs-business", (Object[])new Object[0]));
            }
            for (DynamicObject entryRow : entryEntitys) {
                String srcRule = entryRow.getString("srcrule");
                String targetRule = entryRow.getString("targetrule");
                if ("EntrySum".equals(srcRule) && "EntrySingle".equals(targetRule)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6e90\u5355\u91c7\u96c6\u89c4\u5219\u3010\u5355\u636e\u4f53\u5408\u8ba1\u3011\u4e0e\u76ee\u6807\u5355\u91c7\u96c6\u89c4\u5219\u3010\u5355\u636e\u4f53\u9010\u4e00\u3011\u914d\u7f6e\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6709\u6548\u7684\u91c7\u96c6\u89c4\u5219\u3002", (String)"RepeatCtrlRegistValidator_4", (String)"tmc-fcs-business", (Object[])new Object[0]));
                }
                if (entryRow.getBoolean("issrcmulamt")) {
                    if (EmptyUtil.isEmpty((String)entryRow.getString("srcmulamt_tag"))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6e90\u5355\u591a\u91d1\u989d\u91c7\u96c6\u3002", (String)"RepeatCtrlRegistValidator_5", (String)"tmc-fcs-business", (Object[])new Object[0]));
                    }
                } else if (EmptyUtil.isEmpty((String)entryRow.getString("srcamtfield"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u6e90\u5355\u91d1\u989d\u5b57\u6bb5\u3002", (String)"RepeatCtrlRegistValidator_8", (String)"tmc-fcs-business", (Object[])new Object[0]));
                }
                if (entryRow.getBoolean("istargetmulamt")) {
                    if (EmptyUtil.isEmpty((String)entryRow.getString("targetmulamt_tag"))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u76ee\u6807\u5355\u591a\u91d1\u989d\u91c7\u96c6\u3002", (String)"RepeatCtrlRegistValidator_6", (String)"tmc-fcs-business", (Object[])new Object[0]));
                    }
                } else if (EmptyUtil.isEmpty((String)entryRow.getString("targetamtfield"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u76ee\u6807\u5355\u91d1\u989d\u5b57\u6bb5\u3002", (String)"RepeatCtrlRegistValidator_9", (String)"tmc-fcs-business", (Object[])new Object[0]));
                }
                this.checkIsRight(extendedDataEntity, entryRow, "srcrule", "srcamtfield", "srcentity");
                this.checkIsRight(extendedDataEntity, entryRow, "targetrule", "targetamtfield", "ctrlentity");
                DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("subentryentity");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)subEntry)) continue;
                String curRule = entryRow.getString("targetrule");
                int rowSeq = entryRow.getInt("seq");
                subEntry.forEach(row -> {
                    if (EmptyUtil.isNoEmpty((DynamicObject)row.getDynamicObject("othertargetentity"))) {
                        if (row.getBoolean("isothermulamt") && EmptyUtil.isEmpty((String)row.getString("othermulamt_tag"))) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u76ee\u6807\u5355\u5173\u8054\u91c7\u96c6-\u76ee\u6807\u5355\u591a\u91d1\u989d\u91c7\u96c6\u3002", (String)"RepeatCtrlRegistValidator_7", (String)"tmc-fcs-business", (Object[])new Object[0]));
                        }
                        String propFiled = row.getString("othertargetamtfield");
                        if (!row.getBoolean("isothermulamt")) {
                            if (EmptyUtil.isEmpty((String)propFiled)) {
                                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u76ee\u6807\u5355\u5173\u8054\u91c7\u96c6-\u76ee\u6807\u5355\u91d1\u989d\u5b57\u6bb5\u3002", (String)"RepeatCtrlRegistValidator_1", (String)"tmc-fcs-business", (Object[])new Object[0]));
                            }
                            String billEntity = row.getDynamicObject("othertargetentity").getString("number");
                            MainEntityType MainType = EntityMetadataCache.getDataEntityType((String)billEntity);
                            String[] pLevel = propFiled.split("\\.");
                            IDataEntityProperty property = MainType.findProperty(pLevel[pLevel.length - 1]);
                            int subRowSeq = row.getInt("seq");
                            if (!(property instanceof DecimalProp)) {
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7b2c%1$s\u884c\u91c7\u96c6\u89c4\u5219\u7684\u7b2c%2$s\u884c\u5173\u8054\u91c7\u96c6\u4e2d\u9009\u62e9\u6b63\u786e\u7684\u91d1\u989d\u5b57\u6bb5\u3002", (String)"RepeatCtrlRegistValidator_12", (String)"tmc-fcs-business", (Object[])new Object[0]), rowSeq, subRowSeq));
                                return;
                            }
                            if (property.getParent().getParent() == null) {
                                if (!"Head".equals(curRule)) {
                                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u89c4\u5219\u7684\u7b2c%1$s\u884c\u76ee\u6807\u5355\u91c7\u96c6\u89c4\u5219\u548c\u5176\u76ee\u6807\u5355\u5173\u8054\u91c7\u96c6\u7684\u7b2c%2$s\u884c\u91d1\u989d\u5b57\u6bb5\u4e0d\u4e00\u81f4\u3002", (String)"RepeatCtrlRegistValidator_13", (String)"tmc-fcs-business", (Object[])new Object[0]), rowSeq, subRowSeq));
                                }
                            } else if ("Head".equals(curRule)) {
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u91c7\u96c6\u89c4\u5219\u7684\u7b2c%1$s\u884c\u76ee\u6807\u5355\u91c7\u96c6\u89c4\u5219\u548c\u5176\u76ee\u6807\u5355\u5173\u8054\u91c7\u96c6\u7684\u7b2c%2$s\u884c\u91d1\u989d\u5b57\u6bb5\u4e0d\u4e00\u81f4\u3002", (String)"RepeatCtrlRegistValidator_13", (String)"tmc-fcs-business", (Object[])new Object[0]), rowSeq, subRowSeq));
                            }
                        }
                    }
                });
            }
        }
    }

    private void checkIsRight(ExtendedDataEntity extendedDataEntity, DynamicObject entryRow, String ruleProp, String amtProp, String entityProp) {
        String propFiled = entryRow.getString(amtProp);
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String billEntity = dataEntity.getDynamicObject(entityProp).getString("number");
        MainEntityType MainType = EntityMetadataCache.getDataEntityType((String)billEntity);
        String curRule = entryRow.getString(ruleProp);
        int index = entryRow.getInt("seq");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{propFiled, curRule})) {
            return;
        }
        String[] pLevel = propFiled.split("\\.");
        IDataEntityProperty property = MainType.findProperty(pLevel[pLevel.length - 1]);
        if (!(property instanceof DecimalProp)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u9009\u62e9\u91c7\u96c6\u89c4\u5219\u7684\u7b2c%s\u884c\u91d1\u989d\u5b57\u6bb5\u3002", (String)"RepeatCheckCtrlTabAmtEdit_3", (String)"tmc-fcs-business", (Object[])new Object[]{index}));
            return;
        }
        if (property.getParent().getParent() == null) {
            if (!"Head".equals(curRule)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u91c7\u96c6\u89c4\u5219\u7684\u91d1\u989d\u5b57\u6bb5\u4e0e\u91c7\u96c6\u89c4\u5219\u4e0d\u4e00\u81f4\u3002", (String)"RepeatCtrlRegistValidator_11", (String)"tmc-fcs-business", (Object[])new Object[]{index}));
            }
        } else if ("Head".equals(curRule)) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u91c7\u96c6\u89c4\u5219\u7684\u91d1\u989d\u5b57\u6bb5\u4e0e\u91c7\u96c6\u89c4\u5219\u4e0d\u4e00\u81f4\u3002", (String)"RepeatCtrlRegistValidator_11", (String)"tmc-fcs-business", (Object[])new Object[]{index}));
        }
    }
}

