/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.validate.risk;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;

public class RiskLogCleanValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("createdate");
        return selector;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        Date limitDate = DateUtils.getNextDay((Date)new Date(), (int)-2);
        for (ExtendedDataEntity extendedData : extendedDataEntities) {
            DynamicObject dataEntity = extendedData.getDataEntity();
            Date createDate = dataEntity.getDate("createdate");
            if (!Objects.nonNull(createDate) || !createDate.after(limitDate)) continue;
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e92\u5929\u4e4b\u524d\u7684\u7b5b\u67e5\u65e5\u5fd7\u6e05\u7406\u3002", (String)"RiskLogCleanValidator_0", (String)"tmc-fcs-business", (Object[])new Object[0]));
        }
    }
}

