/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.validate.risk;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RiskTradeScheduleValidator
extends AbstractTmcBizOppValidator {
    private static final Log logger = LogFactory.getLog(RiskTradeScheduleValidator.class);

    public void validate(ExtendedDataEntity[] dataEntities) throws KDBizException {
        Map variables = this.getOption().getVariables();
        String scheduleDateRange = (String)variables.get("schedule_daterange");
        logger.info("RiskTradeScheduleValidator scheduleDateRange {}", (Object)scheduleDateRange);
        if (EmptyUtil.isNoEmpty((String)scheduleDateRange)) {
            try {
                String[] dateRange = scheduleDateRange.split("-");
                Date startDate = DateUtils.stringToDate((String)dateRange[0], (String)"yyyyMMdd");
                Date endDate = DateUtils.stringToDate((String)dateRange[1], (String)"yyyyMMdd");
                if (startDate.after(endDate)) {
                    this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002", (String)"RiskTradeScheduleValidator_2", (String)"tmc-fcs-business", (Object[])new Object[0]));
                }
            }
            catch (Exception e) {
                this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u683c\u5f0f\u5fc5\u987b\uff1ayyyyMMdd-yyyyMMdd\u3002", (String)"RiskTradeScheduleValidator_0", (String)"tmc-fcs-business", (Object[])new Object[0]));
            }
        } else {
            String scheduleCycle = (String)variables.get("schedule_cycle");
            logger.info("RiskTradeScheduleValidator scheduleCycle {}", (Object)scheduleCycle);
            if (EmptyUtil.isNoEmpty((String)scheduleCycle) && (Integer.parseInt(scheduleCycle) > 90 || Integer.parseInt(scheduleCycle) < 0)) {
                this.addErrorMessage(dataEntities[0], ResManager.loadKDString((String)"\u8c03\u5ea6\u5468\u671f\u8f93\u5165\u8303\u56f4[0,90]\u3002", (String)"RiskTradeScheduleValidator_1", (String)"tmc-fcs-business", (Object[])new Object[0]));
            }
        }
    }
}

