/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.validate.suspect;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fcs.common.enums.SuspectCtrlTypeEnum;

public class SuspectCancelConfirmValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("ctrltype");
        sic.add("billid");
        sic.add("billentity");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        ArrayList<Long> selectedIdList = new ArrayList<Long>(10);
        ArrayList<Long> allBillIds = new ArrayList<Long>(10);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String ctrlType = dataEntity.getString("ctrltype");
            if (SuspectCtrlTypeEnum.CONTROL.getValue().equals(ctrlType)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u7591\u4f3c\u9632\u91cd\u63a7\u5236\u4e3a\u843d\u5730\u7684\u6570\u636e\u624d\u80fd\u64cd\u4f5c\u3010\u53d6\u6d88\u786e\u8ba4\u3011\u3002", (String)"SuspectBillListPlugin_6", (String)"tmc-fcs-business", (Object[])new Object[0]));
                continue;
            }
            selectedIdList.add(dataEntity.getLong("id"));
            long bizBillId = dataEntity.getLong("billid");
            allBillIds.add(bizBillId);
        }
        QFilter qFilter = new QFilter("id", "not in", selectedIdList);
        qFilter.and("billid", "in", allBillIds);
        qFilter.and("ctrltype", "=", (Object)SuspectCtrlTypeEnum.LANDING.getValue());
        boolean exist = TmcDataServiceHelper.exists((String)"fcs_suspectbill", (QFilter[])qFilter.toArray());
        if (exist) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u5168\u90e8\u53d6\u6d88\u786e\u8ba4\u7684\u7591\u4f3c\u91cd\u590d\u5355\u636e\u8bb0\u5f55\uff0c\u8bf7\u5168\u90e8\u53d6\u6d88\u786e\u8ba4\u3002", (String)"SuspectBillListPlugin_2", (String)"tmc-fcs-business", (Object[])new Object[0]));
        }
    }
}

