/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.business.validate.suspect;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.validate.AbstractTmcBizOppValidator;
import kd.tmc.fcs.common.enums.SuspectCtrlTypeEnum;

public class SuspectRegistValidator
extends AbstractTmcBizOppValidator {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("destentity");
        sic.add("ctrltype");
        sic.add("checkop");
        sic.add("landingop");
        sic.add("enable");
        sic.add("openmq");
        return sic;
    }

    public void validate(ExtendedDataEntity[] extendedDataEntities) throws KDBizException {
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            boolean openmqOfDataBase;
            List collect;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String ctrlType = dataEntity.getString("ctrltype");
            if (SuspectCtrlTypeEnum.WARNING.getValue().equals(ctrlType) && (collect = Arrays.stream(dataEntity.getString("checkop").replaceFirst(",", "").split(",")).collect(Collectors.toList())).size() < 2) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u7591\u4f3c\u9632\u91cd\u63a7\u5236\u7c7b\u578b\u4e3a\u9884\u8b66\u65f6\uff0c\u6821\u9a8c\u64cd\u4f5c\u81f3\u5c11\u8981\u9009\u62e9\u4e24\u4e2a\u3002", (String)"SuspectRegistValidator_0", (String)"tmc-fcs-business", (Object[])new Object[0]));
            }
            String destentity = dataEntity.getString("destentity.number");
            boolean openmq = (Boolean)dataEntity.get("openmq");
            QFilter qFilter = new QFilter("destentity.number", "=", (Object)destentity);
            qFilter.and("enable", "=", (Object)"1");
            qFilter.and("id", "!=", dataEntity.getPkValue());
            DynamicObjectCollection suspectBills = QueryServiceHelper.query((String)"fcs_suspectset", (String)"openmq", (QFilter[])qFilter.toArray());
            if (suspectBills.size() <= 0 || (openmqOfDataBase = ((Boolean)((DynamicObject)suspectBills.get(0)).get("openmq")).booleanValue()) == openmq) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7684\u201c\u5f00\u542fMQ\u6d88\u8d39\u201d\u53c2\u6570\u4e0e\u6b64\u7c7b\u5355\u636e\u5df2\u5b58\u5728\u7684\u201c\u5f00\u542fMQ\u6d88\u8d39\u201d\u53c2\u6570\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SuspectSaveValidator_0", (String)"tmc-fcs-business", (Object[])new Object[0]));
        }
    }
}

