/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.billbalance;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.bean.EntityPropInfo;
import kd.tmc.fbp.common.enums.EntityPropTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.selectprop.EntityFilterHelper;
import kd.tmc.fbp.formplugin.common.selectprop.SelectEntityPropHelper;
import kd.tmc.fbp.formplugin.common.selectprop.SelectEntityPropParam;
import kd.tmc.fcs.common.enums.BillBalanceMapEnum;

public class BillDimBalanceEditPlugin
extends AbstractFormPlugin {
    private static final String FILTERGRID = "filtergrid";
    private static final String BILL_NUMBER = "number";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"ie_filterset", "ie_srcbillprop", "ie_destbillprop", "ie_bizdateprop", "ie_amountprop", "ae_filterset", "ae_srcbillprop", "ae_destbillprop", "ae_bizdateprop", "ae_amountprop", "fe_filterset", "fe_srcbillprop", "fe_destbillprop", "fe_bizdateprop", "fe_amountprop", "fe_freezetypeprop", "be_balselprop"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData changeSet = e.getChangeSet()[0];
        Object newValue = changeSet.getNewValue();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        switch (e.getProperty().getName()) {
            case "billentity": {
                this.billEntityOnChanged(newValue, dataEntity);
                break;
            }
            case "dimenprops": {
                this.initBalPropItems((String)newValue, dataEntity);
            }
        }
    }

    private void initBalPropItems(String dimenProps, DynamicObject dataEntity) {
        ArrayList<EntityPropInfo> combos = new ArrayList<EntityPropInfo>(16);
        for (BillBalanceMapEnum value : BillBalanceMapEnum.values()) {
            combos.add(EntityPropInfo.build((String)value.getValue(), (String)value.getName().loadKDString()));
        }
        if (EmptyUtil.isNoEmpty((String)dimenProps)) {
            String[] dimenFields;
            DynamicObject billEntity = dataEntity.getDynamicObject("billentity");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billEntity.getString(BILL_NUMBER));
            Map fieldMap = entityType.getFields();
            for (String dimenField : dimenFields = dimenProps.substring(1, dimenProps.length() - 1).split(",")) {
                IDataEntityProperty property = (IDataEntityProperty)fieldMap.get(dimenField);
                if (property == null) continue;
                combos.add(EntityPropInfo.build((String)dimenField, (String)property.getDisplayName().getLocaleValue()));
            }
        }
        SelectEntityPropHelper.initEnumPropItems((IFormView)this.getView(), (String)"be_balprop", combos);
    }

    private void billEntityOnChanged(Object newValue, DynamicObject dataEntity) {
        if (newValue == null) {
            return;
        }
        this.initBillFilterGrid();
        IDataModel model = this.getModel();
        model.setValue("billfilter_tag", null);
        model.setValue("billbalentity", null);
        this.initBillConfigProp(dataEntity);
        dataEntity.getDynamicObjectCollection("initamountentry").clear();
        dataEntity.getDynamicObjectCollection("amountentry").clear();
        dataEntity.getDynamicObjectCollection("freezeentry").clear();
        this.getView().updateView();
    }

    private void initBillConfigProp(DynamicObject dataEntity) {
        DynamicObject billEntity = dataEntity.getDynamicObject("billentity");
        if (billEntity == null) {
            return;
        }
        IFormView formView = this.getView();
        String entityNumber = billEntity.getString(BILL_NUMBER);
        SelectEntityPropHelper.initEnumPropItems((IFormView)formView, (String)entityNumber, (String)"billidprop", (EntityPropTypeEnum[])new EntityPropTypeEnum[]{EntityPropTypeEnum.LONG});
        SelectEntityPropHelper.initEnumPropItems((IFormView)formView, (String)entityNumber, (String)"orgprop", (EntityPropTypeEnum[])new EntityPropTypeEnum[]{EntityPropTypeEnum.ORG});
        SelectEntityPropHelper.initEnumPropItems((IFormView)formView, (String)entityNumber, (String)"currencyprop", (EntityPropTypeEnum[])new EntityPropTypeEnum[]{EntityPropTypeEnum.CURRENCY});
        SelectEntityPropHelper.initEnumPropItems((IFormView)formView, (String)entityNumber, (String)"startdateprop", (EntityPropTypeEnum[])new EntityPropTypeEnum[]{EntityPropTypeEnum.DATE});
        SelectEntityPropHelper.initEnumPropItems((IFormView)formView, (String)entityNumber, (String)"enddateprop", (EntityPropTypeEnum[])new EntityPropTypeEnum[]{EntityPropTypeEnum.DATE});
        SelectEntityPropHelper.initEnumPropItems((IFormView)formView, (String)entityNumber, (String)"dimenprops", (EntityPropTypeEnum[])new EntityPropTypeEnum[0]);
        this.initBalPropItems(dataEntity.getString("dimenprops"), dataEntity);
    }

    private void initBillFilterGrid() {
        DynamicObject billEntity = (DynamicObject)this.getModel().getValue("billentity");
        EntityFilterHelper.initFilterGrid((IFormView)this.getView(), (String)FILTERGRID, billEntity != null ? billEntity.getString(BILL_NUMBER) : null);
    }

    public void click(EventObject evt) {
        String key;
        Object source = evt.getSource();
        if (!(source instanceof Control)) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject billEntity = dataEntity.getDynamicObject("billentity");
        if (billEntity == null) {
            return;
        }
        String entityNumber = billEntity.getString(BILL_NUMBER);
        switch (key = ((Control)source).getKey()) {
            case "ie_srcbillprop": {
                this.showEntitySelectProps("initamountentry", "ie_billentity", key, EntityPropTypeEnum.LONG, EntityPropTypeEnum.BASEDATA);
                break;
            }
            case "ie_bizdateprop": {
                this.showEntitySelectProps("initamountentry", "ie_billentity", key, EntityPropTypeEnum.DATE);
                break;
            }
            case "ie_amountprop": {
                this.showEntitySelectProps("initamountentry", "ie_billentity", key, EntityPropTypeEnum.AMOUNT);
                break;
            }
            case "ie_filterset": {
                this.showBillFilterForm("initamountentry", "ie_billentity", "ie_filter_tag", key);
                break;
            }
            case "ae_srcbillprop": {
                this.showEntitySelectProps("amountentry", "ae_billentity", key, EntityPropTypeEnum.LONG, EntityPropTypeEnum.BASEDATA);
                break;
            }
            case "ae_bizdateprop": {
                this.showEntitySelectProps("amountentry", "ae_billentity", key, EntityPropTypeEnum.DATE);
                break;
            }
            case "ae_amountprop": {
                this.showEntitySelectProps("amountentry", "ae_billentity", key, EntityPropTypeEnum.AMOUNT);
                break;
            }
            case "ae_filterset": {
                this.showBillFilterForm("amountentry", "ae_billentity", "ae_filter_tag", key);
                break;
            }
            case "fe_srcbillprop": {
                this.showEntitySelectProps("freezeentry", "fe_billentity", key, EntityPropTypeEnum.LONG, EntityPropTypeEnum.BASEDATA);
                break;
            }
            case "fe_bizdateprop": {
                this.showEntitySelectProps("freezeentry", "fe_billentity", key, EntityPropTypeEnum.DATE);
                break;
            }
            case "fe_amountprop": {
                this.showEntitySelectProps("freezeentry", "fe_billentity", key, EntityPropTypeEnum.AMOUNT);
                break;
            }
            case "fe_freezetypeprop": {
                this.showEntitySelectProps("freezeentry", "fe_billentity", key, EntityPropTypeEnum.ENUM);
                break;
            }
            case "fe_filterset": {
                this.showBillFilterForm("freezeentry", "fe_billentity", "fe_filter_tag", key);
                break;
            }
            case "ie_destbillprop": 
            case "ae_destbillprop": 
            case "fe_destbillprop": {
                this.showSelectEntityProps(entityNumber, key, Boolean.TRUE, Boolean.TRUE, EntityPropTypeEnum.getBillType());
                break;
            }
            case "be_balselprop": {
                this.showBillBalSelectProps(dataEntity, key);
                break;
            }
        }
    }

    private void showBillBalSelectProps(DynamicObject dataEntity, String actionId) {
        DynamicObject billBalEntity = dataEntity.getDynamicObject("billbalentity");
        if (billBalEntity == null) {
            return;
        }
        DynamicObject selectEntry = this.getSelectEntry("billbalentry");
        if (selectEntry == null) {
            return;
        }
        String balEntityNumber = billBalEntity.getString(BILL_NUMBER);
        String balProp = selectEntry.getString("be_balprop");
        BillBalanceMapEnum balPropEnum = BillBalanceMapEnum.getEnum((String)balProp);
        if (balPropEnum == null) {
            this.showSelectEntityProps(balEntityNumber, actionId, Boolean.FALSE, Boolean.FALSE, new EntityPropTypeEnum[0]);
            return;
        }
        switch (balPropEnum) {
            case ID: {
                this.showSelectEntityProps(balEntityNumber, actionId, Boolean.FALSE, Boolean.FALSE, EntityPropTypeEnum.getBillType());
                break;
            }
            case ORG: {
                this.showSelectEntityProps(balEntityNumber, actionId, Boolean.FALSE, Boolean.FALSE, EntityPropTypeEnum.ORG);
                break;
            }
            case CURRENCY: {
                this.showSelectEntityProps(balEntityNumber, actionId, Boolean.FALSE, Boolean.FALSE, EntityPropTypeEnum.CURRENCY);
                break;
            }
            case BIZDATE: {
                this.showSelectEntityProps(balEntityNumber, actionId, Boolean.FALSE, Boolean.FALSE, EntityPropTypeEnum.DATE);
                break;
            }
            case AMOUNT: 
            case DEBITAMOUNT: 
            case CREDITAMOUNT: 
            case LSTBALANCE: 
            case VALIBALANCE: 
            case FREEZEBALANCE: {
                this.showSelectEntityProps(balEntityNumber, actionId, Boolean.FALSE, Boolean.FALSE, EntityPropTypeEnum.AMOUNT);
                break;
            }
        }
    }

    private void showSelectEntityProps(String entityNumber, String actionId, boolean includeEntity, boolean includeRefProp, EntityPropTypeEnum ... propTypes) {
        SelectEntityPropParam param = SelectEntityPropParam.build((String)entityNumber, (IFormView)this.getView(), (IFormPlugin)this, (String)actionId).setIncludeEntity(includeEntity).setMultiSelect(false).setIncludeRefProp(includeRefProp).setPropTypes(propTypes).setIncludePKField(true);
        SelectEntityPropHelper.showSelectProps((SelectEntityPropParam)param);
    }

    private void showEntitySelectProps(String entryName, String billEntityName, String actionId, EntityPropTypeEnum ... propTypes) {
        String entityNumber = this.getSelectEntityNumber(entryName, billEntityName);
        if (entityNumber != null) {
            this.showSelectEntityProps(entityNumber, actionId, Boolean.TRUE, Boolean.TRUE, propTypes);
        }
    }

    private String getSelectEntityNumber(String entryName, String billEntityName) {
        DynamicObject selectEntry = this.getSelectEntry(entryName);
        if (selectEntry == null) {
            return null;
        }
        DynamicObject billEntity = selectEntry.getDynamicObject(billEntityName);
        return billEntity != null ? billEntity.getString(BILL_NUMBER) : null;
    }

    private DynamicObject getSelectEntry(String entryName) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryName);
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return null;
        }
        DynamicObject entity = this.getModel().getDataEntity(true);
        return (DynamicObject)entity.getDynamicObjectCollection(entryName).get(selectRows[0]);
    }

    private void setEntryValue(String entryName, String entryPropName, String value) {
        DynamicObject selectEntry = this.getSelectEntry(entryName);
        if (selectEntry != null) {
            selectEntry.set(entryPropName, (Object)value);
        }
        this.getView().updateView(entryName);
    }

    public void afterBindData(EventObject e) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.initBillConfigProp(dataEntity);
    }

    public void beforeBindData(EventObject e) {
        this.initBillFilterGrid();
        IDataModel model = this.getModel();
        EntityFilterHelper.loadFilterGrid((IFormView)this.getView(), (String)FILTERGRID, (String)((String)model.getValue("billfilter_tag")));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "save": {
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRID);
                FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
                IDataModel model = this.getModel();
                model.setValue("billfilter_tag", (Object)SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition()));
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "querybalance": {
                this.showBillBalanceListForm();
                break;
            }
        }
    }

    private void showBillBalanceListForm() {
        Long selectedId = (Long)this.getModel().getValue("id");
        if (selectedId == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)selectedId);
        DynamicObject billDim = QueryServiceHelper.queryOne((String)"fcs_billdimbalance", (String)"billbalentity.number", (QFilter[])qFilter.toArray());
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)billDim.getString("billbalentity.number"), (boolean)false, (int)0, (boolean)false);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "ie_srcbillprop": 
            case "ie_destbillprop": 
            case "ie_bizdateprop": 
            case "ie_amountprop": {
                this.setEntryValue("initamountentry", actionId, SelectEntityPropHelper.getSelectPropValues((String)((String)returnData)));
                break;
            }
            case "ie_filterset": {
                this.updateEntryFilter(returnData, "initamountentry", "ie_billentity", "ie_filterset", "ie_filter_tag");
                break;
            }
            case "ae_srcbillprop": 
            case "ae_destbillprop": 
            case "ae_bizdateprop": 
            case "ae_amountprop": {
                this.setEntryValue("amountentry", actionId, SelectEntityPropHelper.getSelectPropValues((String)((String)returnData)));
                break;
            }
            case "ae_filterset": {
                this.updateEntryFilter(returnData, "amountentry", "ae_billentity", "ae_filterset", "ae_filter_tag");
                break;
            }
            case "fe_srcbillprop": 
            case "fe_destbillprop": 
            case "fe_bizdateprop": 
            case "fe_amountprop": 
            case "fe_freezetypeprop": {
                this.setEntryValue("freezeentry", actionId, SelectEntityPropHelper.getSelectPropValues((String)((String)returnData)));
                break;
            }
            case "fe_filterset": {
                this.updateEntryFilter(returnData, "freezeentry", "fe_billentity", "fe_filterset", "fe_filter_tag");
                break;
            }
            case "be_balselprop": {
                this.setEntryValue("billbalentry", actionId, SelectEntityPropHelper.getSelectPropValues((String)((String)returnData)));
                break;
            }
        }
    }

    private void updateEntryFilter(Object returnData, String entryName, String billEntityName, String filterSetName, String filterValueName) {
        DynamicObject selectEntry = this.getSelectEntry(entryName);
        if (selectEntry == null) {
            return;
        }
        String filter = returnData.toString();
        selectEntry.set(filterValueName, (Object)filter);
        String entityName = selectEntry.getDynamicObject(billEntityName).getString(BILL_NUMBER);
        this.setEntryValue(entryName, filterSetName, EntityFilterHelper.getFilterGridFilter((String)filter, (String)entityName).toString());
        this.getView().updateView(entryName);
    }

    private void showBillFilterForm(String entryName, String billNumber, String filterTagName, String actionId) {
        DynamicObject selectEntry = this.getSelectEntry(entryName);
        if (selectEntry == null) {
            return;
        }
        String entityNumber = selectEntry.getDynamicObject(billNumber).getString(BILL_NUMBER);
        EntityFilterHelper.showBillFilterForm((String)entityNumber, (String)selectEntry.getString(filterTagName), (IFormView)this.getView(), (IFormPlugin)this, (String)actionId);
    }
}

