/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.billbalance;

import java.util.Arrays;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class BillDimBalanceListPlugin
extends AbstractTmcBillBaseList {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"querybalance", "updatebalance"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "updatebalance": {
                this.showRebuildBalanceForm();
                break;
            }
        }
    }

    private void showRebuildBalanceForm() {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setStatus(OperationStatus.ADDNEW);
        parameter.setFormId("fcs_rebuildbillbalance");
        QFilter qFilter = new QFilter("id", "=", (Object)selectedId);
        String selectFields = String.join((CharSequence)",", Arrays.asList("billentity.number", "billfilter_tag"));
        DynamicObject billDim = QueryServiceHelper.queryOne((String)"fcs_billdimbalance", (String)selectFields, (QFilter[])qFilter.toArray());
        parameter.setCustomParam("billentity", (Object)billDim.getString("billentity.number"));
        parameter.setCustomParam("billfilter_tag", (Object)billDim.getString("billfilter_tag"));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rebuildbalance"));
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (formOperate.getOperateKey()) {
            case "querybalance": {
                this.showBillBalanceListForm();
                break;
            }
        }
    }

    private void showBillBalanceListForm() {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)selectedId);
        DynamicObject billDim = QueryServiceHelper.queryOne((String)"fcs_billdimbalance", (String)"billbalentity.number", (QFilter[])qFilter.toArray());
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)billDim.getString("billbalentity.number"), (boolean)true, (int)0, (boolean)false);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        switch (evt.getActionId()) {
            case "rebuildbalance": {
                if (EmptyUtil.isEmpty((Object)returnData)) {
                    return;
                }
                this.rebuildBillBalance((Map)returnData);
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void rebuildBillBalance(Map<String, Object> returnData) {
        String beginDate = (String)returnData.get("beginDate");
        String endDate = (String)returnData.get("endDate");
        String selBillIds = (String)returnData.get("billIds");
        Long selectedId = this.getSelectedId();
        OperateOption option = OperateOption.create();
        option.setVariableValue("beginDate", beginDate);
        option.setVariableValue("endDate", endDate);
        option.setVariableValue("billIds", selBillIds);
        TmcOperateServiceHelper.execOperate((String)"rebuildbalance", (String)"fcs_billdimbalance", (Object[])new Long[]{selectedId}, (OperateOption)option);
    }
}

