/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.billbalance;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.selectprop.EntityFilterHelper;

public class RebuildBillBalancePlugin
extends AbstractFormPlugin {
    private static final String PROP_SELBILL = "selbill";
    private static final String PARAM_SELBILLID = "selbillid";
    private static final String OP_OK = "ok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PROP_SELBILL, OP_OK});
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (!(source instanceof Control)) {
            return;
        }
        String key = ((Control)evt.getSource()).getKey();
        if (PROP_SELBILL.equals(key)) {
            this.openBillForm();
        }
    }

    private void openBillForm() {
        FormShowParameter param = this.getView().getFormShowParameter();
        Map customParams = param.getCustomParams();
        String billEntity = (String)customParams.get("billentity");
        ListShowParameter paramter = ShowFormHelper.createShowListForm((String)billEntity, (boolean)true);
        String billFilterTag = (String)customParams.get("billfilter_tag");
        if (EmptyUtil.isNoEmpty((String)billFilterTag)) {
            QFilter billFilter = EntityFilterHelper.getFilterGridFilter((String)billFilterTag, (String)billEntity);
            paramter.getListFilterParameter().setFilter(billFilter);
        }
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, PROP_SELBILL);
        paramter.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)paramter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        if (PROP_SELBILL.equals(actionId)) {
            ListSelectedRowCollection selectedRow = (ListSelectedRowCollection)evt.getReturnData();
            if (EmptyUtil.isEmpty((Collection)selectedRow)) {
                return;
            }
            List billIds = selectedRow.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            List billNos = selectedRow.stream().map(d -> EmptyUtil.isNoEmpty((String)d.getBillNo()) ? d.getBillNo() : d.getNumber()).collect(Collectors.toList());
            String selBillIds = billIds.stream().map(Object::toString).collect(Collectors.joining(","));
            String selBillNos = String.join((CharSequence)",", billNos);
            this.getPageCache().put(PARAM_SELBILLID, selBillIds);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)PROP_SELBILL, (Object)selBillNos);
            this.getView().updateView();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult opResult = args.getOperationResult();
        if (opResult == null || !opResult.isSuccess()) {
            return;
        }
        if (OP_OK.equals(args.getOperateKey())) {
            Date endDate;
            Date beginDate;
            HashMap<String, String> returnData = new HashMap<String, String>();
            String selBillId = this.getPageCache().get(PARAM_SELBILLID);
            if (EmptyUtil.isNoEmpty((String)selBillId)) {
                returnData.put("billIds", selBillId);
            }
            if ((beginDate = (Date)this.getModel().getValue("beginDate")) != null) {
                returnData.put("beginDate", DateUtils.formatString((Date)beginDate, (String)"yyyy-MM-dd"));
            }
            if ((endDate = (Date)this.getModel().getValue("endDate")) == null) {
                endDate = DateUtils.getCurrentDate();
            }
            returnData.put("endDate", DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd"));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

