/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.billversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.helper.ExpressionFromHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BillVersionSetEdit
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControlAndChangeProp();
        this.setControlDetail();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        this.initControlAndChangeProp();
        switch (key) {
            case "bizentity": {
                this.initControlAndChangeProp();
                this.clearFieldInfo();
                break;
            }
            case "changeprop": {
                this.setShowFieldsDesc();
                break;
            }
            case "controlprop": {
                this.setControlDetail();
                this.setControlPropName();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"controldetail", null);
                break;
            }
            case "controldetail": {
                this.setControlDetailName();
            }
        }
    }

    private void initControlAndChangeProp() {
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizEntity)) {
            String billNumber = bizEntity.getString("number");
            Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)billNumber, (boolean)true, (boolean)true, (String[])new String[0]);
            ComboEdit controlPropComboEdit = (ComboEdit)this.getControl("controlprop");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            List propList = properties.stream().filter(s -> s instanceof ComboProp).map(IMetadata::getName).collect(Collectors.toList());
            ArrayList<ComboItem> controlPropComboItemList = new ArrayList<ComboItem>(propList.size());
            for (String prop : propList) {
                LocaleString displayName = (LocaleString)fieldColumn.get(prop);
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(displayName);
                comboItem.setValue(prop);
                controlPropComboItemList.add(comboItem);
            }
            controlPropComboEdit.setComboItems(controlPropComboItemList);
            ComboEdit changePropComboEdit = (ComboEdit)this.getControl("changeprop");
            ArrayList<ComboItem> changePropComboItemList = new ArrayList<ComboItem>(fieldColumn.size());
            HashMap<String, String> cacheChangeProp = new HashMap<String, String>(fieldColumn.size());
            for (Map.Entry entry : fieldColumn.entrySet()) {
                String key = (String)entry.getKey();
                LocaleString displayName = (LocaleString)entry.getValue();
                displayName = this.getNewDisplayName(key, displayName, properties);
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(displayName);
                comboItem.setValue(key);
                changePropComboItemList.add(comboItem);
                cacheChangeProp.put(key, displayName.getLocaleValue());
                this.getPageCache().put("changeprop", SerializationUtils.toJsonString(cacheChangeProp));
            }
            changePropComboEdit.setComboItems(changePropComboItemList);
        }
    }

    private void clearFieldInfo() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"changeprop", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"controlprop", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"controldetail", null);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"showfieldsdesc", null);
    }

    private void setShowFieldsDesc() {
        String changeProp = (String)this.getModel().getValue("changeprop");
        if (EmptyUtil.isEmpty((String)changeProp)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"showfieldsdesc", null);
            return;
        }
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        String billNumber = bizEntity.getString("number");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        Map fieldColumn = ExpressionFromHelper.getFieldColumn((String)billNumber, (boolean)true, (boolean)true, (String[])new String[0]);
        String[] selectFields = changeProp.split(",");
        String join = Arrays.stream(selectFields).filter(EmptyUtil::isNoEmpty).map(s -> this.getNewDisplayName((String)s, (LocaleString)fieldColumn.get(s), properties).toString()).collect(Collectors.joining(";"));
        this.getModel().setValue("showfieldsdesc", (Object)join);
    }

    private void setControlDetail() {
        DynamicObject bizEntity = (DynamicObject)this.getModel().getValue("bizentity");
        if (EmptyUtil.isNoEmpty((DynamicObject)bizEntity)) {
            String controlProp = (String)this.getModel().getValue("controlprop");
            String billNumber = bizEntity.getString("number");
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)controlProp);
            List comboItemsList = ((ComboProp)property).getComboItems();
            ComboEdit controlDetailComboEdit = (ComboEdit)this.getControl("controldetail");
            ArrayList<ComboItem> controlDetailItemList = new ArrayList<ComboItem>(comboItemsList.size());
            HashMap<String, String> cacheControlDetail = new HashMap<String, String>(comboItemsList.size());
            for (ValueMapItem item : comboItemsList) {
                String key = item.getValue();
                LocaleString name = item.getName();
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(name);
                comboItem.setValue(key);
                controlDetailItemList.add(comboItem);
                cacheControlDetail.put(key, name.getLocaleValue());
                this.getPageCache().put("controldetail", SerializationUtils.toJsonString(cacheControlDetail));
            }
            controlDetailComboEdit.setComboItems(controlDetailItemList);
        }
    }

    private void setControlPropName() {
        String controlProp = (String)this.getModel().getValue("controlprop");
        if (EmptyUtil.isNoEmpty((String)controlProp)) {
            String cacheChangeProp = this.getPageCache().get("changeprop");
            Map changePropMap = (Map)SerializationUtils.fromJsonString((String)cacheChangeProp, Map.class);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"controlpropname", changePropMap.get(controlProp));
        }
    }

    private void setControlDetailName() {
        String controlDetail = (String)this.getModel().getValue("controldetail");
        if (EmptyUtil.isNoEmpty((String)controlDetail)) {
            String cacheControlDetail = this.getPageCache().get("controldetail");
            Map controlDetailMap = (Map)SerializationUtils.fromJsonString((String)cacheControlDetail, Map.class);
            String[] selectFields = controlDetail.split(",");
            String join = Arrays.stream(selectFields).filter(EmptyUtil::isNoEmpty).map(controlDetailMap::get).collect(Collectors.joining(";"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"controldetailname", (Object)join);
        }
    }

    private LocaleString getNewDisplayName(String key, LocaleString displayName, DataEntityPropertyCollection properties) {
        String[] split;
        IDataEntityProperty property;
        if (key.contains(".") && EmptyUtil.isNoEmpty((Object)(property = (IDataEntityProperty)properties.get((Object)(split = key.split("\\."))[0])))) {
            String localeValue = displayName.getLocaleValue();
            String entityName = property.getDisplayName().getLocaleValue();
            displayName = new LocaleString(entityName + "." + localeValue);
        }
        return displayName;
    }
}

