/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.billversion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.PropertyTypeEnum;

public class ChangeComBoxEdit
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            FormShowParameter fp = this.getView().getFormShowParameter();
            String propType = (String)fp.getCustomParam("propType");
            if (StringUtils.isBlank((CharSequence)propType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comboxvalue", "datevalue", "datetimevalue", "mulcomboxvalue"});
                return;
            }
            if (PropertyTypeEnum.COM_BOX_PROP.getValue().equals(propType) || PropertyTypeEnum.BOOLEAN_PROP.getValue().equals(propType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"comboxvalue"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"datevalue", "datetimevalue", "mulcomboxvalue"});
                String comBoxValue = (String)fp.getCustomParam("comBoxValue");
                ArrayList<ComboItem> items = new ArrayList<ComboItem>();
                String[] values = comBoxValue.split(",");
                HashMap<String, String> recordMap = new HashMap<String, String>(values.length);
                for (String value : values) {
                    String[] kv = value.split(":");
                    if (kv.length < 2) continue;
                    ComboItem a = new ComboItem(new LocaleString(kv[1]), kv[0]);
                    items.add(a);
                    recordMap.put(kv[0], kv[1]);
                }
                ComboEdit comBo = (ComboEdit)this.getControl("comboxvalue");
                comBo.setComboItems(items);
                this.getPageCache().put("recordMap", SerializationUtils.toJsonString(recordMap));
            } else if (PropertyTypeEnum.DATE_PROP.getValue().equals(propType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comboxvalue", "datetimevalue", "mulcomboxvalue"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"datevalue"});
            } else if (PropertyTypeEnum.DATE_TIME_PROP.getValue().equals(propType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comboxvalue", "datevalue", "mulcomboxvalue"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"datetimevalue"});
            } else if (PropertyTypeEnum.MUL_COM_BOX_PROP.getValue().equals(propType)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"comboxvalue", "datevalue", "datetimevalue"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"mulcomboxvalue"});
                String comBoxValue = (String)fp.getCustomParam("comBoxValue");
                ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
                ComboEdit values = comBoxValue.split(",");
                HashMap<String, String> recordMap = new HashMap<String, String>(((String[])values).length);
                for (String value : values) {
                    String[] kv = value.split(":");
                    ComboItem a = new ComboItem(new LocaleString(kv[1]), kv[0]);
                    items.add(a);
                    recordMap.put(kv[0], kv[1]);
                }
                ComboEdit comBo = (ComboEdit)this.getControl("mulcomboxvalue");
                comBo.setComboItems(items);
                this.getPageCache().put("recordMap", SerializationUtils.toJsonString(recordMap));
            }
            this.getView().updateView();
        }
        catch (Exception exception) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"comboxvalue", "datevalue", "datetimevalue", "mulcomboxvalue"});
            throw new KDBizException(ResManager.loadKDString((String)"\u5f39\u7a97\u663e\u793a\u5f02\u5e38\u3002", (String)"ChangeComBoxEdit_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnDefValue();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("comboxvalue".equals(key) || "mulcomboxvalue".equals(key)) {
            this.getModel().setValue("defaultvalue", newValue);
            String recordMapStr = this.getPageCache().get("recordMap");
            Map recordMap = (Map)SerializationUtils.fromJsonString((String)recordMapStr, Map.class);
            String collect = Arrays.stream(String.valueOf(newValue).split(",")).filter(EmptyUtil::isNoEmpty).map(recordMap::get).collect(Collectors.joining(";"));
            this.getModel().setValue("defaultname", (Object)collect);
        } else if ("datevalue".equals(key)) {
            this.getModel().setValue("defaultvalue", (Object)DateUtils.formatString((Date)((Date)newValue), (String)"yyyy-MM-dd"));
        } else if ("datetimevalue".equals(key)) {
            this.getModel().setValue("defaultvalue", (Object)DateUtils.formatString((Date)((Date)newValue), (String)"yyyy-MM-dd HH:mm:ss"));
        }
    }

    private void returnDefValue() {
        String defaultValue = (String)this.getModel().getValue("defaultvalue");
        if (StringUtils.isBlank((CharSequence)defaultValue) || StringUtils.isBlank((CharSequence)defaultValue.replace(",", ""))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9ed8\u8ba4\u503c\u3002", (String)"ChangeComBoxEdit_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().remove("recordMap");
        HashMap<String, String> returnData = new HashMap<String, String>(4);
        returnData.put("defaultvalue", defaultValue.startsWith(",") ? defaultValue.substring(1, defaultValue.length() - 1) : defaultValue);
        returnData.put("defaultname", (String)this.getModel().getValue("defaultname"));
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }
}

