/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.faketrade;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.enums.RiskLevelEnum;
import kd.tmc.fcs.common.enums.RiskResultEnum;
import kd.tmc.fcs.common.helper.LicenseCheckHelper;
import kd.tmc.fcs.common.helper.RiskServiceHelper;

public class RiskFloatFormPlugin
extends AbstractFormPlugin {
    private static final Set<String> BTN_GROUP = new HashSet<String>(Arrays.asList("general", "idi", "predict", "fileanalysis"));
    private static final String BTN_GENERAL = "general";
    private static final String BTN_IDI = "idi";
    private static final String BTN_PREDICT = "predict";
    private static final String BTN_NODATA = "/icons/pc/state/notdelay_notstart.png";
    private static final String BTN_PASS = "/icons/pc/state/success_28_28.png";
    private static final String BTN_UNPASS = "/icons/pc/state/warning34_34.png";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        LicenseCheckResult licenseCheckResult = LicenseCheckHelper.checkUserInProGPTFas();
        if (!licenseCheckResult.getHasLicense().booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"licenseinfoflex"});
            Label labelap = (Label)this.getControl("labelap");
            labelap.setText(licenseCheckResult.getMsg());
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"licenseinfoflex"});
            this.updateButtonFlex();
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_GENERAL, BTN_IDI, BTN_PREDICT});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (BTN_GROUP.contains(key)) {
            this.checkControl(key);
        }
    }

    private void checkControl(String key) {
        this.getPageCache().put("checked", key);
        Map<String, Object> checkProperties = this.changeBorder("#2A71F5", "#E0EFFF");
        Map<String, Object> unCheckProperties = this.changeBorder("#FFFFFF", "#FFFFFF");
        this.getView().updateControlMetadata(key, checkProperties);
        this.getView().setVisible(Boolean.TRUE, new String[]{"flex_" + key});
        HashSet<String> unChecks = new HashSet<String>(BTN_GROUP);
        unChecks.remove(key);
        for (String unCheck : unChecks) {
            this.getView().updateControlMetadata(unCheck, unCheckProperties);
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_" + unCheck});
        }
    }

    private Map<String, Object> changeBorder(String borderColor, String BackColor) {
        HashMap<String, Object> propertiesMap = new HashMap<String, Object>(16);
        HashMap style = new HashMap(16);
        if (!StringUtils.isEmpty((String)borderColor)) {
            HashMap<String, String> border = new HashMap<String, String>(16);
            border.put("b", "1px_solid_" + borderColor);
            border.put("l", "1px_solid_" + borderColor);
            border.put("r", "1px_solid_" + borderColor);
            border.put("t", "1px_solid_" + borderColor);
            style.put("b", border);
        }
        propertiesMap.put("s", style);
        propertiesMap.put("bc", BackColor);
        return propertiesMap;
    }

    private void updateButtonFlex() {
        String tip;
        String billId = (String)this.getView().getFormShowParameter().getCustomParam("bizDataId");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entityNumber");
        QFilter filter_enable = new QFilter("enable", "=", (Object)"1");
        QFilter filter_entity = new QFilter("billentity", "=", (Object)entityNumber);
        DynamicObject risk = QueryServiceHelper.queryOne((String)"fcs_risktrade_warn", (String)"aiwarn,smartinsight,dataanalysis,riskscreening", (QFilter[])new QFilter[]{filter_enable, filter_entity});
        Boolean isAiWarn = risk.getBoolean("aiwarn");
        Boolean isSmartInsight = risk.getBoolean("smartinsight");
        Boolean dataAnalysis = risk.getBoolean("dataanalysis");
        this.getView().setVisible(isAiWarn, new String[]{BTN_GENERAL});
        this.getView().setVisible(isSmartInsight, new String[]{BTN_IDI});
        this.getView().setVisible(dataAnalysis, new String[]{BTN_PREDICT});
        this.getView().setVisible(isAiWarn, new String[]{"labelequal"});
        this.getView().setVisible(Boolean.valueOf(isAiWarn != false && isSmartInsight != false && dataAnalysis != false), new String[]{"labeladd"});
        this.getView().setEnable(isAiWarn, new String[]{BTN_GENERAL});
        this.getView().setEnable(isSmartInsight, new String[]{BTN_IDI});
        this.getView().setEnable(dataAnalysis, new String[]{BTN_PREDICT});
        if (isAiWarn.booleanValue() && isSmartInsight.booleanValue() && dataAnalysis.booleanValue()) {
            this.checkControl(BTN_GENERAL);
        } else if (isSmartInsight.booleanValue()) {
            this.checkControl(BTN_IDI);
        } else if (dataAnalysis.booleanValue()) {
            this.checkControl(BTN_PREDICT);
        }
        boolean passSmartInsight = true;
        if (isSmartInsight.booleanValue()) {
            DynamicObject bizBill = BusinessDataServiceHelper.newDynamicObject((String)entityNumber);
            bizBill.set("id", (Object)billId);
            String result = (String)DispatchServiceHelper.invokeBizService((String)"data", (String)BTN_IDI, (String)"IDISchemaParallelService", (String)"executeSchema", (Object[])new Object[]{bizBill, this.getView().getPageId()});
            if (StringUtils.isNotEmpty((String)result)) {
                Map resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
                String status = (String)resultMap.get("status");
                Button idi = (Button)this.getControl(BTN_IDI);
                if ("success".equalsIgnoreCase(status)) {
                    idi.setUrl(BTN_PASS);
                } else {
                    idi.setUrl(BTN_UNPASS);
                    passSmartInsight = false;
                }
            }
        }
        String msg = "";
        boolean passDataAnalysis = true;
        if (dataAnalysis.booleanValue()) {
            DynamicObject oneResult;
            Long errorDataId = (Long)this.getView().getFormShowParameter().getCustomParam("errorDataId");
            DynamicObject riskscreening = null;
            if (errorDataId != null) {
                oneResult = BusinessDataServiceHelper.loadSingle((Object)errorDataId, (String)"fcs_errordata");
            } else {
                Long riskscreeningId = risk.getLong("riskscreening");
                riskscreening = BusinessDataServiceHelper.loadSingle((Object)riskscreeningId, (String)"fcs_riskscreening");
                Long bizBillId = Long.parseLong(billId);
                Map results = RiskServiceHelper.invokeProposal(Collections.singletonList(bizBillId), (DynamicObject)riskscreening, (Boolean)true);
                oneResult = (DynamicObject)results.get(bizBillId);
            }
            String resultType = null != oneResult ? oneResult.getString("result") : RiskResultEnum.NORMAL_TRADE.getValue();
            Button predict = (Button)this.getControl(BTN_PREDICT);
            if (RiskResultEnum.NORMAL_TRADE.getValue().equals(resultType)) {
                predict.setUrl(BTN_PASS);
            } else {
                predict.setUrl(BTN_UNPASS);
            }
            IDataModel model = this.getModel();
            if (null != oneResult && !EmptyUtil.isEmpty((DynamicObjectCollection)oneResult.getDynamicObjectCollection("entry"))) {
                DynamicObjectCollection entry = oneResult.getDynamicObjectCollection("entry");
                passDataAnalysis = false;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"successap"});
                StringBuilder sb = new StringBuilder();
                model.deleteEntryData("entryentity");
                model.batchCreateNewEntryRow("entryentity", entry.size());
                CardEntry cardEntry = (CardEntry)this.getControl("entryentity");
                for (int i = 0; i < entry.size(); ++i) {
                    sb.append(((DynamicObject)entry.get(i)).getString("typename")).append('\u3001');
                    model.setValue("texthead", (Object)((DynamicObject)entry.get(i)).getString("typename"), i);
                    DynamicObjectCollection subEntry = ((DynamicObject)entry.get(i)).getDynamicObjectCollection("subentry");
                    int itemShow = 0;
                    int j = 0;
                    while (j < subEntry.size()) {
                        model.setValue("item" + j, (Object)((DynamicObject)subEntry.get(j)).getString("errordesc"), i);
                        model.setValue("itemdetail" + j, (Object)((DynamicObject)subEntry.get(j)).getString("errordescdetail"), i);
                        itemShow = j++;
                    }
                    for (int k = itemShow + 1; k < 5; ++k) {
                        cardEntry.setChildVisible(false, i, new String[]{"carditem" + k, "itemdetail" + k});
                    }
                }
                if (sb.indexOf("\u3001") != -1) {
                    sb.deleteCharAt(sb.lastIndexOf("\u3001"));
                }
                msg = sb.toString();
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"successap"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entryentity"});
                predict.setUrl(BTN_PASS);
                if (null == riskscreening) {
                    riskscreening = BusinessDataServiceHelper.loadSingle((Object)risk.getLong("riskscreening"), (String)"fcs_riskscreening");
                }
                if (null != riskscreening) {
                    DynamicObjectCollection entry = riskscreening.getDynamicObjectCollection("entry");
                    model.deleteEntryData("successentry");
                    model.batchCreateNewEntryRow("successentry", entry.size());
                    CardEntry cardEntry = (CardEntry)this.getControl("successentry");
                    for (int i = 0; i < entry.size(); ++i) {
                        List subEntry = ((DynamicObject)entry.get(i)).getDynamicObjectCollection("subentry").stream().filter(t -> t.getBoolean("subenable")).collect(Collectors.toList());
                        if (subEntry.isEmpty()) {
                            cardEntry.setChildVisible(false, i, new String[]{"cardentryrowap1"});
                            continue;
                        }
                        model.setValue("stexthead", (Object)((DynamicObject)entry.get(i)).getString("successres"), i);
                        int itemShow = 0;
                        int j = 0;
                        while (j < subEntry.size()) {
                            model.setValue("sitem" + j, (Object)((DynamicObject)subEntry.get(j)).getString("successdesc"), i);
                            itemShow = j++;
                        }
                        for (int k = itemShow + 1; k < 5; ++k) {
                            cardEntry.setChildVisible(false, i, new String[]{"scarditem" + k});
                        }
                    }
                    this.getView().updateView("successentry");
                }
            }
        }
        this.getView().updateView("entryentity");
        RiskLevelEnum riskLevelEnum = RiskLevelEnum.LOW_RISK;
        if (passSmartInsight && passDataAnalysis) {
            tip = ResManager.loadKDString((String)"\u7531\u4e8e\u667a\u80fd\u6d1e\u5bdf\u3001\u5927\u6570\u636e\u5206\u6790\u672a\u53d1\u73b0\u5f02\u5e38\uff0c\u672c\u5355\u636e\u4e3a\u4f4e\u98ce\u9669\u5355\u636e\u3002", (String)"RiskFloatFromPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]);
        } else if (passSmartInsight) {
            riskLevelEnum = RiskLevelEnum.MEDIUM_RISK;
            tip = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u6240\u6709\u667a\u80fd\u6d1e\u5bdf\u68c0\u67e5\u9879\u65e0\u5f02\u5e38\uff0c\u4f46\u662f\u7531\u4e8e\u5b58\u5728%s\u7b49\u56e0\u7d20\uff0c\u672c\u5355\u636e\u4e3a\u4e2d\u98ce\u9669\u5355\u636e\u3002", (String)"RiskFloatFromPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[]{msg});
        } else if (passDataAnalysis) {
            riskLevelEnum = RiskLevelEnum.HIGH_RISK;
            tip = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u90e8\u5206\u667a\u80fd\u6d1e\u5bdf\u68c0\u67e5\u9879\u5b58\u5728\u5f02\u5e38\uff0c\u672c\u5355\u636e\u4e3a\u9ad8\u98ce\u9669\u5355\u636e\u3002", (String)"RiskFloatFromPlugin_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]);
        } else {
            riskLevelEnum = RiskLevelEnum.HIGH_RISK;
            tip = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u5b58\u5728\u90e8\u5206\u667a\u80fd\u6d1e\u5bdf\u68c0\u67e5\u9879\u5b58\u5728\u5f02\u5e38\uff0c\u6b64\u5916\uff0c\u7531\u4e8e\u5b58\u5728%s\u7b49\u56e0\u7d20\uff0c\u672c\u5355\u636e\u4e3a\u9ad8\u98ce\u9669\u5355\u636e\u3002", (String)"RiskFloatFromPlugin_3", (String)"tmc-fcs-formplugin", (Object[])new Object[]{msg});
        }
        Label label = (Label)this.getControl("predict_end");
        label.setText(tip);
        this.updateContent(riskLevelEnum);
    }

    private void updateContent(RiskLevelEnum riskLevelEnum) {
        Image riskIcon = (Image)this.getControl("risk_icon");
        riskIcon.setUrl(riskLevelEnum.getBackgroundImgKey());
        Label factorText = (Label)this.getControl("risk_label");
        factorText.setText(riskLevelEnum.getText());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("fc", riskLevelEnum.getColor());
        this.getView().updateControlMetadata("risk_label", properties);
    }
}

