/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.home;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;

public class CoverRatePieChart
extends AbstractFormPlugin
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (source.getKey().equals("piechartap")) {
            String name = ((ChartClickEvent)evt).getName();
            this.showBillList(name);
        }
    }

    private void showBillList(String name) {
        QFilter qFilter = null;
        if (this.getCoverName().equals(name)) {
            Set coverbill = (Set)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("coverbill")), Set.class);
            qFilter = new QFilter("id", "in", (Object)coverbill);
        } else if (this.getNoCoverName().equals(name)) {
            Set noCoverbill = (Set)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("nocoverbill")), Set.class);
            qFilter = new QFilter("id", "in", (Object)noCoverbill);
        }
        if (qFilter != null) {
            String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("number");
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)entityNumber, (boolean)false);
            listShowParameter.getListFilterParameter().setFilter(qFilter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String entityNumber = customParams.get("number").toString();
        String entityName = customParams.get("name").toString();
        Integer total = (Integer)customParams.get("totalcount");
        Integer cover = (Integer)customParams.get("covercount");
        this.getModel().setValue("textfield", (Object)entityName);
        this.getView().updateView("textfield");
        PieChart pieChart = (PieChart)this.getControl("piechartap");
        pieChart.createSeries(entityNumber);
        pieChart.clearData();
        pieChart.setShowTooltip(true);
        pieChart.setShowLegend(false);
        Integer noCover = total - cover;
        long rate = total == 0 ? 0L : BigDecimal.valueOf(cover.intValue()).divide(BigDecimal.valueOf(total.intValue()), 3, 4).movePointRight(2).setScale(0, 1).longValue();
        pieChart.setTitlePropValue("text", (Object)(rate + "%"));
        pieChart.setTitlePropValue("top", (Object)"center");
        pieChart.setTitlePropValue("left", (Object)"center");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("color", "#000000");
        map.put("fontSize", 40);
        map.put("fontWeight", "normal");
        pieChart.setTitlePropValue("textStyle", map);
        PieSeries series = pieChart.createPieSeries(ResManager.loadKDString((String)"\u8986\u76d6\u7387", (String)"CoverRatePieChart_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        ItemValue[] data = new ItemValue[2];
        ItemValue data1 = new ItemValue(this.getCoverName(), (Number)cover, "#276ff5");
        ItemValue data2 = new ItemValue(this.getNoCoverName(), (Number)noCover, "#ff991c");
        data[0] = data1;
        data[1] = data2;
        HashMap<String, Boolean> label = new HashMap<String, Boolean>(4);
        label.put("show", false);
        series.setPropValue("label", label);
        series.setRadius("50%", "70%");
        series.setCenter("50%", "50%");
        series.setData(data);
        pieChart.refresh();
    }

    private String getCoverName() {
        return ResManager.loadKDString((String)"\u5df2\u8fdb\u884c\u652f\u4ed8\u9632\u91cd\u6821\u9a8c", (String)"CoverRatePieChart_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]);
    }

    private String getNoCoverName() {
        return ResManager.loadKDString((String)"\u672a\u53c2\u4e0e\u652f\u4ed8\u9632\u91cd\u6821\u9a8c", (String)"CoverRatePieChart_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]);
    }
}

