/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.home;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.property.PayAccesslProp;

public class PayRepeatColumnCardPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_refresh"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.drawChart();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btn_refresh".equals(key)) {
            this.drawChart();
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map entity = TmcDataServiceHelper.loadFromCache((String)"fcs_payaccess_blacklist", (QFilter[])new QFilter[]{new QFilter("destentity", "in", (Object)PayAccesslProp.BLACK_LIST)});
        this.getModel().setValue("checkentity", (Object)entity);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        switch (propKey = e.getProperty().getName()) {
            case "checkentity": 
            case "time": {
                this.drawChart();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName = event.getProperty().getName();
        if ("checkentity".equals(propName)) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            ListShowParameter sp = (ListShowParameter)event.getFormShowParameter();
            sp.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private void setxNames(List<String> entityList, List<String> xNames, Map<String, String> entityNameMap) {
        DynamicObjectCollection checkentitys = (DynamicObjectCollection)this.getModel().getValue("checkentity");
        for (DynamicObject entity : checkentitys) {
            String number = entity.getDynamicObject("fbasedataid").getString("number");
            String name = entity.getDynamicObject("fbasedataid").getString("name");
            entityList.add(number);
            xNames.add(name);
            entityNameMap.put(number, name);
        }
    }

    private void drawChart() {
        ArrayList<String> entityList = new ArrayList<String>(10);
        ArrayList<String> xNames = new ArrayList<String>(10);
        ArrayList<Integer> yValues = new ArrayList<Integer>(10);
        HashMap<String, String> entityNameMap = new HashMap<String, String>(16);
        this.setxNames(entityList, xNames, entityNameMap);
        DataSet repeatDataSet = this.getRepeatLogDataSet();
        Map<String, Integer> checkCount = this.getCheckCount(entityList, repeatDataSet);
        entityList.forEach(e -> yValues.add((Integer)checkCount.get(e)));
        this.drawHistogramChart(xNames, yValues);
        this.setRankEntry(checkCount, entityNameMap);
        this.drawPieChart(entityList, entityNameMap, repeatDataSet);
    }

    private Map<String, Integer> getCheckCount(List<String> entityList, DataSet dataSet) {
        HashMap<String, Integer> checkCount = new HashMap<String, Integer>(16);
        entityList.forEach(e -> checkCount.put((String)e, dataSet.copy().filter("destbilltype = '" + e + "'").count("logid", false)));
        return checkCount;
    }

    private DataSet getRepeatLogDataSet() {
        QFilter qFilter = new QFilter("logtype", "=", (Object)"repeatctrl");
        qFilter.and("createtime", "<=", (Object)new Date());
        qFilter.and("createtime", ">=", this.getDateMap().get("startdate"));
        return QueryServiceHelper.queryDataSet((String)"payRepeatCount", (String)"fcs_repeatctrllog", (String)"id as logid,destbilltype,destbillid", (QFilter[])qFilter.toArray(), null);
    }

    private void setRankEntry(Map<String, Integer> checkCount, Map<String, String> entityNameMap) {
        LinkedHashMap results = new LinkedHashMap(16);
        checkCount.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).forEach(e -> {
            Integer cfr_ignored_0 = (Integer)results.put(e.getKey(), e.getValue());
        });
        int i = 0;
        this.getModel().deleteEntryData("cardentry");
        for (Map.Entry result : results.entrySet()) {
            this.getModel().createNewEntryRow("cardentry");
            this.getModel().setValue("rank", (Object)(i + 1), i);
            this.getModel().setValue("entitytype", (Object)entityNameMap.get(result.getKey()), i);
            this.getModel().setValue("count", result.getValue(), i);
            if (++i != 10 && i < results.size()) continue;
            break;
        }
        this.getView().updateView("cardentry");
    }

    private void drawPieChart(List<String> entityList, Map<String, String> entityNameMap, DataSet repeatDataSet) {
        Container control = (Container)this.getControl("piechartflexap");
        String keystr = this.getPageCache().get("keys");
        if (EmptyUtil.isNoEmpty((String)keystr)) {
            String[] keys1;
            for (String key : keys1 = keystr.split(",")) {
                control.deleteControls(new String[]{key});
            }
        }
        HashMap<String, Integer> entityBillCount = new HashMap<String, Integer>(16);
        HashMap<String, Integer> coverCount = new HashMap<String, Integer>(16);
        HashMap<String, Set<Long>> noCoverBillId = new HashMap<String, Set<Long>>(16);
        HashMap<String, Set<Long>> coverBillId = new HashMap<String, Set<Long>>(16);
        this.getCoverCount(entityList, repeatDataSet, entityBillCount, coverCount, noCoverBillId, coverBillId);
        CharSequence[] keys = new String[entityBillCount.size()];
        int i = 0;
        for (Map.Entry entityCount : entityBillCount.entrySet()) {
            String entityNumber = (String)entityCount.getKey();
            FlexPanelAp oneBizPanelAp = new FlexPanelAp();
            oneBizPanelAp.setKey(entityNumber);
            keys[i] = entityNumber;
            oneBizPanelAp.setHeight(new LocaleString("250px"));
            oneBizPanelAp.setWidth(new LocaleString("20%"));
            oneBizPanelAp.setGrow(0);
            oneBizPanelAp.setShrink(0);
            control.addControls(Collections.singletonList(oneBizPanelAp.createControl()));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fcs_coverrate");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setTargetKey(entityNumber);
            showParameter.setCustomParam("number", (Object)entityNumber);
            showParameter.setCustomParam("name", (Object)entityNameMap.get(entityNumber));
            showParameter.setCustomParam("totalcount", entityCount.getValue());
            showParameter.setCustomParam("covercount", coverCount.get(entityNumber));
            showParameter.setCustomParam("nocoverbill", (Object)((Set)noCoverBillId.get(entityNumber)).toString());
            showParameter.setCustomParam("coverbill", (Object)((Set)coverBillId.get(entityNumber)).toString());
            this.getView().showForm(showParameter);
            ++i;
        }
        this.getPageCache().put("keys", String.join((CharSequence)",", keys));
    }

    private void getCoverCount(List<String> entityList, DataSet repeatDataSet, Map<String, Integer> entityBillCount, Map<String, Integer> coverCount, Map<String, Set<Long>> noCoverBillId, Map<String, Set<Long>> coverBillId) {
        for (String entity : entityList) {
            String sourceBillField = "cas_agentpaybill".equals(entity) ? "hsourcebillid" : "sourcebillid";
            QFilter qFilter = new QFilter(sourceBillField, "!=", (Object)0L);
            qFilter.and(sourceBillField, "is not null", null);
            qFilter.and("createtime", "<=", (Object)new Date());
            qFilter.and("createtime", ">=", this.getDateMap().get("startdate"));
            DataSet entityDataSet = QueryServiceHelper.queryDataSet((String)entity, (String)entity, (String)"id as billid", (QFilter[])qFilter.toArray(), null);
            DataSet dataSet = repeatDataSet.copy().filter("destbilltype = '" + entity + "'");
            HashSet<Long> noCoverId = new HashSet<Long>();
            for (Row row : entityDataSet.copy()) {
                noCoverId.add(row.getLong("billid"));
            }
            if (entityDataSet.isEmpty()) continue;
            entityBillCount.put(entity, noCoverId.size());
            DataSet joinDataSet = entityDataSet.join(dataSet).on("billid", "destbillid").select(new String[]{"billid", "destbillid", "logid"}).finish();
            HashSet<Long> coverId = new HashSet<Long>();
            for (Row row : joinDataSet.copy()) {
                coverId.add(row.getLong("destbillid"));
            }
            coverBillId.put(entity, coverId);
            noCoverId.removeIf(coverId::contains);
            noCoverBillId.put(entity, noCoverId);
            coverCount.put(entity, coverId.size());
        }
    }

    private void drawHistogramChart(List<String> xNames, List<Integer> yValues) {
        Chart customChart = (Chart)this.getControl("histogramchartap");
        customChart.clearData();
        customChart.setDraggable(true);
        customChart.setShowTooltip(true);
        customChart.setTitleAlign(XAlign.left, YAlign.top);
        customChart.setMargin(Position.left, "20px");
        customChart.setMargin(Position.right, "10px");
        BarSeries barSeries = customChart.createBarSeries(ResManager.loadKDString((String)"\u6821\u9a8c\u6b21\u6570", (String)"PayRepeatColumnCardPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        if (xNames.size() < 6) {
            barSeries.setBarWidth("100");
        } else if (xNames.size() < 11) {
            barSeries.setBarWidth("30");
        }
        Axis xAxis = customChart.createXAxis("", AxisType.category);
        xAxis.setCategorys(xNames);
        Axis yAxis = customChart.createYAxis(ResManager.loadKDString((String)"\u6821\u9a8c\u6b21\u6570", (String)"PayRepeatColumnCardPlugin_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]), AxisType.value);
        barSeries.setColor("#276ff5");
        for (Integer amount : yValues) {
            barSeries.addData((Number)amount);
        }
        this.setLineColor(xAxis);
        this.setLineColor(yAxis);
        customChart.refresh();
    }

    private void setLineColor(Axis axix) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", "#666666");
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private Map<String, Object> getDateMap() {
        String range;
        Date curtime = new Date();
        HashMap<String, Object> dateMap = new HashMap<String, Object>(8);
        switch (range = (String)this.getModel().getValue("time")) {
            case "today": {
                dateMap.put("startdate", DateUtils.truncateDate((Date)curtime));
                break;
            }
            case "thisweek": {
                dateMap.put("startdate", DateUtils.getFirstDayOfWeek((Date)DateUtils.truncateDate((Date)curtime)));
                break;
            }
            case "rescentmonth": {
                dateMap.put("startdate", DateUtils.getLastMonth((Date)curtime, (int)1));
            }
        }
        return dateMap;
    }
}

