/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.tmc.fbp.common.bean.BalanceModelBean;
import kd.tmc.fbp.common.enums.CalFormulaEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceModelCardPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"viewdeatil"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam("bean");
        BalanceModelBean bean = (BalanceModelBean)SerializationUtils.fromJsonString((String)json, BalanceModelBean.class);
        String calFormula = bean.getCalFormula();
        String isCalCardFirst = (String)this.getView().getFormShowParameter().getCustomParam("isCalCardFirst");
        boolean isShowDetail = bean.isShowDetail();
        this.getView().setVisible(Boolean.valueOf(isShowDetail), new String[]{"viewdeatil"});
        Label left = (Label)this.getControl("left");
        left.setText(CalFormulaEnum.getSymbol((String)calFormula));
        if ("true".equals(isCalCardFirst) && CalFormulaEnum.ADD.getValue().equals(calFormula)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"leftflex"});
        }
        Label explain = (Label)this.getControl("explain");
        explain.setText(bean.getExplain());
        Label calBill = (Label)this.getControl("calbill");
        calBill.setText(bean.getCalBillName());
        Label lastTime = (Label)this.getControl("lasttime");
        lastTime.setText(bean.getLastTimeStr());
        this.getModel().setValue("amount", (Object)bean.getAmount());
        this.getModel().setValue("currency", (Object)bean.getCurrency());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        if (evt.getSource() instanceof Control && "viewdeatil".equals(key = ((Control)evt.getSource()).getKey())) {
            String json = (String)this.getView().getFormShowParameter().getCustomParam("bean");
            BalanceModelBean bean = (BalanceModelBean)SerializationUtils.fromJsonString((String)json, BalanceModelBean.class);
            String detailEntity = bean.getDetailEntity();
            Set detailIds = bean.getDetailIds();
            if ("cas_bankjournalformrpt".equals(detailEntity) && bean.getAmount().compareTo(BigDecimal.ZERO) != 0) {
                ReportShowParameter showParameter = new ReportShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setFormId("cas_bankjournalformrpt");
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.addFilterItem("org", (Object)bean.getCompanyId());
                filterInfo.addFilterItem("accountbank", (Object)bean.getAccountId());
                filterInfo.addFilterItem("currency", (Object)bean.getCurrency());
                filterInfo.addFilterItem("datetype", (Object)"2");
                filterInfo.addFilterItem("begindate", (Object)DateUtils.getCurrentDate());
                filterInfo.addFilterItem("enddate", (Object)DateUtils.getCurrentDate());
                showParameter.setCustomParam("balance_filter", (Object)SerializationUtils.serializeToBase64((Object)filterInfo));
                showParameter.addCustPlugin("kd.bos.ext.tmc.plugin.BankJournalInitQueryReportPlugin");
                this.getView().showForm((FormShowParameter)showParameter);
            } else if (EmptyUtil.isNoEmpty((String)detailEntity) && EmptyUtil.isNoEmpty((Object)detailIds)) {
                if (detailIds.size() > 1 || "bei_bankbalance".equals(detailEntity)) {
                    ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)detailEntity, (boolean)false);
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    qFilters.add(new QFilter("id", "in", (Object)detailIds));
                    showParameter.getListFilterParameter().setQFilters(qFilters);
                    if (!"bei_bankbalance".equals(detailEntity)) {
                        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewdeatil;" + detailEntity));
                    }
                    this.getView().showForm((FormShowParameter)showParameter);
                } else {
                    this.showBillParameter(detailEntity, (Long)detailIds.iterator().next());
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        ListSelectedRowCollection rows;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (actionId.contains("viewdeatil") && EmptyUtil.isNoEmpty((Object)(rows = (ListSelectedRowCollection)e.getReturnData()))) {
            Long pkValue = (Long)rows.get(0).getPrimaryKeyValue();
            this.showBillParameter(actionId.split(";")[1], pkValue);
        }
    }

    private void showBillParameter(String detailEntity, Long pkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(detailEntity);
        showParameter.setPkId((Object)pkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

