/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.model;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.tmc.fbp.common.bean.BalanceModelBean;
import kd.tmc.fbp.common.helper.BalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceModelDynamicPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        String showFormModel;
        super.afterBindData(e);
        String operatePanel = (String)this.getView().getFormShowParameter().getCustomParam("operatepanel");
        if ("hidden".equals(operatePanel)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"operatepanel", "titlepanel"});
        }
        if (!"true".equals(showFormModel = (String)this.getView().getFormShowParameter().getCustomParam("showformmodel"))) {
            String balanceModelId = (String)this.getView().getFormShowParameter().getCustomParam("balanceModelId");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"billid", (Object)Long.parseLong(balanceModelId));
            String accountId = (String)this.getView().getFormShowParameter().getCustomParam("accountId");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"accountbank", (Object)Long.parseLong(accountId));
            String currencyId = (String)this.getView().getFormShowParameter().getCustomParam("currencyId");
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", (Object)Long.parseLong(currencyId));
        }
        this.loadCardInfo();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("refresh".equals(operateKey) && opResult.isSuccess()) {
            this.loadCardInfo();
        }
    }

    private void loadCardInfo() {
        List beanLists;
        Container control = (Container)this.getControl("contentpanel");
        String keyStr = this.getPageCache().get("keyList");
        if (EmptyUtil.isNoEmpty((String)keyStr)) {
            List keyList = (List)SerializationUtils.fromJsonString((String)keyStr, List.class);
            control.deleteControls(keyList.toArray(new String[0]));
            this.getPageCache().remove("keyList");
        }
        String time = DateUtils.formatString((Date)DateUtils.getCurrentTime(), (String)"yyyy-MM-dd HH:mm:ss");
        Label timeLabel = (Label)this.getControl("time");
        timeLabel.setText(ResManager.loadKDString((String)"\uff08\u66f4\u65b0\u65f6\u95f4\uff1a%s\uff09", (String)"BalanceModelDynamicPlugin_0", (String)"tmc-fcs-formplugin", (Object[])new Object[]{time}));
        String showFormModel = (String)this.getView().getFormShowParameter().getCustomParam("showformmodel");
        if ("true".equals(showFormModel)) {
            JSONArray jsonArray = (JSONArray)this.getView().getFormShowParameter().getCustomParam("balancemodelbean");
            beanLists = jsonArray.toJavaList(BalanceModelBean.class);
        } else {
            Long billid = (Long)this.getModel().getValue("billid");
            DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
            long accountId = accountBank.getLong("id");
            DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
            long currencyId = currency.getLong("id");
            beanLists = BalanceModelHelper.getBalaceModelBeanList((long)billid, (long)accountId, (long)currencyId);
        }
        String title = beanLists.stream().filter(s -> !s.isCalCard()).map(BalanceModelBean::getBalanceType).findFirst().orElse(null);
        Label titleLabel = (Label)this.getControl("title");
        titleLabel.setText(title);
        ArrayList<String> keyList = new ArrayList<String>(10);
        for (int i = 0; i < beanLists.size(); ++i) {
            FlexPanelAp flex = new FlexPanelAp();
            BalanceModelBean bean = (BalanceModelBean)beanLists.get(i);
            String key = "card" + i;
            keyList.add(key);
            flex.setKey(key);
            flex.setGrow(0);
            flex.setShrink(0);
            control.addControls(Collections.singletonList(flex.createControl()));
            String formId = "fcs_balancemodel_card";
            if (!bean.isCalCard()) {
                formId = "fcs_bankmodel_card";
            }
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(formId);
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("card" + i);
            showParameter.setCustomParam("bean", (Object)SerializationUtils.toJsonString((Object)bean));
            if (i == 1) {
                showParameter.setCustomParam("isCalCardFirst", (Object)"true");
            }
            this.getView().showForm(showParameter);
        }
        this.getPageCache().put("keyList", SerializationUtils.toJsonString(keyList));
    }
}

