/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.model;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.bean.BalanceModelBean;
import kd.tmc.fbp.common.enums.BalanceTypeEnum;
import kd.tmc.fbp.common.enums.CalFormulaEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceModelEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"accountbank", "calamount", "calaccount", "calcurrency", "applyconditiondesc", "linkaccount", "linkappname", "microservice"});
        BasedataEdit calBill = (BasedataEdit)this.getControl("calbill");
        calBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit linkApp = (BasedataEdit)this.getControl("linkapp");
        linkApp.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBalanceTypeMustInput();
        this.drawModelFormula();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        switch (propName) {
            case "bizbill": {
                rowIndex = this.getModel().getEntryCurrentRowIndex("bizbillset");
                this.getModel().setValue("accountbank", null, rowIndex);
                this.getModel().setValue("accountbankprop", null, rowIndex);
                break;
            }
            case "partcal": {
                this.setDefaultValue();
                this.setBalanceTypeMustInput();
                break;
            }
            case "calbill": {
                this.getModel().setValue("calamount", null, rowIndex);
                this.getModel().setValue("amountprop", null, rowIndex);
                this.getModel().setValue("calaccount", null, rowIndex);
                this.getModel().setValue("accountprop", null, rowIndex);
                this.getModel().setValue("calcurrency", null, rowIndex);
                this.getModel().setValue("currencyprop", null, rowIndex);
                this.getModel().setValue("applycondition_tag", null, rowIndex);
                this.getModel().setValue("applyconditiondesc", null, rowIndex);
                break;
            }
            case "linkapp": {
                this.getModel().setValue("linkaccount", null, rowIndex);
                this.getModel().setValue("linkaccountprop", null, rowIndex);
                this.getModel().setValue("linkappname", null, rowIndex);
                this.getModel().setValue("linkappprop", null, rowIndex);
                break;
            }
            case "custom": {
                boolean custom = (Boolean)this.getModel().getValue("custom", rowIndex);
                if (!custom) {
                    this.getModel().setValue("microservice", null, rowIndex);
                    this.getModel().setValue("mserviceconfig", null, rowIndex);
                    break;
                }
                this.getModel().setValue("calbill", null, rowIndex);
                this.getModel().setValue("linkapp", null, rowIndex);
                break;
            }
            case "applyconditiondesc": {
                this.clearLinkInfo(propName, "applycondition_tag", rowIndex);
                break;
            }
            case "microservice": {
                this.clearLinkInfo(propName, "mserviceconfig", rowIndex);
                break;
            }
            case "calamount": {
                this.clearLinkInfo(propName, "amountprop", rowIndex);
                break;
            }
            case "calaccount": {
                this.clearLinkInfo(propName, "accountprop", rowIndex);
                break;
            }
            case "calcurrency": {
                this.clearLinkInfo(propName, "currencyprop", rowIndex);
                break;
            }
            case "linkaccount": {
                this.clearLinkInfo(propName, "linkaccountprop", rowIndex);
                break;
            }
            case "linkappname": {
                this.clearLinkInfo(propName, "linkappprop", rowIndex);
            }
        }
    }

    private void clearLinkInfo(String propName, String prop, int rowIndex) {
        Object value = this.getModel().getValue(propName, rowIndex);
        if (EmptyUtil.isEmpty((Object)value)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)prop, null, (int)rowIndex);
        }
    }

    private void setDefaultValue() {
        boolean partcal = (Boolean)this.getModel().getValue("partcal");
        if (!partcal) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"balancetype", null);
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"balancetype", (Object)BalanceTypeEnum.BALANCE_BOOK.getValue());
        }
    }

    private void setBalanceTypeMustInput() {
        boolean partcal = (Boolean)this.getModel().getValue("partcal");
        this.getView().setVisible(Boolean.valueOf(partcal), new String[]{"balancetype"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)partcal, (String[])new String[]{"balancetype"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "accountbank": {
                    boolean isPass = this.checkBillMustInput("bizbillset", "bizbill");
                    if (!isPass) break;
                    this.clickEntryInfo("bizbillset", key, "bizbill");
                    break;
                }
                case "calamount": 
                case "calaccount": 
                case "calcurrency": {
                    boolean isPass = this.checkBillMustInput("entry", "calbill");
                    if (!isPass) break;
                    this.clickEntryInfo("entry", key, "calbill");
                    break;
                }
                case "applyconditiondesc": {
                    boolean isPass = this.checkBillMustInput("entry", "calbill");
                    if (!isPass) break;
                    this.clickApplyCondition();
                    break;
                }
                case "linkappname": 
                case "linkaccount": {
                    boolean isPass = this.checkBillMustInput("entry", "linkapp");
                    if (!isPass) break;
                    this.clickEntryInfo("entry", key, "linkapp");
                    break;
                }
                case "microservice": {
                    this.clickMicroService();
                }
            }
        }
    }

    private boolean checkBillMustInput(String entryName, String prop) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObject bill = (DynamicObject)this.getModel().getValue(prop, rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)bill)) {
            if ("calbill".equals(prop)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u53c2\u4e0e\u8ba1\u7b97\u5355\u636e\uff08\u6216\u57fa\u7840\u8d44\u6599\uff09\u3011\u3002", (String)"BalanceModelEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            } else if ("bizbill".equals(prop)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u9002\u7528\u4e1a\u52a1\u5355\u636e\u3011\u3002", (String)"BalanceModelEdit_5", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u5173\u8054\u5e94\u7528\uff08\u6216\u57fa\u7840\u8d44\u6599\uff09\u3011\u3002", (String)"BalanceModelEdit_1", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private void clickEntryInfo(String entryName, String key, String prop) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObject calBill = (DynamicObject)this.getModel().getValue(prop, rowIndex);
        String billNumber = calBill.getString("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
        PropTreeBuildOption option = null;
        if ("calamount".equals(key)) {
            option = new PropTreeBuildOption();
            option.addMatchedClassTypes(AmountProp.class);
            option.addMatchedClassTypes(IntegerProp.class);
            option.addMatchedClassTypes(TextProp.class);
            option.setIncludeBDPropPK(false);
        } else if ("calaccount".equals(key)) {
            option = new PropTreeBuildOption(null, BasedataProp.class);
            option.setIncludeBDPropPK(false);
        } else if ("calcurrency".equals(key)) {
            option = new PropTreeBuildOption(null, CurrencyProp.class);
        } else if ("linkappname".equals(key)) {
            option = new PropTreeBuildOption();
            option.setIncludeBDPropPK(true);
        } else if ("linkaccount".equals(key)) {
            option = new PropTreeBuildOption();
            option.setIncludePKField(true);
        } else if ("accountbank".equals(key)) {
            option = new PropTreeBuildOption(null, BasedataProp.class);
            option.setIncludeBDPropPK(false);
        }
        if (option != null) {
            option.setIncludeBDRefProp(false);
            option.setSpecialTreatmentMulBDProp(true);
            option.setIncludeEntryEntityAsKeyPrefix(true);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(treeNode, key);
        }
    }

    private void clickApplyCondition() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject calBill = (DynamicObject)this.getModel().getValue("calbill", rowIndex);
        String billNumber = calBill.getString("number");
        String json = (String)this.getModel().getValue("applycondition_tag", rowIndex);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(billNumber);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(json, mainType.getName(), fldNodes);
    }

    private void clickMicroService() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        boolean custom = (Boolean)this.getModel().getValue("custom", rowIndex);
        if (!custom) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u662f\u5426\u81ea\u5b9a\u4e49\u201d\u4e3a\u5426\u65f6\uff0c\u4e0d\u5141\u8bb8\u7ef4\u62a4\u5fae\u670d\u52a1\u3002", (String)"BalanceModelEdit_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fcs_microservice");
            parameter.setCustomParam("eventnumber", (Object)"eventnumber");
            parameter.setCustomParam("type", (Object)"cosmic");
            parameter.setCustomParam("config", this.getModel().getValue("mserviceconfig_tag", rowIndex));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mserviceconfig"));
            this.getView().showForm(parameter);
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "false");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("hiddenexpression", "true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "applyconditiondesc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (sourceFldKey) {
            case "accountbank": {
                int row = this.getModel().getEntryCurrentRowIndex("bizbillset");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("bizbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "accountbankprop", sourceFldKey, "bizbillset");
                break;
            }
            case "calamount": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("calbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "amountprop", sourceFldKey, "entry");
                break;
            }
            case "calaccount": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("calbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "accountprop", sourceFldKey, "entry");
                break;
            }
            case "calcurrency": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("calbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "currencyprop", sourceFldKey, "entry");
                break;
            }
            case "applyconditiondesc": {
                this.setApplyConditionInfo((String)returnData);
                break;
            }
            case "linkappname": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("linkapp", row);
                this.receiveSelectField(bizBill, (String)returnData, "linkappprop", sourceFldKey, "entry");
                break;
            }
            case "linkaccount": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("linkapp", row);
                this.receiveSelectField(bizBill, (String)returnData, "linkaccountprop", sourceFldKey, "entry");
                break;
            }
            case "mserviceconfig": {
                if (returnData == null) break;
                JSONObject json = (JSONObject)returnData;
                this.getModel().setValue("mserviceconfig_tag", (Object)json);
                this.getModel().setValue("microservice", json.get((Object)"servicename"));
            }
        }
    }

    private void setApplyConditionInfo(String returnData) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            this.getModel().setValue("applycondition_tag", (Object)returnData, row);
            String desc = condition.getExprDesc();
            if (desc.length() > 50) {
                desc = desc.substring(0, 40) + "......";
            }
            this.getModel().setValue("applyconditiondesc", (Object)desc, row);
        }
    }

    private void receiveSelectField(DynamicObject bizBill, String returnPropName, String filedProp, String fieldName, String entryName) {
        String billNumber = bizBill.getString("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
        if (!StringUtils.isBlank((CharSequence)returnPropName)) {
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
            int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)filedProp, (Object)returnPropName, (int)rowIndex);
            this.getModel().setValue(fieldName, (Object)fieldCaption, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if (("save".equals(operateKey) || "genmodel".equals(operateKey)) && opResult.isSuccess()) {
            this.drawModelFormula();
        }
    }

    private void drawModelFormula() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entry");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            ArrayList<Object> beanLists = new ArrayList<Object>(10);
            BalanceModelBean bankBean = new BalanceModelBean();
            bankBean.setCalCard(false);
            bankBean.setShowDetail(false);
            DynamicObject modelType = (DynamicObject)this.getModel().getValue("modeltype");
            if (EmptyUtil.isNoEmpty((DynamicObject)modelType)) {
                bankBean.setBalanceType(modelType.getString("name"));
            }
            beanLists.add(bankBean);
            boolean partCal = (Boolean)this.getModel().getValue("partcal");
            if (partCal) {
                Iterator bean = new BalanceModelBean();
                bean.setShowDetail(false);
                bean.setCalFormula(CalFormulaEnum.ADD.getValue());
                bean.setExplain(ResManager.loadKDString((String)"\u5373\u65f6\u4f59\u989d", (String)"BalanceModelEdit_3", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                beanLists.add(bean);
            }
            for (DynamicObject entry : entrys) {
                BalanceModelBean bean = new BalanceModelBean();
                bean.setShowDetail(false);
                bean.setCalFormula(entry.getString("calformula"));
                DynamicObject calBill = entry.getDynamicObject("calbill");
                if (EmptyUtil.isNoEmpty((DynamicObject)calBill)) {
                    bean.setCalBillName(calBill.getString("name"));
                }
                bean.setExplain(entry.getString("explain"));
                beanLists.add(bean);
            }
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fp_model"});
            Container control = (Container)this.getView().getControl("fp_model");
            control.deleteControls(new String[]{"recordcontain"});
            FlexPanelAp flexPanelAp = new FlexPanelAp();
            flexPanelAp.setCollapsible(false);
            flexPanelAp.setDefaultcollapse(false);
            flexPanelAp.setKey("recordcontain");
            control.addControls(Collections.singletonList(flexPanelAp.createControl()));
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fcs_balancemodel_show");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey("recordcontain");
            showParameter.setCustomParam("operatepanel", (Object)"hidden");
            showParameter.setCustomParam("balancemodelbean", beanLists);
            showParameter.setCustomParam("showformmodel", (Object)"true");
            this.getView().showForm(showParameter);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fp_model"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("calbill".equals(key) || "linkapp".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean custom = (Boolean)this.getModel().getValue("custom", rowIndex);
            if (custom) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5f00\u5173\u4e3a\u662f\u4e0d\u9700\u8981\u8bbe\u7f6e\u6b64\u4fe1\u606f\u3002", (String)"BalanceModelEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

