/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.model;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.BalanceModelHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BalanceModelQueryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit currency = (BasedataEdit)this.getControl("currency");
        currency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit account = (BasedataEdit)this.getControl("accountbank");
        account.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long billId = (Long)this.getView().getFormShowParameter().getCustomParam("billid");
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"billid", (Object)billId);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject accountBank;
        DynamicObject defaultCurrency;
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if ("accountbank".equals(propName) && EmptyUtil.isNoEmpty((DynamicObject)(defaultCurrency = (accountBank = (DynamicObject)this.getModel().getValue("accountbank")).getDynamicObject("defaultcurrency")))) {
            this.getModel().setValue("currency", defaultCurrency.getPkValue());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String propName = evt.getProperty().getName();
        if ("currency".equals(propName)) {
            boolean mustInput = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"accountbank");
            if (!mustInput) {
                evt.setCancel(true);
            } else {
                DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
                DynamicObjectCollection currencys = accountBank.getDynamicObjectCollection("currency");
                List currencyIds = currencys.stream().map(s -> s.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", currencyIds);
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParam = showParameter.getListFilterParameter();
                filterParam.getQFilters().add(qFilter);
            }
        } else if ("accountbank".equals(propName)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParam = showParameter.getListFilterParameter();
            QFilter qFilter = new QFilter("company", "=", (Object)RequestContext.get().getOrgId());
            filterParam.getQFilters().add(qFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        if ("query".equals(operateKey) && opResult.isSuccess()) {
            this.drawModelFormula();
        }
    }

    private void drawModelFormula() {
        Long billid = (Long)this.getModel().getValue("billid");
        DynamicObject accountBank = (DynamicObject)this.getModel().getValue("accountbank");
        long accountId = accountBank.getLong("id");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        long currencyId = currency.getLong("id");
        BalanceModelHelper.drawModelFormula((IFormView)this.getView(), (long)billid, (long)accountId, (long)currencyId);
    }
}

