/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.model;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CountModelEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"accountbank", "calcount", "countprop", "calaccount", "calcurrency", "applyconditiondesc", "microservice"});
        BasedataEdit calBill = (BasedataEdit)this.getControl("calbill");
        calBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        switch (propName) {
            case "bizbill": {
                rowIndex = this.getModel().getEntryCurrentRowIndex("bizbillset");
                this.getModel().setValue("accountbank", null, rowIndex);
                this.getModel().setValue("accountbankprop", null, rowIndex);
                break;
            }
            case "calbill": {
                this.getModel().setValue("calcount", null, rowIndex);
                this.getModel().setValue("countprop", null, rowIndex);
                this.getModel().setValue("calaccount", null, rowIndex);
                this.getModel().setValue("accountprop", null, rowIndex);
                this.getModel().setValue("calcurrency", null, rowIndex);
                this.getModel().setValue("currencyprop", null, rowIndex);
                this.getModel().setValue("applycondition_tag", null, rowIndex);
                this.getModel().setValue("applyconditiondesc", null, rowIndex);
                break;
            }
            case "custom": {
                boolean custom = (Boolean)this.getModel().getValue("custom", rowIndex);
                if (!custom) {
                    this.getModel().setValue("microservice", null, rowIndex);
                    this.getModel().setValue("mserviceconfig", null, rowIndex);
                    break;
                }
                this.getModel().setValue("calbill", null, rowIndex);
                break;
            }
            case "applyconditiondesc": {
                this.clearLinkInfo(propName, "applycondition_tag", rowIndex);
                break;
            }
            case "microservice": {
                this.clearLinkInfo(propName, "mserviceconfig", rowIndex);
                break;
            }
            case "calaccount": {
                this.clearLinkInfo(propName, "accountprop", rowIndex);
                break;
            }
            case "calcurrency": {
                this.clearLinkInfo(propName, "currencyprop", rowIndex);
            }
        }
    }

    private void clearLinkInfo(String propName, String prop, int rowIndex) {
        Object value = this.getModel().getValue(propName, rowIndex);
        if (EmptyUtil.isEmpty((Object)value)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)prop, null, (int)rowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Control) {
            String key;
            switch (key = ((Control)evt.getSource()).getKey()) {
                case "accountbank": {
                    boolean isPass = this.checkBillMustInput(key, "bizbillset", "bizbill");
                    if (!isPass) break;
                    this.clickEntryInfo("bizbillset", key, "bizbill");
                    break;
                }
                case "calcount": 
                case "calaccount": 
                case "calcurrency": {
                    boolean isPass = this.checkBillMustInput(key, "entry", "calbill");
                    if (!isPass) break;
                    this.clickEntryInfo("entry", key, "calbill");
                    break;
                }
                case "applyconditiondesc": {
                    boolean isPass = this.checkBillMustInput(key, "entry", "calbill");
                    if (!isPass) break;
                    this.clickApplyCondition();
                    break;
                }
                case "microservice": {
                    this.clickMicroService();
                }
            }
        }
    }

    private boolean checkBillMustInput(String key, String entryName, String prop) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObject bill = (DynamicObject)this.getModel().getValue(prop, rowIndex);
        if (EmptyUtil.isEmpty((DynamicObject)bill)) {
            if ("calbill".equals(prop)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u53c2\u4e0e\u8ba1\u7b97\u5355\u636e\uff08\u6216\u57fa\u7840\u8d44\u6599\uff09\u3011\u3002", (String)"BalanceModelEdit_0", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            } else if ("bizbill".equals(prop)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010\u9002\u7528\u4e1a\u52a1\u5355\u636e\u3011\u3002", (String)"BalanceModelEdit_5", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if ("entry".equals(entryName)) {
            if (key.equals("calcount") && !"am_strategy".equals(bill.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u3010\u53c2\u4e0e\u8ba1\u7b97\u5355\u636e\uff08\u6216\u57fa\u7840\u8d44\u6599\uff09\u3011\u4e3a\u8d26\u6237\u7ba1\u7406\u7b56\u7565\u65f6\uff0c\u624d\u9700\u8981\u7ef4\u62a4\u6b64\u5b57\u6bb5\u3002", (String)"BalanceModelEdit_7", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!key.equals("calcount") && "am_strategy".equals(bill.getString("number"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u3010\u53c2\u4e0e\u8ba1\u7b97\u5355\u636e\uff08\u6216\u57fa\u7840\u8d44\u6599\uff09\u3011\u4e3a\u8d26\u6237\u7ba1\u7406\u7b56\u7565\u65f6\uff0c\u4e0d\u9700\u8981\u7ef4\u62a4\u6b64\u5b57\u6bb5\u3002", (String)"BalanceModelEdit_6", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void clickEntryInfo(String entryName, String key, String prop) {
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
        DynamicObject calBill = (DynamicObject)this.getModel().getValue(prop, rowIndex);
        String billNumber = calBill.getString("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
        PropTreeBuildOption option = null;
        if ("calaccount".equals(key)) {
            option = new PropTreeBuildOption(null, BasedataProp.class);
            option.setIncludeBDPropPK(false);
        } else if ("calcurrency".equals(key)) {
            option = new PropTreeBuildOption(null, CurrencyProp.class);
        } else if ("accountbank".equals(key)) {
            option = new PropTreeBuildOption(null, BasedataProp.class);
            option.setIncludeBDPropPK(false);
        } else if ("calcount".equals(key)) {
            option = new PropTreeBuildOption();
            option.addMatchedClassTypes(IntegerProp.class);
            option.setIncludeBDPropPK(false);
            option.setIncludeChildEntity(false);
        }
        if (option != null) {
            option.setIncludeBDRefProp(false);
            option.setSpecialTreatmentMulBDProp(true);
            option.setIncludeEntryEntityAsKeyPrefix(true);
            TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(treeNode, key);
        }
    }

    private void clickApplyCondition() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject calBill = (DynamicObject)this.getModel().getValue("calbill", rowIndex);
        String billNumber = calBill.getString("number");
        String json = (String)this.getModel().getValue("applycondition_tag", rowIndex);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setCurrentEntity(billNumber);
        TreeNode billTreeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
        this.showConditionForm(json, mainType.getName(), fldNodes);
    }

    private void clickMicroService() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        boolean custom = (Boolean)this.getModel().getValue("custom", rowIndex);
        if (!custom) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u662f\u5426\u81ea\u5b9a\u4e49\u201d\u4e3a\u5426\u65f6\uff0c\u4e0d\u5141\u8bb8\u7ef4\u62a4\u5fae\u670d\u52a1\u3002", (String)"BalanceModelEdit_2", (String)"tmc-fcs-formplugin", (Object[])new Object[0]));
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fcs_microservice");
            parameter.setCustomParam("eventnumber", (Object)"eventnumber");
            parameter.setCustomParam("type", (Object)"cosmic");
            parameter.setCustomParam("config", this.getModel().getValue("mserviceconfig_tag", rowIndex));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "mserviceconfig"));
            this.getView().showForm(parameter);
        }
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fcs_ctrlcondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", "false");
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.getCustomParams().put("hiddenexpression", "true");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "applyconditiondesc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (sourceFldKey) {
            case "accountbank": {
                int row = this.getModel().getEntryCurrentRowIndex("bizbillset");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("bizbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "accountbankprop", sourceFldKey, "bizbillset");
                break;
            }
            case "calcount": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("calbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "countprop", sourceFldKey, "entry");
                break;
            }
            case "calaccount": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("calbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "accountprop", sourceFldKey, "entry");
                break;
            }
            case "calcurrency": {
                int row = this.getModel().getEntryCurrentRowIndex("entry");
                DynamicObject bizBill = (DynamicObject)this.getModel().getValue("calbill", row);
                this.receiveSelectField(bizBill, (String)returnData, "currencyprop", sourceFldKey, "entry");
                break;
            }
            case "applyconditiondesc": {
                this.setApplyConditionInfo((String)returnData);
                break;
            }
            case "mserviceconfig": {
                if (returnData == null) break;
                JSONObject json = (JSONObject)returnData;
                this.getModel().setValue("mserviceconfig_tag", (Object)json);
                this.getModel().setValue("microservice", json.get((Object)"servicename"));
            }
        }
    }

    private void setApplyConditionInfo(String returnData) {
        if (StringUtils.isNotBlank((CharSequence)returnData)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
            int row = this.getModel().getEntryCurrentRowIndex("entry");
            this.getModel().setValue("applycondition_tag", (Object)returnData, row);
            String desc = condition.getExprDesc();
            if (desc.length() > 50) {
                desc = desc.substring(0, 40) + "......";
            }
            this.getModel().setValue("applyconditiondesc", (Object)desc, row);
        }
    }

    private void receiveSelectField(DynamicObject bizBill, String returnPropName, String filedProp, String fieldName, String entryName) {
        String billNumber = bizBill.getString("number");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billNumber);
        if (!StringUtils.isBlank((CharSequence)returnPropName)) {
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)mainType, (String)returnPropName);
            int rowIndex = this.getModel().getEntryCurrentRowIndex(entryName);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)filedProp, (Object)returnPropName, (int)rowIndex);
            this.getModel().setValue(fieldName, (Object)fieldCaption, rowIndex);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("calbill".equals(key)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
            boolean custom = (Boolean)this.getModel().getValue("custom", rowIndex);
            if (custom) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fae\u670d\u52a1\u5f00\u5173\u4e3a\u662f\u4e0d\u9700\u8981\u8bbe\u7f6e\u6b64\u4fe1\u606f\u3002", (String)"BalanceModelEdit_4", (String)"tmc-cim-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }
}

