/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fcs.formplugin.payaccess;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fcs.common.helper.BillTreeBuildParameter;
import kd.tmc.fcs.common.helper.EntityParseHelper;

public class PayAccessEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit destLkField = (TextEdit)this.getControl("destlkfield");
        destLkField.addButtonClickListener((ClickListener)this);
        TextEdit destLkPkField = (TextEdit)this.getControl("destlkpkfield");
        destLkPkField.addButtonClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSrcEntityMustInput();
        this.setLkMustInput();
        this.setCustomShowOrHiden();
    }

    public void afterLoadData(EventObject e) {
        this.checkBaseDateRefrence();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "iscustomentity": {
                this.setSrcEntityMustInput();
                this.setCustomShowOrHiden();
                this.clearSrcEntityInfo();
                break;
            }
            case "destentity": {
                this.getModel().setValue("destlkfield", null);
                this.getModel().setValue("destlkpkfield", null);
                this.checkRuleInfo();
                break;
            }
            case "srcentity": {
                this.checkRuleInfo();
                break;
            }
            case "isbotpadd": {
                this.setCustomShowOrHiden();
                this.setLkMustInput();
                this.clearLkInfo();
            }
        }
    }

    private void setSrcEntityMustInput() {
        boolean isCustomEntity = (Boolean)this.getModel().getValue("iscustomentity");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isCustomEntity ? 1 : 0) != 0, (String[])new String[]{"srcentity"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isCustomEntity, (String[])new String[]{"customsign"});
        if (isCustomEntity) {
            this.getModel().setValue("isbotpadd", (Object)false);
            this.getModel().setValue("srcentity", null);
        } else {
            this.getModel().setValue("customsign", null);
        }
        this.getView().setVisible(Boolean.valueOf(!isCustomEntity), new String[]{"isbotpadd", "srcentity"});
    }

    private void clearSrcEntityInfo() {
        boolean isCustomEntity = (Boolean)this.getModel().getValue("iscustomentity");
        if (isCustomEntity) {
            this.getModel().setValue("srcentity", null);
        } else {
            this.getModel().setValue("customsign", null);
        }
    }

    private void clearLkInfo() {
        boolean isBotpAdd = (Boolean)this.getModel().getValue("isbotpadd");
        if (isBotpAdd) {
            this.getModel().setValue("destlkfield", null);
            this.getModel().setValue("destlkpkfield", null);
        }
    }

    public void click(EventObject evt) {
        String key;
        if (evt.getSource() instanceof Control && ("destlkfield".equals(key = ((Control)evt.getSource()).getKey()) || "destlkpkfield".equals(key))) {
            this.showSelectField(key);
        }
    }

    private void showSelectField(String key) {
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue("destentity");
        if (EmptyUtil.isEmpty((DynamicObject)destEntity)) {
            TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"destentity");
        } else {
            TreeNode treeNode;
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tmc_selectfield");
            MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)destEntity.getString("number"));
            if ("destlkfield".equals(key)) {
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
                treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
            } else {
                PropTreeBuildOption option = new PropTreeBuildOption();
                option.setCurrentEntity(destEntity.getString("number"));
                option.setIncludeChildEntity(false);
                option.setIncludeBDPropPK(false);
                option.setOnlyPhysicsField(true);
                option.setIncludeEntryEntityAsKeyPrefix(true);
                treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceMainType, (PropTreeBuildOption)option);
            }
            String toJson = SerializationUtils.toJsonString((Object)treeNode);
            showParameter.getCustomParams().put("treenodes", toJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String returnData = (String)e.getReturnData();
        switch (e.getActionId()) {
            case "destlkfield": {
                if (returnData == null || !returnData.contains(ResManager.loadKDString((String)"%s\u5185\u7801", (String)"PayAccessEdit_1", (String)"tmc-fcs-common", (Object[])new Object[]{"."}))) break;
                String[] split = returnData.split(",");
                this.getModel().setValue("destlkfield", (Object)split[0]);
                break;
            }
            case "destlkpkfield": {
                if (returnData == null) break;
                this.getModel().setValue("destlkpkfield", (Object)returnData.split(",")[0]);
            }
        }
    }

    private void setLkMustInput() {
        boolean isBotpAdd = (Boolean)this.getModel().getValue("isbotpadd");
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (!isBotpAdd ? 1 : 0) != 0, (String[])new String[]{"destlkfield", "destlkpkfield"});
    }

    private void setCustomShowOrHiden() {
        boolean isBotpAdd = (Boolean)this.getModel().getValue("isbotpadd");
        boolean isCustomEntity = (Boolean)this.getModel().getValue("iscustomentity");
        this.getView().setVisible(Boolean.valueOf(isCustomEntity || !isBotpAdd), new String[]{"destlkpkfield", "fieldgrouppanelap", "destlkfield"});
        this.getView().setVisible(Boolean.valueOf(isCustomEntity), new String[]{"customsign"});
    }

    private void checkBaseDateRefrence() {
        DynamicObject inverstModel = this.getModel().getDataEntity();
        boolean refrenced = BaseDataRefrenceHelper.isRefrenced((String)this.getModel().getDataEntity().getDataEntityType().getName(), (Object)inverstModel.getPkValue());
        if (refrenced) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    private void checkRuleInfo() {
        DynamicObject destEntity = (DynamicObject)this.getModel().getValue("destentity");
        DynamicObject srcEntity = (DynamicObject)this.getModel().getValue("srcentity");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{destEntity, srcEntity})) {
            String srcNumber = srcEntity.getString("number");
            String destNumber = destEntity.getString("number");
            List rules = ConvertRuleCache.loadRules((String)srcNumber, (String)destNumber);
            this.getModel().setValue("isbotpadd", (Object)EmptyUtil.isNoEmpty((Object)rules));
            this.getModel().setValue("number", (Object)(srcNumber + " -> " + destNumber));
            this.getModel().setValue("name", (Object)(srcEntity.getString("name") + " -> " + destEntity.getString("name")));
        }
    }
}

